/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.math;

import jv.number.PuComplex;

public class EllipticFunctions {
    private static final double sqrtPI = Math.sqrt(Math.PI);
    private static final double PIsquare = Math.pow(Math.PI, 2.0);
    private static final double prec = 1.0E-5;
    private static final double lnPrec = Math.log(1.0E-5);
    private static final PuComplex A = new PuComplex();
    private static final PuComplex B = new PuComplex();
    private static final PuComplex C = new PuComplex();
    private static final PuComplex XA = new PuComplex();
    private static final PuComplex XB = new PuComplex();
    private static final PuComplex XC = new PuComplex();
    private static final int NOI = 10;

    public static PuComplex thetaAdaptive(PuComplex z, PuComplex tau) {
        if (tau.im <= 0.0) {
            return null;
        }
        double t1 = tau.re;
        double t2 = tau.im;
        double z2 = z.im;
        double adNoI = 1.0 / (t2 * sqrtPI) * (Math.sqrt(Math.PI * z2 * z2 - t2 * lnPrec) - sqrtPI * z2);
        adNoI = Math.ceil(adNoI);
        System.out.println("adaptive NoI:" + adNoI);
        if (adNoI >= 20.0) {
            adNoI = 30.0;
        }
        PuComplex sum = new PuComplex(0.0, 0.0);
        int n = 1;
        while ((double)n <= adNoI) {
            double p = Math.PI * (double)(n * n);
            A.set(0.0, p * t1);
            A.exp();
            B.set(-p * t2, 0.0);
            B.exp();
            A.mult(B);
            C.set(Math.PI * 2 * (double)n, 0.0);
            C.mult(z);
            C.cos();
            A.mult(C);
            sum.add(A);
            ++n;
        }
        sum.mult(2.0).add(1.0);
        return sum;
    }

    public static PuComplex theta(PuComplex z, PuComplex tau) {
        if (tau.im <= 0.0) {
            return null;
        }
        double t1 = tau.re;
        double t2 = tau.im;
        PuComplex sum = new PuComplex(0.0, 0.0);
        int n = 1;
        while (n <= 10) {
            double p = Math.PI * (double)(n * n);
            A.set(0.0, p * t1);
            A.exp();
            B.set(-p * t2, 0.0);
            B.exp();
            A.mult(B);
            C.set(Math.PI * 2 * (double)n, 0.0);
            C.mult(z);
            C.cos();
            A.mult(C);
            sum.add(A);
            ++n;
        }
        sum.mult(2.0).add(1.0);
        return sum;
    }

    public static PuComplex theta(PuComplex z, PuComplex tau, PuComplex result) {
        if (result == null) {
            return null;
        }
        if (tau.im <= 0.0) {
            return null;
        }
        double t1 = tau.re;
        double t2 = tau.im;
        result.set(0.0, 0.0);
        int n = 1;
        while (n <= 10) {
            double p = Math.PI * (double)(n * n);
            A.set(0.0, p * t1);
            A.exp();
            B.set(-p * t2, 0.0);
            B.exp();
            A.mult(B);
            C.set(Math.PI * 2 * (double)n, 0.0);
            C.mult(z);
            C.cos();
            A.mult(C);
            result.add(A);
            ++n;
        }
        result.mult(2.0).add(1.0);
        return result;
    }

    public static PuComplex theta01(PuComplex z, PuComplex tau) {
        XA.set(z.re + 0.5, z.im);
        return EllipticFunctions.theta(XA, tau);
    }

    public static PuComplex theta10(PuComplex z, PuComplex tau) {
        double t1 = tau.re;
        double t2 = tau.im;
        double z1 = z.re;
        double z2 = z.im;
        XA.set(0.0, Math.PI);
        XB.set(0.25 * t1 + z1, 0.25 * t2 + z2);
        XA.mult(XB);
        XA.exp();
        XC.set(z1 + 0.5 * t1, z2 + 0.5 * t2);
        return EllipticFunctions.theta(XC, tau).mult(XA);
    }

    public static PuComplex theta11(PuComplex z, PuComplex tau) {
        double t1 = tau.re;
        double t2 = tau.im;
        double z1 = z.re;
        double z2 = z.im;
        XA.set(0.0, Math.PI);
        XB.set(0.25 * t1 + z1 + 0.5, 0.25 * t2 + z2);
        XA.mult(XB);
        XA.exp();
        XC.set(z1 + 0.5 * t1 + 0.5, z2 + 0.5 * t2);
        return EllipticFunctions.theta(XC, tau).mult(XA);
    }

    public static PuComplex weierP(PuComplex z, PuComplex tau) {
        PuComplex theta_square = EllipticFunctions.theta(PuComplex.ZERO, tau).sqr();
        PuComplex theta10_square = EllipticFunctions.theta10(PuComplex.ZERO, tau).sqr();
        PuComplex theta01_square = EllipticFunctions.theta01(z, tau).sqr();
        PuComplex theta11_square = EllipticFunctions.theta11(z, tau).sqr();
        PuComplex theta_to_the_4 = PuComplex.sqr((PuComplex)theta_square);
        PuComplex theta10_to_the_4 = PuComplex.sqr((PuComplex)theta10_square);
        PuComplex sum = theta_to_the_4.add(theta10_to_the_4);
        PuComplex e2 = sum.mult(-PIsquare / 3.0);
        PuComplex quot = theta01_square.div(theta11_square);
        PuComplex prod = quot.mult(theta10_square).mult(theta_square).mult(PIsquare);
        return prod.add(e2);
    }

    public static PuComplex riemannZeta(PuComplex s) {
        s.mult(-1.0);
        PuComplex fz = new PuComplex(0.0, 0.0);
        PuComplex b = new PuComplex(1.0, 0.0);
        int n = 1;
        while (n <= 50) {
            b.set((double)n, 0.0);
            fz.add(PuComplex.pow((PuComplex)b, (PuComplex)s));
            ++n;
        }
        return fz;
    }
}

