/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors.schemes;

import devDomainColoring.colors.PuAbstractColorScheme;
import devDomainColoring.colors.PuColorSchemeIf;
import devDomainColoring.colors.PuColorUtil;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;

public class PuCSRadialLines2d
extends PuAbstractColorScheme
implements PuColorSchemeIf {
    private static final int DEFAULT_NUMBER_OF_RAYS = 12;
    private static final int DEFAULT_BRIGHTNESS = 250;
    protected PuInteger m_nor = new PuInteger("Number of Rays");
    protected PuInteger m_brightness;
    private static final float EPS = 0.03f;

    public PuCSRadialLines2d() {
        this(12, 250);
    }

    public PuCSRadialLines2d(int nor, int brightness) {
        super(2, "Radial Lines");
        this.m_nor.setBounds(0, 32);
        this.m_nor.addUpdateListener((PsUpdateIf)this);
        this.m_brightness = new PuInteger("Ray Brightness");
        this.m_brightness.setBounds(0, 255);
        this.m_brightness.addUpdateListener((PsUpdateIf)this);
        this.m_nor.setValue(nor);
        this.m_brightness.setValue(brightness);
    }

    public int getColorImpl(double x, double y) {
        double arg = Math.atan2(y, x) + Math.PI;
        int alpha = 255;
        float peaks = (float)(Math.PI * 2 / (double)this.m_nor.getValue());
        double rem = arg % (double)peaks;
        double s = rem <= (double)0.03f ? rem / (double)0.03f : (rem >= (double)(peaks - 0.03f) ? ((double)peaks - rem) / (double)0.03f : 1.0);
        int b = this.m_brightness.getValue();
        float v = (float)b / 255.0f;
        int h = (int)((s + (double)Math.abs(1.0f - 2.0f * v) * ((double)v - s)) * 255.0);
        double opUnitRays = 0.5 * (1.0 + s) + (double)Math.abs(v - 0.5f) * (s - 1.0);
        alpha = (int)(255.0 * (1.0 - opUnitRays));
        return PuColorUtil.rgbToInt(h, h, h, alpha);
    }

    public int getNumberOfRays() {
        return this.m_nor.getValue();
    }

    public void setRays(int nor) {
        this.m_nor.setValue(nor);
    }

    public int getBrightness() {
        return this.m_brightness.getValue();
    }

    public void setBrightness(int brightness) {
        this.m_brightness.setValue(brightness);
    }

    public boolean update(Object event) {
        return super.update((Object)this);
    }

    @Override
    public int getColor(PdVector v) {
        return this.getColorImpl(v.m_data[0], v.m_data[1]);
    }
}

