/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors.schemes;

import devDomainColoring.colors.PuAbstractColorScheme;
import java.awt.Color;
import jv.number.PuDouble;
import jv.vecmath.PdVector;

public class PuCSPolesAndZeros2d
extends PuAbstractColorScheme {
    double l0 = 0.1;
    double l1 = 0.7;
    double l2 = 1.020847E38f;
    double l3 = 1.7014117331926443E38;
    PuDouble m_zeroBoundaryValue = new PuDouble("Zero Boundary Value");
    PuDouble m_poleBoundaryValue;
    static final double ZERO_BOUNDARY_VALUE = 0.7;
    static final double POLE_BOUNDARY_VALUE = 0.7;

    public PuCSPolesAndZeros2d() {
        super(2, "Poles and Zeros");
        this.m_zeroBoundaryValue.setValue(0.7);
        this.m_poleBoundaryValue = new PuDouble("Pole Boundary Value");
        this.m_poleBoundaryValue.setValue(0.7);
    }

    public int getColorImpl(double x, double y) {
        double abs = Math.sqrt(x * x + y * y);
        int c = 0;
        double weightPole = this.fade(abs, this.l3, this.l3 - this.l2, this.m_poleBoundaryValue.getValue());
        double weightZero = this.fade(abs, this.l0, this.l1 - this.l0, this.m_zeroBoundaryValue.getValue());
        if (abs < this.l0) {
            c = Color.black.getRGB();
        } else if (!(abs < this.l3)) {
            c = Color.white.getRGB();
        }
        return 0;
    }

    @Override
    public String getName() {
        return null;
    }

    private double fade(double x, double zero, double radius, double valAtBoundary) {
        assert (radius > 0.0);
        return Math.exp(Math.log(valAtBoundary) * Math.pow(radius / (x - zero), 2.0));
    }

    @Override
    public int getColor(PdVector v) {
        return this.getColorImpl(v.m_data[0], v.m_data[1]);
    }
}

