/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors.schemes;

import devDomainColoring.colors.PuAbstractColorScheme;
import devDomainColoring.colors.PuColorSchemeIf;
import devDomainColoring.colors.PuColorUtil;
import java.util.ArrayList;
import java.util.List;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;

public class PuCSPolesAndZeros
extends PuAbstractColorScheme
implements PuColorSchemeIf {
    protected static final double[] DEFAULT_LIGHTNESS_THRESHOLDS = new double[]{0.01, 0.5, 8.0, 13.0};
    protected static final String[] DEFAULT_LIGHTNESS_THRESHOLDS_DESCRIPTIONS = new String[]{"Black Region", "Black Fade out", "White region", "White fade in"};
    protected List<PuDouble> m_lightnessThresholds = new ArrayList<PuDouble>(4);

    public PuCSPolesAndZeros() {
        super(2, "Highlight Poles and Zeros");
        int i = 0;
        while (i < 4) {
            PuDouble pd = new PuDouble(DEFAULT_LIGHTNESS_THRESHOLDS_DESCRIPTIONS[i]);
            pd.addUpdateListener((PsUpdateIf)this);
            pd.setValue(DEFAULT_LIGHTNESS_THRESHOLDS[i]);
            pd.setBounds(0.0, DEFAULT_LIGHTNESS_THRESHOLDS[i]);
            this.m_lightnessThresholds.add(pd);
            ++i;
        }
    }

    public int getColorImpl(double x, double y) {
        double abs = Math.sqrt(x * x + y * y);
        float bri = 0.0f;
        int alpha = 255;
        double s = 0.0;
        if (abs < Double.MIN_VALUE) {
            bri = 0.0f;
            s = 0.0;
        } else {
            double l0 = this.m_lightnessThresholds.get(0).getValue();
            double l3 = this.m_lightnessThresholds.get(3).getValue();
            if (abs < l0) {
                bri = 0.0f;
                s = 0.0;
            } else if (abs > l3) {
                bri = 1.0f;
                s = 0.0;
            } else {
                double l1 = this.m_lightnessThresholds.get(1).getValue();
                double l2 = this.m_lightnessThresholds.get(2).getValue();
                if (abs < l1) {
                    bri = 0.0f;
                    s = (abs - l0) / (l1 - l0);
                } else if (abs > l2) {
                    bri = 1.0f;
                    s = 1.0 - (abs - l2) / (l3 - l2);
                } else {
                    s = 1.0;
                }
            }
        }
        int h = (int)bri * 255;
        double opacity = s;
        alpha = (int)(255.0 * (1.0 - opacity));
        return PuColorUtil.rgbToInt(h, h, h, alpha);
    }

    @Override
    public int getColor(PdVector v) {
        return this.getColorImpl(v.m_data[0], v.m_data[1]);
    }
}

