/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors.schemes;

import devDomainColoring.colors.PuAbstractColorScheme;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import jv.object.PsDebug;
import jv.vecmath.PdVector;

public class PuCSPattern2d
extends PuAbstractColorScheme {
    private static final double[] DEFAULT_CELL_DIMENSIONS = new double[]{-1.0, -1.0, 1.0, 1.0};
    private static final int LEFT = 0;
    private static final int BOTTOM = 1;
    private static final int RIGHT = 2;
    private static final int TOP = 3;
    protected static final String DEFAULT_PATTERN_DIRECTORY = String.valueOf(PuCSPattern2d.class.getProtectionDomain().getCodeSource().getLocation().getPath()) + "devDomainColoring/images/";
    protected static final String[] DEFAULT_PATTERNS = new String[]{"redBlueArrows.PNG"};
    protected String m_patternFileName;
    protected PdVector m_cellDimensions = new PdVector(4);
    protected BufferedImage m_pattern;

    public PuCSPattern2d() {
        super(2, "Pattern");
        this.m_cellDimensions.setName("Cell Dimensions");
        this.m_cellDimensions.set(DEFAULT_CELL_DIMENSIONS);
        this.m_patternFileName = String.valueOf(DEFAULT_PATTERN_DIRECTORY) + DEFAULT_PATTERNS[0];
        this.setPattern(String.valueOf(DEFAULT_PATTERN_DIRECTORY) + DEFAULT_PATTERNS[0]);
    }

    public int getColorImpl(double x, double y) {
        double cellWidth = this.m_cellDimensions.m_data[2] - this.m_cellDimensions.m_data[0];
        double cellHeight = this.m_cellDimensions.m_data[3] - this.m_cellDimensions.m_data[1];
        double xCell = (x - this.m_cellDimensions.m_data[0]) % cellWidth;
        double yCell = (y - this.m_cellDimensions.m_data[1]) % cellHeight;
        int patternWidth = this.m_pattern.getWidth();
        int patternHeight = this.m_pattern.getHeight();
        int xPixel = (int)(xCell * (double)patternWidth / cellWidth);
        int yPixel = (int)(yCell * (double)patternHeight / cellHeight);
        if (xPixel < 0) {
            xPixel += patternWidth;
        }
        if (yPixel < 0) {
            yPixel += patternHeight;
        }
        return this.m_pattern.getRGB(xPixel, patternHeight - yPixel - 1);
    }

    public boolean setPattern(String filename) {
        try {
            this.m_pattern = ImageIO.read(new File(filename));
        }
        catch (IOException e) {
            PsDebug.warning((String)("Could not read file " + filename));
            return false;
        }
        return true;
    }

    public boolean update(Object event) {
        if (event == this.m_cellDimensions) {
            return super.update((Object)this);
        }
        return super.update(event);
    }

    @Override
    public int getColor(PdVector v) {
        return this.getColorImpl(v.m_data[0], v.m_data[1]);
    }
}

