/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors.schemes;

import devDomainColoring.colors.PuAbstractColorScheme;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jv.vecmath.PdVector;

public class PuCSHorizontalStripes
extends PuAbstractColorScheme {
    private static final int DEFAULT_NUMBER_OF_STRIPES = 10;
    protected List<Color> m_colors_pos1 = new ArrayList<Color>(4);
    protected List<Color> m_colors_pos2 = new ArrayList<Color>(6);
    protected List<Color> m_colors_neg1 = new ArrayList<Color>(4);
    protected List<Color> m_colors_neg2 = new ArrayList<Color>(6);
    private int colIndex;

    public PuCSHorizontalStripes() {
        super(2, "Horizontal Stripes");
        this.m_colors_pos1.add(new Color(255, 255, 255));
        this.m_colors_pos1.add(new Color(250, 250, 100));
        this.m_colors_pos1.add(new Color(255, 210, 0));
        this.m_colors_pos1.add(new Color(255, 150, 0));
        this.m_colors_pos2.add(new Color(255, 100, 0));
        this.m_colors_pos2.add(new Color(255, 50, 0));
        this.m_colors_pos2.add(new Color(240, 0, 0));
        this.m_colors_pos2.add(new Color(220, 0, 0));
        this.m_colors_pos2.add(new Color(170, 0, 0));
        this.m_colors_pos2.add(new Color(120, 0, 30));
        this.m_colors_neg1.add(new Color(0, 0, 0));
        this.m_colors_neg1.add(new Color(10, 30, 50));
        this.m_colors_neg1.add(new Color(20, 50, 150));
        this.m_colors_neg1.add(new Color(40, 80, 180));
        this.m_colors_neg2.add(new Color(40, 100, 250));
        this.m_colors_neg2.add(new Color(40, 150, 255));
        this.m_colors_neg2.add(new Color(120, 180, 255));
        this.m_colors_neg2.add(new Color(200, 200, 255));
        this.m_colors_neg2.add(new Color(180, 180, 255));
        this.m_colors_neg2.add(new Color(150, 150, 255));
    }

    public int getColorImpl(double x, double y) {
        double alpha = Math.log(2.0) / 4.0;
        double beta = Math.log(3.4028234663852886E38) / 6.0;
        Color col_infty = new Color(192, 192, 192);
        if (0.0 <= y && y < 1.0) {
            int col_y = (int)(Math.log(y + 1.0) / alpha);
            if (col_y == 4) {
                col_y = 3;
            }
            this.setColIndex(col_y);
            return this.m_colors_pos1.get(this.colIndex).getRGB();
        }
        if (y >= 1.0 && y < 3.4028234663852886E38) {
            int col_y = (int)(Math.log(y) / beta);
            this.setColIndex(col_y);
            return this.m_colors_pos2.get(this.colIndex).getRGB();
        }
        double newy = -y;
        if (0.0 < newy && newy < 1.0) {
            int col_y = (int)(Math.log(newy + 1.0) / alpha);
            if (col_y == 4) {
                col_y = 3;
            }
            this.setColIndex(col_y);
            return this.m_colors_neg1.get(this.colIndex).getRGB();
        }
        if (newy >= 1.0 && newy < 3.4028234663852886E38) {
            int col_y = (int)(Math.log(newy) / beta);
            this.setColIndex(col_y);
            return this.m_colors_neg2.get(this.colIndex).getRGB();
        }
        return col_infty.getRGB();
    }

    public void setColIndex(int k) {
        this.colIndex = k;
    }

    @Override
    public int getColor(PdVector v) {
        return this.getColorImpl(v.m_data[0], v.m_data[1]);
    }
}

