/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors.schemes;

import devDomainColoring.colors.PuAbstractColorScheme;
import devDomainColoring.colors.PuColorSchemeIf;
import devDomainColoring.colors.PuColorUtil;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;

public class PuCSGrid
extends PuAbstractColorScheme
implements PuColorSchemeIf {
    private static final int DEFAULT_NUMBER_OF_VERTICAL_LINES = 1;
    private static final int DEFAULT_NUMBER_OF_HORIZONTAL_LINES = 1;
    private static final int DEFAULT_BRIGHTNESS = 250;
    protected PuInteger m_novl = new PuInteger("Vertical Lines");
    protected PuInteger m_nohl = new PuInteger("Horizontal Lines");
    protected PuInteger m_brightness;
    private static final float EPS = 0.05f;

    public PuCSGrid() {
        this(1, 1, 250);
    }

    public PuCSGrid(int novl, int nohl, int brightness) {
        super(2, "Grid");
        this.m_novl.setBounds(1, 50);
        this.m_nohl.setBounds(1, 50);
        this.m_novl.addUpdateListener((PsUpdateIf)this);
        this.m_nohl.addUpdateListener((PsUpdateIf)this);
        this.m_brightness = new PuInteger("Line Brightness");
        this.m_brightness.setBounds(0, 255);
        this.m_brightness.addUpdateListener((PsUpdateIf)this);
        this.m_novl.setValue(novl);
        this.m_nohl.setValue(nohl);
        this.m_brightness.setValue(brightness);
    }

    public int getColorImpl(double x, double y) {
        double s;
        if (Math.abs(x) >= 3.4028234663852886E38 || Math.abs(y) >= 3.4028234663852886E38) {
            s = 1.0;
        } else {
            double log_x = 0.0;
            double log_y = 0.0;
            double dist_x = 0.0;
            double dist_y = 0.0;
            if (x >= 0.0 && x < 1.1) {
                log_x = 4.0 * Math.log(x + 1.0) / Math.log(2.0);
            } else if (x >= 1.1) {
                log_x = (double)(6 * this.m_novl.getValue()) * Math.log(x + 1.0) / Math.log(3.4028234663852886E38);
            } else if (x < 0.0) {
                if ((x = -x) >= 0.0 && x < 1.1) {
                    log_x = 4.0 * Math.log(x + 1.0) / Math.log(2.0);
                } else if (x >= 1.1) {
                    log_x = (double)(6 * this.m_novl.getValue()) * Math.log(x + 1.0) / Math.log(3.4028234663852886E38);
                }
            }
            if (y >= 0.0 && y < 1.1) {
                log_y = 4.0 * Math.log(y + 1.0) / Math.log(2.0);
            } else if (y >= 1.1) {
                log_y = (double)(6 * this.m_nohl.getValue()) * Math.log(y + 1.0) / Math.log(3.4028234663852886E38);
            } else if ((y = -y) >= 0.0 && y < 1.1) {
                log_y = 4.0 * Math.log(y + 1.0) / Math.log(2.0);
            } else if (y >= 1.1) {
                log_y = (double)(6 * this.m_nohl.getValue()) * Math.log(y + 1.0) / Math.log(3.4028234663852886E38);
            }
            int previous_int_x = (int)log_x;
            int next_int_x = previous_int_x + 1;
            double previous_dist_x = Math.abs(log_x - (double)previous_int_x);
            double next_dist_x = Math.abs(log_x - (double)next_int_x);
            int previous_int_y = (int)log_y;
            int next_int_y = previous_int_y + 1;
            double previous_dist_y = Math.abs(log_y - (double)previous_int_y);
            double next_dist_y = Math.abs(log_y - (double)next_int_y);
            dist_x = previous_dist_x >= next_dist_x ? next_dist_x : previous_dist_x;
            dist_y = previous_dist_y >= next_dist_y ? next_dist_y : previous_dist_y;
            s = dist_x <= (double)0.05f && dist_x <= dist_y ? dist_x / (double)0.05f : (dist_y <= (double)0.05f && dist_y <= dist_x ? dist_y / (double)0.05f : 1.0);
        }
        int brightness = 255;
        int b = this.m_brightness.getValue();
        float v = (float)b / 255.0f;
        int h = (int)((s + (double)Math.abs(1.0f - 2.0f * v) * ((double)v - s)) * 255.0);
        double opUnitRays = 0.5 * (1.0 + s) + (double)Math.abs(v - 0.5f) * (s - 1.0);
        brightness = (int)(255.0 * (1.0 - opUnitRays));
        return PuColorUtil.rgbToInt(h, h, h, brightness);
    }

    public boolean update(Object event) {
        if (event == this.m_novl) {
            return super.update((Object)this);
        }
        if (event == this.m_nohl) {
            return super.update((Object)this);
        }
        if (event == this.m_brightness) {
            return super.update((Object)this);
        }
        return super.update(event);
    }

    @Override
    public int getColor(PdVector v) {
        return this.getColorImpl(v.m_data[0], v.m_data[1]);
    }
}

