/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors.schemes;

import devDomainColoring.colors.PuAbstractColorScheme;
import devDomainColoring.colors.PuColorSchemeIf;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jv.number.PuInteger;
import jv.vecmath.PdVector;

public class PuCSDiscrete2d
extends PuAbstractColorScheme
implements PuColorSchemeIf {
    private static final int DEFAULT_NUMBER_OF_CELLS = 4;
    private static final double ZERO_THRESHOLD = 1.0E-10;
    protected PuInteger m_numOfCells = new PuInteger("Number of Cells");
    protected List<Color> m_colors;

    public PuCSDiscrete2d() {
        super(2, "Discrete Color Wheel");
        this.m_numOfCells.setValue(4);
        this.m_colors = new ArrayList<Color>(4);
        this.m_colors.add(new Color(57, 42, 174));
        this.m_colors.add(new Color(147, 0, 0));
        this.m_colors.add(new Color(215, 189, 0));
        this.m_colors.add(new Color(39, 128, 0));
    }

    public int getColorImpl(double x, double y) {
        double arg = Math.atan2(y, x) / (Math.PI * 2) + 0.5;
        double abs = Math.sqrt(x * x + y * y);
        if (abs < 1.0E-10) {
            return Color.black.getRGB();
        }
        assert (arg >= 0.0);
        assert (arg < 1.0);
        int colIndex = (int)Math.floor(arg * (double)this.m_numOfCells.getValue()) % 4;
        return this.m_colors.get(colIndex).getRGB();
    }

    @Override
    public int getColor(PdVector v) {
        return this.getColorImpl(v.m_data[0], v.m_data[1]);
    }
}

