/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors.schemes;

import devDomainColoring.colors.schemes.PuCSCustomColorWheel2d;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import jv.number.PdColor;
import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsPanel;
import jv.object.PsStackLayout;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;

public class PuCSCustomColorWheel2d_IP
extends PsPanel
implements MouseListener,
MouseMotionListener,
ItemListener,
ActionListener {
    protected PuCSCustomColorWheel2d m_colorScheme;
    private TextField m_tNumKeys;
    private TextField m_tCurrentKey;
    private Checkbox m_cSplit;
    private Checkbox m_cActive;
    private PdColor m_cUpperColor;
    private PdColor m_cLowerColor;
    private PuDouble m_angleOffset;
    private PuInteger m_numTeeth;
    private PuDouble m_slope;
    private PuDouble m_intervalOffset;
    private TextField m_tFileName;
    private Button m_bLoad;
    private Button m_bSave;
    protected final int m_padWidth = 640;
    protected final int m_padHeight = 640;
    private final double stateRadius = 0.9;
    private final double colorPadRadius = 0.8;
    private final double centerRadius = 0.25;
    protected PiVector m_pix;
    protected MemoryImageSource m_mis;
    protected PsPanel m_padPanel;
    private static int m_sp = 2;
    private int m_currentIndex = 0;

    public PuCSCustomColorWheel2d_IP() {
        this.setLayout(new BorderLayout());
        this.setInsetSize(8);
        Panel pPadCont = new Panel(new FlowLayout());
        this.m_padPanel = new PsPanel();
        this.m_padPanel.setInsetSize(2);
        this.m_padPanel.setPreferredSize(640 + 2 * m_sp, 640 + 2 * m_sp);
        this.m_padPanel.setBorderType(2);
        this.m_pix = new PiVector((640 + 2 * m_sp) * (640 + 2 * m_sp));
        this.paintWheel();
        this.m_mis = new MemoryImageSource(640 + 2 * m_sp, 640 + 2 * m_sp, this.m_pix.m_data, 0, 640 + 2 * m_sp);
        this.m_mis.setAnimated(true);
        this.m_padPanel.setImage(PsConfig.getFrame().createImage(this.m_mis));
        this.m_padPanel.addMouseListener((MouseListener)this);
        this.m_padPanel.addMouseMotionListener((MouseMotionListener)this);
        this.m_padPanel.validate();
        pPadCont.add((Component)this.m_padPanel);
        this.add(pPadCont, "West");
        PsPanel pControl = new PsPanel((LayoutManager)new PsStackLayout(5));
        pControl.setInsetSize(5);
        pControl.addTitle(PsConfig.getMessage((boolean)true, (int)54000, (String)"Key Colors"));
        PsPanel pTF = new PsPanel((LayoutManager)new GridLayout(2, 2));
        pTF.add((Component)new Label("Number of keys"));
        this.m_tNumKeys = new TextField(8);
        this.m_tNumKeys.addActionListener(this);
        pTF.add((Component)this.m_tNumKeys);
        pTF.add((Component)new Label("Current key"));
        this.m_tCurrentKey = new TextField(8);
        this.m_tCurrentKey.addActionListener(this);
        pTF.add((Component)this.m_tCurrentKey);
        pControl.add((Component)pTF);
        PsPanel pColor = new PsPanel((LayoutManager)new GridLayout(4, 1));
        PsPanel pCheck = new PsPanel((LayoutManager)new GridLayout(1, 2));
        this.m_cActive = new Checkbox("Active", false);
        this.m_cActive.addItemListener(this);
        pCheck.add((Component)this.m_cActive);
        this.m_cSplit = new Checkbox("Split colors", false);
        pCheck.add((Component)this.m_cSplit);
        pColor.add((Component)pCheck);
        this.m_cUpperColor = new PdColor("Upper Color", (PsUpdateIf)this);
        pColor.add((Component)this.m_cUpperColor.newInspector("_IP"));
        this.m_cLowerColor = new PdColor("Lower Color", (PsUpdateIf)this);
        pColor.add((Component)this.m_cLowerColor.newInspector("_IP"));
        this.m_angleOffset = new PuDouble("Angle offset", (PsUpdateIf)this);
        this.m_angleOffset.setDefValue(0.0);
        this.m_angleOffset.setDefBounds(-1.0, 1.0, 0.1, 1.0);
        this.m_angleOffset.setValue(0.0);
        this.m_angleOffset.init();
        pColor.add((Component)this.m_angleOffset.newInspector("_IP"));
        pControl.add((Component)pColor);
        pControl.addLine(1);
        Panel sliderPanel = new Panel(new GridLayout(3, 1));
        this.m_numTeeth = new PuInteger("Number of Levels", (PsUpdateIf)this);
        this.m_numTeeth.setDefValue(48);
        this.m_numTeeth.setDefBounds(1, 256, 1, 12);
        this.m_numTeeth.setValue(48);
        this.m_numTeeth.init();
        sliderPanel.add((Component)this.m_numTeeth.newInspector("_IP"));
        this.m_slope = new PuDouble("Slope in ietervals", (PsUpdateIf)this);
        this.m_slope.setDefValue(-1.0);
        this.m_slope.setDefBounds(-3.0, 3.0, 0.1, 1.0);
        this.m_slope.setValue(-1.0);
        this.m_slope.init();
        sliderPanel.add((Component)this.m_slope.newInspector("_IP"));
        this.m_intervalOffset = new PuDouble("Interval offset", (PsUpdateIf)this);
        this.m_intervalOffset.setDefValue(0.0);
        this.m_intervalOffset.setDefBounds(-1.0, 1.0, 0.1, 1.0);
        this.m_intervalOffset.setValue(0.0);
        this.m_intervalOffset.init();
        sliderPanel.add((Component)this.m_intervalOffset.newInspector("_IP"));
        pControl.add((Component)sliderPanel);
        pControl.addLine(1);
        Panel filePanel = new Panel(new GridLayout(2, 1));
        this.m_tFileName = new TextField(40);
        this.m_tFileName.setText("---");
        filePanel.add(this.m_tFileName);
        Panel bp = new Panel(new FlowLayout());
        this.m_bSave = new Button("Save");
        this.m_bSave.addActionListener(this);
        bp.add(this.m_bSave);
        this.m_bLoad = new Button("Load");
        this.m_bLoad.addActionListener(this);
        bp.add(this.m_bLoad);
        filePanel.add(bp);
        pControl.add((Component)filePanel);
        this.add((Component)pControl, "Center");
        this.validate();
        if (this.getClass() == PuCSCustomColorWheel2d_IP.class) {
            this.init();
        }
    }

    private void paintWheel() {
        int j;
        int numKeys = 6;
        double angleOffset = 0.0;
        if (this.m_colorScheme != null) {
            numKeys = this.m_colorScheme.getNumKeys();
            angleOffset = this.m_colorScheme.getAngleOffset();
        }
        PuComplex position = new PuComplex();
        int i = 0;
        while (i < 640) {
            position.re = (double)(-i) * 2.0 / 638.0 + 1.0;
            j = 0;
            while (j < 640) {
                int index;
                position.im = (double)j * 2.0 / 638.0 - 1.0;
                double radius = position.abs();
                double angle = position.arg() / (Math.PI * 2);
                angle += angleOffset;
                while (angle < 0.0) {
                    angle += 1.0;
                }
                while (angle > 1.0) {
                    angle -= 1.0;
                }
                if (this.m_colorScheme == null) {
                    this.m_pix.m_data[(j + PuCSCustomColorWheel2d_IP.m_sp) * (640 + 2 * PuCSCustomColorWheel2d_IP.m_sp) + i + PuCSCustomColorWheel2d_IP.m_sp] = Color.white.getRGB();
                } else if (radius > 1.0) {
                    this.m_pix.m_data[(j + PuCSCustomColorWheel2d_IP.m_sp) * (640 + 2 * PuCSCustomColorWheel2d_IP.m_sp) + i + PuCSCustomColorWheel2d_IP.m_sp] = Color.black.getRGB();
                } else if (radius > 0.9) {
                    index = (int)((double)numKeys * angle + 0.5) % numKeys;
                    this.m_pix.m_data[(j + PuCSCustomColorWheel2d_IP.m_sp) * (640 + 2 * PuCSCustomColorWheel2d_IP.m_sp) + i + PuCSCustomColorWheel2d_IP.m_sp] = this.m_colorScheme.keyIsActive(index) ? (index == this.m_currentIndex ? (this.m_colorScheme.keyIsSplit(index) ? Color.orange.getRGB() : Color.red.getRGB()) : (this.m_colorScheme.keyIsSplit(index) ? Color.yellow.getRGB() : Color.white.getRGB())) : (index == this.m_currentIndex ? new Color(63, 0, 0).getRGB() : Color.black.getRGB());
                } else if (radius > 0.8) {
                    index = (int)((double)numKeys * angle + 0.5) % numKeys;
                    int subIndex = (int)((double)(2 * numKeys) * angle) % 2;
                    this.m_pix.m_data[(j + PuCSCustomColorWheel2d_IP.m_sp) * (640 + 2 * PuCSCustomColorWheel2d_IP.m_sp) + i + PuCSCustomColorWheel2d_IP.m_sp] = subIndex == 1 ? this.m_colorScheme.getLowerKeyColor(index).getRGB() : this.m_colorScheme.getUpperKeyColor(index).getRGB();
                } else {
                    this.m_pix.m_data[(j + PuCSCustomColorWheel2d_IP.m_sp) * (640 + 2 * PuCSCustomColorWheel2d_IP.m_sp) + i + PuCSCustomColorWheel2d_IP.m_sp] = radius < 0.25 ? Color.gray.getRGB() : this.m_colorScheme.colorFromAngle(angle);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 640 + 2 * m_sp) {
            j = 0;
            while (j < m_sp) {
                this.m_pix.m_data[j * (640 + 2 * PuCSCustomColorWheel2d_IP.m_sp) + i] = Color.green.getRGB();
                this.m_pix.m_data[(640 + 2 * PuCSCustomColorWheel2d_IP.m_sp - 1 - j) * (640 + 2 * PuCSCustomColorWheel2d_IP.m_sp) + i] = Color.yellow.getRGB();
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < m_sp) {
            j = 0;
            while (j < 640 + 2 * m_sp) {
                this.m_pix.m_data[j * (640 + 2 * PuCSCustomColorWheel2d_IP.m_sp) + i] = Color.green.getRGB();
                this.m_pix.m_data[j * (640 + 2 * PuCSCustomColorWheel2d_IP.m_sp) + (640 + 2 * PuCSCustomColorWheel2d_IP.m_sp - 1 - i)] = Color.yellow.getRGB();
                ++j;
            }
            ++i;
        }
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_colorScheme = (PuCSCustomColorWheel2d)parent;
        this.m_tNumKeys.setText("" + this.m_colorScheme.getNumKeys());
        this.m_tCurrentKey.setText("0");
        this.m_cActive.setState(this.m_colorScheme.keyIsActive(0));
        this.m_cSplit.setState(this.m_colorScheme.keyIsSplit(0));
        this.m_cUpperColor.setColor(this.m_colorScheme.getUpperKeyColor(0));
        this.m_cLowerColor.setColor(this.m_colorScheme.getLowerKeyColor(0));
        this.m_angleOffset.setValue(this.m_colorScheme.getAngleOffset());
        this.m_numTeeth.setValue(this.m_colorScheme.getNumTeeth());
        this.m_slope.setValue(this.m_colorScheme.getToothSlope());
        this.m_intervalOffset.setValue(this.m_colorScheme.getToothOffset());
        this.m_tFileName.setText(this.m_colorScheme.m_fullKeyColorFileName);
        this.paintWheel();
        this.validate();
    }

    @Override
    public void mousePressed(MouseEvent event) {
        Object source = event.getSource();
        if (source == this.m_padPanel) {
            PuComplex position = new PuComplex((double)(-(event.getX() - m_sp)) * 2.0 / 638.0 + 1.0, (double)(event.getY() - m_sp) * 2.0 / 638.0 - 1.0);
            double angle = position.arg() / (Math.PI * 2);
            angle += this.m_colorScheme.getAngleOffset();
            while (angle < 0.0) {
                angle += 1.0;
            }
            while (angle > 1.0) {
                angle -= 1.0;
            }
            int numKeys = 2;
            if (this.m_colorScheme != null) {
                numKeys = this.m_colorScheme.getNumKeys();
            }
            this.m_currentIndex = (int)((double)numKeys * angle + 0.5) % numKeys;
            this.m_tCurrentKey.setText("" + this.m_currentIndex);
            this.m_cActive.setState(this.m_colorScheme.keyIsActive(this.m_currentIndex));
            this.m_cSplit.setState(this.m_colorScheme.keyIsSplit(this.m_currentIndex));
            this.m_cUpperColor.setColor(this.m_colorScheme.getUpperKeyColor(this.m_currentIndex));
            this.m_cLowerColor.setColor(this.m_colorScheme.getLowerKeyColor(this.m_currentIndex));
            this.paintWheel();
            this.m_mis.newPixels();
            this.m_padPanel.repaint();
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.mousePressed(event);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    public boolean update(Object event) {
        if (event == this.m_cUpperColor) {
            if (!this.m_cActive.getState()) {
                this.m_colorScheme.setKeyActive(this.m_currentIndex, true);
                this.m_cActive.setState(true);
            }
            this.m_colorScheme.setUpperKeyColor(this.m_currentIndex, this.m_cUpperColor.getColor());
            if (!this.m_cSplit.getState()) {
                this.m_colorScheme.setLowerKeyColor(this.m_currentIndex, this.m_cUpperColor.getColor());
                if (this.m_cLowerColor.getColor() != this.m_cUpperColor.getColor()) {
                    this.m_cLowerColor.setColor(this.m_cUpperColor.getColor());
                }
            }
            this.paintWheel();
            this.m_mis.newPixels();
            this.m_padPanel.repaint();
            this.repaint();
            this.m_colorScheme.update(this.m_colorScheme);
            return true;
        }
        if (event == this.m_cLowerColor) {
            if (!this.m_cActive.getState()) {
                this.m_colorScheme.setKeyActive(this.m_currentIndex, true);
                this.m_cActive.setState(true);
            }
            this.m_colorScheme.setLowerKeyColor(this.m_currentIndex, this.m_cLowerColor.getColor());
            if (!this.m_cSplit.getState()) {
                this.m_colorScheme.setUpperKeyColor(this.m_currentIndex, this.m_cLowerColor.getColor());
                if (this.m_cUpperColor.getColor() != this.m_cLowerColor.getColor()) {
                    this.m_cUpperColor.setColor(this.m_cLowerColor.getColor());
                }
            }
            this.paintWheel();
            this.m_mis.newPixels();
            this.m_padPanel.repaint();
            this.repaint();
            this.m_colorScheme.update(this.m_colorScheme);
            return true;
        }
        if (event == this.m_numTeeth) {
            int numTeeth = this.m_numTeeth.getValue();
            if (numTeeth < 1) {
                return true;
            }
            this.m_colorScheme.setNumTeeth(numTeeth);
            this.paintWheel();
            this.m_mis.newPixels();
            this.m_padPanel.repaint();
            this.repaint();
            this.m_colorScheme.update(this.m_colorScheme);
            return true;
        }
        if (event == this.m_slope) {
            this.m_colorScheme.setToothSlope(this.m_slope.getValue());
            this.paintWheel();
            this.m_mis.newPixels();
            this.m_padPanel.repaint();
            this.repaint();
            this.m_colorScheme.update(this.m_colorScheme);
            return true;
        }
        if (event == this.m_angleOffset) {
            this.m_colorScheme.setAngleOffset(this.m_angleOffset.getValue());
            this.paintWheel();
            this.m_mis.newPixels();
            this.m_padPanel.repaint();
            this.repaint();
            this.m_colorScheme.update(this.m_colorScheme);
            return true;
        }
        if (event == this.m_intervalOffset) {
            this.m_colorScheme.setToothOffset(this.m_intervalOffset.getValue());
            this.paintWheel();
            this.m_mis.newPixels();
            this.m_padPanel.repaint();
            this.repaint();
            this.m_colorScheme.update(this.m_colorScheme);
            return true;
        }
        return super.update(event);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.m_cActive) {
            this.m_colorScheme.setKeyActive(this.m_currentIndex, this.m_cActive.getState());
            this.paintWheel();
            this.m_mis.newPixels();
            this.m_padPanel.repaint();
            this.repaint();
            this.m_colorScheme.update(this.m_colorScheme);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_tNumKeys) {
            int num = Integer.valueOf(this.m_tNumKeys.getText());
            if (this.m_currentIndex > num - 1) {
                this.m_currentIndex = 0;
                this.m_tCurrentKey.setText("0");
            }
            if (num > 1) {
                this.m_colorScheme.setNumKeys(num);
            }
            this.paintWheel();
            this.m_mis.newPixels();
            this.m_padPanel.repaint();
            this.repaint();
            this.m_colorScheme.update(this.m_colorScheme);
        } else if (source == this.m_tCurrentKey) {
            int index = Integer.valueOf(this.m_tCurrentKey.getText());
            if (index < 0 || index > this.m_colorScheme.getNumKeys() - 1) {
                return;
            }
            this.m_currentIndex = index;
            this.m_cSplit.setState(this.m_colorScheme.keyIsSplit(index));
            this.m_cActive.setState(this.m_colorScheme.keyIsActive(index));
            this.m_cUpperColor.setColor(this.m_colorScheme.getUpperKeyColor(index));
            this.m_cLowerColor.setColor(this.m_colorScheme.getLowerKeyColor(index));
            this.paintWheel();
            this.m_mis.newPixels();
            this.m_padPanel.repaint();
            this.repaint();
        } else if (source == this.m_bSave) {
            this.m_colorScheme.m_fullKeyColorFileName = this.m_tFileName.getText();
            this.m_colorScheme.storeKeyColors();
        } else if (source == this.m_bLoad) {
            this.m_colorScheme.m_fullKeyColorFileName = this.m_tFileName.getText();
            this.m_colorScheme.loadKeyColors();
            this.paintWheel();
            this.m_mis.newPixels();
            this.m_padPanel.repaint();
            this.repaint();
            this.m_colorScheme.update(this.m_colorScheme);
        }
    }
}

