/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors.schemes;

import devDomainColoring.colors.PuAbstractColorScheme;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StreamTokenizer;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PuCSCustomColorWheel2d
extends PuAbstractColorScheme {
    public String m_fullKeyColorFileName = "D:\\test\\colorSchemeKeys.txt";
    private double m_angleOffset;
    private int m_numKeys = 10;
    private int m_numTeeth = 48;
    private double m_toothSlope = -1.0;
    private double m_intervalOffset = 0.0;
    private Color[] m_upperKeyColor = new Color[]{new Color(0, 0, 0), new Color(127, 0, 0), new Color(255, 0, 0), new Color(255, 127, 0), new Color(255, 255, 0), new Color(255, 255, 255), new Color(0, 255, 255), new Color(0, 127, 255), new Color(0, 0, 255), new Color(0, 0, 127)};
    private Color[] m_lowerKeyColor = new Color[]{new Color(0, 0, 0), new Color(127, 0, 0), new Color(255, 0, 0), new Color(255, 127, 0), new Color(255, 255, 0), new Color(255, 255, 255), new Color(0, 255, 255), new Color(0, 127, 255), new Color(0, 0, 255), new Color(0, 0, 127)};
    private boolean[] m_bActive;

    public PuCSCustomColorWheel2d() {
        super(2, "Custom Color Wheel");
        boolean[] blArray = new boolean[10];
        blArray[0] = true;
        blArray[2] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[8] = true;
        this.m_bActive = blArray;
        this.m_angleOffset = 0.0;
    }

    public void setNumKeys(int numKeys) {
        if (numKeys < 1) {
            return;
        }
        if (numKeys == this.m_numKeys) {
            return;
        }
        boolean[] bActive = new boolean[numKeys];
        Color[] upperKeyColor = new Color[numKeys];
        Color[] lowerKeyColor = new Color[numKeys];
        int i = 0;
        while (i < Math.min(numKeys, this.m_numKeys)) {
            bActive[i] = this.m_bActive[i];
            upperKeyColor[i] = this.m_upperKeyColor[i];
            lowerKeyColor[i] = this.m_lowerKeyColor[i];
            ++i;
        }
        this.m_bActive = bActive;
        this.m_upperKeyColor = upperKeyColor;
        this.m_lowerKeyColor = lowerKeyColor;
        this.m_numKeys = numKeys;
        this.interpolateColors();
    }

    public int getNumKeys() {
        return this.m_numKeys;
    }

    public void setKeyActive(int index, boolean flag) {
        this.m_bActive[index] = flag;
        this.interpolateColors();
    }

    public boolean keyIsActive(int index) {
        return this.m_bActive[index];
    }

    public void setLowerKeyColor(int index, Color col) {
        this.m_lowerKeyColor[index] = col;
        this.interpolateColors();
    }

    public Color getLowerKeyColor(int index) {
        return this.m_lowerKeyColor[index];
    }

    public void setUpperKeyColor(int index, Color col) {
        this.m_upperKeyColor[index] = col;
        this.interpolateColors();
    }

    public Color getUpperKeyColor(int index) {
        return this.m_upperKeyColor[index];
    }

    public boolean keyIsSplit(int index) {
        return this.m_upperKeyColor[index].getRGB() != this.m_lowerKeyColor[index].getRGB();
    }

    public void setNumTeeth(int numTeeth) {
        if (numTeeth > 0) {
            this.m_numTeeth = numTeeth;
        }
    }

    public int getNumTeeth() {
        return this.m_numTeeth;
    }

    public void setToothSlope(double toothSlope) {
        this.m_toothSlope = toothSlope;
    }

    public double getToothSlope() {
        return this.m_toothSlope;
    }

    public void setToothOffset(double offset) {
        this.m_intervalOffset = offset;
    }

    public double getToothOffset() {
        return this.m_intervalOffset;
    }

    public void setAngleOffset(double offset) {
        this.m_angleOffset = offset;
    }

    public double getAngleOffset() {
        return this.m_angleOffset;
    }

    public void interpolateColors() {
        int firstActive = 0;
        int i = 0;
        while (i < this.m_numKeys) {
            if (this.keyIsActive(i)) {
                firstActive = i;
                break;
            }
            if (i == this.m_numKeys - 1) {
                PsDebug.warning((String)"There should be at least one active key color!");
                return;
            }
            ++i;
        }
        int lastActive = firstActive;
        int intervalSize = 0;
        int nextActive = 0;
        int i2 = 0;
        while (i2 < this.m_numKeys) {
            int currentIndex = (i2 + firstActive) % this.m_numKeys;
            if (this.keyIsActive(currentIndex)) {
                lastActive = currentIndex;
                int j = 0;
                while (j < this.m_numKeys) {
                    if (this.keyIsActive((currentIndex + j + 1) % this.m_numKeys)) {
                        nextActive = (currentIndex + j + 1) % this.m_numKeys;
                        intervalSize = j + 1;
                        break;
                    }
                    ++j;
                }
            } else {
                Color blendColor;
                double blend = 1.0 * (double)((this.m_numKeys + currentIndex - lastActive) % this.m_numKeys) / (1.0 * (double)intervalSize);
                int r = (int)((1.0 - blend) * (double)this.m_upperKeyColor[lastActive].getRed() + blend * (double)this.m_lowerKeyColor[nextActive].getRed());
                int g = (int)((1.0 - blend) * (double)this.m_upperKeyColor[lastActive].getGreen() + blend * (double)this.m_lowerKeyColor[nextActive].getGreen());
                int b = (int)((1.0 - blend) * (double)this.m_upperKeyColor[lastActive].getBlue() + blend * (double)this.m_lowerKeyColor[nextActive].getBlue());
                if (r < 0) {
                    r = 0;
                }
                if (r > 255) {
                    r = 255;
                }
                if (g < 0) {
                    g = 0;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b < 0) {
                    b = 0;
                }
                if (b > 255) {
                    b = 255;
                }
                this.m_upperKeyColor[currentIndex] = blendColor = new Color(r, g, b);
                this.m_lowerKeyColor[currentIndex] = blendColor;
            }
            ++i2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public int getColorImpl(double x, double y) {
        arg = Math.atan2(y, x) / 6.283185307179586 + 0.5;
        abs = Math.sqrt(x * x + y * y);
        arg = arg + this.m_angleOffset - Math.floor(arg + this.m_angleOffset);
        if (!(abs < 4.9E-324)) ** GOTO lbl7
        return Color.black.getRGB();
lbl-1000:
        // 1 sources

        {
            arg += 1.0;
lbl7:
            // 2 sources

            ** while (arg < 0.0)
        }
lbl8:
        // 2 sources

        while (arg > 1.0) {
            arg -= 1.0;
        }
        return this.colorFromAngle(arg);
    }

    public int colorFromAngle(double arg) {
        double angle = arg - this.m_intervalOffset / (double)this.m_numTeeth;
        while (angle > 1.0) {
            angle -= 1.0;
        }
        while (angle < 0.0) {
            angle += 1.0;
        }
        int i = 0;
        while (i < this.m_numTeeth) {
            if (angle <= (1.0 + (double)i) / (1.0 * (double)this.m_numTeeth)) {
                angle = (2.0 * (double)i + 1.0) * (1.0 - this.m_toothSlope) / (2.0 * (double)this.m_numTeeth) + this.m_toothSlope * angle;
                while (angle < 0.0) {
                    angle += 1.0;
                }
                while (angle > 1.0) {
                    angle -= 1.0;
                }
                break;
            }
            ++i;
        }
        angle += this.m_intervalOffset / (double)this.m_numTeeth;
        while (angle >= 1.0) {
            angle -= 1.0;
        }
        while (angle < 0.0) {
            angle += 1.0;
        }
        int index = (int)(angle * (double)this.m_numKeys);
        while (index >= this.m_numKeys) {
            index -= this.m_numKeys;
        }
        while (index < 0) {
            index += this.m_numKeys;
        }
        double blend = angle * (double)this.m_numKeys - (double)index;
        int r = (int)((1.0 - blend) * (double)this.m_upperKeyColor[index].getRed() + blend * (double)this.m_lowerKeyColor[(index + 1) % this.m_numKeys].getRed());
        int g = (int)((1.0 - blend) * (double)this.m_upperKeyColor[index].getGreen() + blend * (double)this.m_lowerKeyColor[(index + 1) % this.m_numKeys].getGreen());
        int b = (int)((1.0 - blend) * (double)this.m_upperKeyColor[index].getBlue() + blend * (double)this.m_lowerKeyColor[(index + 1) % this.m_numKeys].getBlue());
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        Color blendColor = new Color(r, g, b);
        return blendColor.getRGB();
    }

    @Override
    public String getName() {
        return "Custom Color Wheel";
    }

    public void storeKeyColors() {
        String fileName = this.m_fullKeyColorFileName;
        File schemeFile = new File(fileName);
        try {
            FileWriter fw = new FileWriter(schemeFile, false);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("Angle Offset: " + this.m_angleOffset + "\r\n");
            bw.write("Number of Intervals: " + this.m_numTeeth + "\r\n");
            bw.write("Slope: " + this.m_toothSlope + "\r\n");
            bw.write("Interval Offset: " + this.m_intervalOffset + "\r\n");
            int i = 0;
            while (i < this.m_numKeys) {
                if (this.keyIsActive(i)) {
                    bw.write("1\r\n");
                } else {
                    bw.write("0\r\n");
                }
                bw.write(String.valueOf(this.m_lowerKeyColor[i].getRed()) + " " + this.m_lowerKeyColor[i].getGreen() + " " + this.m_lowerKeyColor[i].getBlue() + " " + "\r\n");
                bw.write(String.valueOf(this.m_upperKeyColor[i].getRed()) + " " + this.m_upperKeyColor[i].getGreen() + " " + this.m_upperKeyColor[i].getBlue() + " " + "\r\n");
                ++i;
            }
            bw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void loadKeyColors() {
        String fileName = this.m_fullKeyColorFileName;
        File schemeFile = new File(fileName);
        try {
            FileReader fr = new FileReader(schemeFile);
            BufferedReader br = new BufferedReader(fr);
            StreamTokenizer st = new StreamTokenizer(br);
            st.parseNumbers();
            st.eolIsSignificant(true);
            st.wordChars(58, 58);
            st.nextToken();
            st.nextToken();
            st.nextToken();
            double angleOffset = st.nval;
            st.nextToken();
            st.nextToken();
            st.nextToken();
            st.nextToken();
            st.nextToken();
            int numTeeth = (int)st.nval;
            st.nextToken();
            st.nextToken();
            st.nextToken();
            double toothSlope = st.nval;
            st.nextToken();
            st.nextToken();
            st.nextToken();
            st.nextToken();
            double intervalOffset = st.nval;
            st.nextToken();
            int numInts = 0;
            PiVector intValue = new PiVector(7);
            st.nextToken();
            while (st.ttype != -1) {
                if (st.ttype == 10) {
                    st.nextToken();
                    continue;
                }
                if (numInts >= intValue.getSize()) {
                    intValue.setSize(intValue.getSize() + 7);
                }
                intValue.m_data[numInts] = (int)st.nval;
                ++numInts;
                st.nextToken();
            }
            fr.close();
            boolean setData = true;
            if (numTeeth < 1) {
                PsDebug.warning((String)("Loaded num intervals = " + numTeeth));
                setData = false;
            }
            if (numInts / 7 < 1) {
                PsDebug.warning((String)("Loaded num keys = " + numInts / 7));
                setData = false;
            }
            if (numInts % 7 != 0) {
                PsDebug.warning((String)"Parsing Colors failed, each color should be one 0/1 flag and twice R G B (i.e. 7 numbers).");
                setData = false;
            }
            int i = 0;
            while (i < numInts / 7) {
                if (intValue.m_data[7 * i] < 0 || intValue.m_data[7 * i] > 1) {
                    PsDebug.warning((String)("Parsing Colors: First nimber of color " + i + " should be a 0/1 flag"));
                    setData = false;
                }
                int j = 1;
                while (j < 7) {
                    if (intValue.m_data[7 * i + j] < 0 || intValue.m_data[7 * i + j] > 255) {
                        PsDebug.warning((String)("Parsing Colors: " + j + "-th number of color " + i + " is not in 0 to 255 range."));
                        setData = false;
                    }
                    ++j;
                }
                ++i;
            }
            if (setData) {
                this.m_angleOffset = angleOffset;
                this.m_numTeeth = numTeeth;
                this.m_toothSlope = toothSlope;
                this.m_intervalOffset = intervalOffset;
                this.setNumKeys(numInts / 7);
                i = 0;
                while (i < this.m_numKeys) {
                    this.m_bActive[i] = intValue.m_data[7 * i] == 1;
                    this.m_lowerKeyColor[i] = new Color(intValue.m_data[7 * i + 1], intValue.m_data[7 * i + 2], intValue.m_data[7 * i + 3]);
                    this.m_upperKeyColor[i] = new Color(intValue.m_data[7 * i + 4], intValue.m_data[7 * i + 5], intValue.m_data[7 * i + 6]);
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public Color getRelativeColor(int ind, int max) {
        float angle = (float)ind / (float)max;
        angle = angle + (float)this.m_angleOffset - (float)Math.floor(angle + (float)this.m_angleOffset);
        while ((double)angle < 0.0) {
            angle = (float)((double)angle + 1.0);
        }
        while ((double)angle > 1.0) {
            angle = (float)((double)angle - 1.0);
        }
        return new Color(this.colorFromAngle(angle));
    }

    @Override
    public int getColor(PdVector v) {
        return this.getColorImpl(v.m_data[0], v.m_data[1]);
    }
}

