/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors.schemes;

import devDomainColoring.colors.PuAbstractColorScheme;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.text.DecimalFormat;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwCleanMesh;

public class PuCSCustomColorBar1d
extends PuAbstractColorScheme {
    public String m_fullKeyColorFileName = "C:\\test\\colorSchemeKeys.txt";
    private double m_min;
    private double m_max;
    private int m_numKeys = 11;
    private int m_numTeeth = 48;
    private double m_toothSlope = -1.0;
    private Color[] m_upperKeyColor = new Color[]{new Color(0, 0, 0), new Color(127, 0, 0), new Color(255, 0, 0), new Color(255, 127, 0), new Color(255, 255, 0), new Color(255, 255, 255), new Color(0, 255, 255), new Color(0, 127, 255), new Color(0, 0, 255), new Color(0, 0, 127), new Color(0, 0, 0)};
    private Color[] m_lowerKeyColor = new Color[]{new Color(0, 0, 0), new Color(127, 0, 0), new Color(255, 0, 0), new Color(255, 127, 0), new Color(255, 255, 0), new Color(255, 255, 255), new Color(0, 255, 255), new Color(0, 127, 255), new Color(0, 0, 255), new Color(0, 0, 127), new Color(0, 0, 0)};
    private boolean[] m_bActive;

    public PuCSCustomColorBar1d() {
        super(1, "Custom Color Bar");
        boolean[] blArray = new boolean[11];
        blArray[0] = true;
        blArray[2] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[8] = true;
        blArray[10] = true;
        this.m_bActive = blArray;
        this.m_min = 0.0;
        this.m_max = 1.0;
    }

    public void setNumKeys(int numKeys) {
        if (numKeys < 2) {
            return;
        }
        if (numKeys == this.m_numKeys) {
            return;
        }
        boolean[] bActive = new boolean[numKeys];
        Color[] upperKeyColor = new Color[numKeys];
        Color[] lowerKeyColor = new Color[numKeys];
        int i = 0;
        while (i < Math.min(numKeys, this.m_numKeys)) {
            bActive[i] = this.m_bActive[i];
            upperKeyColor[i] = this.m_upperKeyColor[i];
            lowerKeyColor[i] = this.m_lowerKeyColor[i];
            ++i;
        }
        this.m_bActive = bActive;
        this.m_upperKeyColor = upperKeyColor;
        this.m_lowerKeyColor = lowerKeyColor;
        this.m_numKeys = numKeys;
        this.interpolateColors();
    }

    public int getNumKeys() {
        return this.m_numKeys;
    }

    public void setKeyActive(int index, boolean flag) {
        this.m_bActive[index] = flag;
        this.interpolateColors();
    }

    public boolean keyIsActive(int index) {
        return this.m_bActive[index];
    }

    public void setLowerKeyColor(int index, Color col) {
        this.m_lowerKeyColor[index] = col;
        this.interpolateColors();
    }

    public Color getLowerKeyColor(int index) {
        return this.m_lowerKeyColor[index];
    }

    public void setUpperKeyColor(int index, Color col) {
        this.m_upperKeyColor[index] = col;
        this.interpolateColors();
    }

    public Color getUpperKeyColor(int index) {
        return this.m_upperKeyColor[index];
    }

    public boolean keyIsSplit(int index) {
        return this.m_upperKeyColor[index].getRGB() != this.m_lowerKeyColor[index].getRGB();
    }

    public void setNumTeeth(int numTeeth) {
        if (numTeeth > 0) {
            this.m_numTeeth = numTeeth;
        }
    }

    public int getNumTeeth() {
        return this.m_numTeeth;
    }

    public void setToothSlope(double toothSlope) {
        this.m_toothSlope = toothSlope;
    }

    public double getToothSlope() {
        return this.m_toothSlope;
    }

    public void setMinimum(double min) {
        this.m_min = min;
    }

    public double getMinimum() {
        return this.m_min;
    }

    public void setMaximum(double max) {
        this.m_max = max;
    }

    public double getMaximum() {
        return this.m_max;
    }

    public void interpolateColors() {
        int firstActive = -1;
        int lastActive = -1;
        int i = 0;
        while (i < this.m_numKeys) {
            if (this.keyIsActive(i)) {
                if (firstActive == -1) {
                    firstActive = i;
                }
                lastActive = i;
            }
            ++i;
        }
        if (firstActive == -1) {
            PsDebug.warning((String)"There should be at least one active key color!");
            return;
        }
        int intervalSize = 0;
        int nextActive = 0;
        int i2 = 0;
        while (i2 < firstActive) {
            this.m_upperKeyColor[i2] = this.m_lowerKeyColor[firstActive];
            this.m_lowerKeyColor[i2] = this.m_lowerKeyColor[firstActive];
            ++i2;
        }
        i2 = firstActive;
        while (i2 < lastActive) {
            if (this.keyIsActive(i2)) {
                firstActive = i2;
                int j = firstActive + 1;
                while (j <= lastActive) {
                    if (this.keyIsActive(j)) {
                        nextActive = j;
                        intervalSize = j - firstActive;
                        break;
                    }
                    ++j;
                }
            } else {
                Color blendColor;
                double blend = 1.0 * (double)(i2 - firstActive) / (1.0 * (double)intervalSize);
                int r = (int)((1.0 - blend) * (double)this.m_upperKeyColor[firstActive].getRed() + blend * (double)this.m_lowerKeyColor[nextActive].getRed());
                int g = (int)((1.0 - blend) * (double)this.m_upperKeyColor[firstActive].getGreen() + blend * (double)this.m_lowerKeyColor[nextActive].getGreen());
                int b = (int)((1.0 - blend) * (double)this.m_upperKeyColor[firstActive].getBlue() + blend * (double)this.m_lowerKeyColor[nextActive].getBlue());
                if (r < 0) {
                    r = 0;
                }
                if (r > 255) {
                    r = 255;
                }
                if (g < 0) {
                    g = 0;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b < 0) {
                    b = 0;
                }
                if (b > 255) {
                    b = 255;
                }
                this.m_upperKeyColor[i2] = blendColor = new Color(r, g, b);
                this.m_lowerKeyColor[i2] = blendColor;
            }
            ++i2;
        }
        i2 = lastActive + 1;
        while (i2 < this.m_numKeys) {
            this.m_upperKeyColor[i2] = this.m_upperKeyColor[lastActive];
            this.m_lowerKeyColor[i2] = this.m_upperKeyColor[lastActive];
            ++i2;
        }
    }

    public int getColorImpl(double val) {
        if (Math.abs(this.m_max - this.m_min) < 1.0E-10) {
            val = val < this.m_min ? -1.0 : (val > this.m_max ? 2.0 : 0.5);
        } else {
            val -= this.m_min;
            val /= this.m_max - this.m_min;
        }
        return this.colorFromNormalizedValue(val);
    }

    public int colorFromNormalizedValue(double val) {
        if (val >= 0.0 && val <= 1.0) {
            int i = (int)(val * (double)this.m_numTeeth);
            val = (2.0 * (double)i + 1.0) * (1.0 - this.m_toothSlope) / (2.0 * (double)this.m_numTeeth) + this.m_toothSlope * val;
        }
        int index = (int)Math.floor(val * (double)(this.m_numKeys - 1));
        if (val == 1.0) {
            index = this.m_numKeys - 2;
        }
        if (index >= this.m_numKeys - 1) {
            return this.m_upperKeyColor[this.m_numKeys - 1].getRGB();
        }
        if (index < 0) {
            return this.m_lowerKeyColor[0].getRGB();
        }
        double blend = val * (double)(this.m_numKeys - 1) - (double)index;
        int r = (int)((1.0 - blend) * (double)this.m_upperKeyColor[index].getRed() + blend * (double)this.m_lowerKeyColor[index + 1].getRed());
        int g = (int)((1.0 - blend) * (double)this.m_upperKeyColor[index].getGreen() + blend * (double)this.m_lowerKeyColor[index + 1].getGreen());
        int b = (int)((1.0 - blend) * (double)this.m_upperKeyColor[index].getBlue() + blend * (double)this.m_lowerKeyColor[index + 1].getBlue());
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        Color blendColor = new Color(r, g, b);
        return blendColor.getRGB();
    }

    @Override
    public String getName() {
        return "Custom Color Wheel";
    }

    public void storeKeyColors() {
        String fileName = this.m_fullKeyColorFileName;
        File schemeFile = new File(fileName);
        try {
            FileWriter fw = new FileWriter(schemeFile, false);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("Angle Offset: none\r\n");
            bw.write("Number of Intervals: " + this.m_numTeeth + "\r\n");
            bw.write("Slope: " + this.m_toothSlope + "\r\n");
            bw.write("Interval Offset: none\r\n");
            int i = 0;
            while (i < this.m_numKeys) {
                if (this.keyIsActive(i)) {
                    bw.write("1\r\n");
                } else {
                    bw.write("0\r\n");
                }
                bw.write(String.valueOf(this.m_lowerKeyColor[i].getRed()) + " " + this.m_lowerKeyColor[i].getGreen() + " " + this.m_lowerKeyColor[i].getBlue() + " " + "\r\n");
                bw.write(String.valueOf(this.m_upperKeyColor[i].getRed()) + " " + this.m_upperKeyColor[i].getGreen() + " " + this.m_upperKeyColor[i].getBlue() + " " + "\r\n");
                ++i;
            }
            bw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void loadKeyColors() {
        String fileName = this.m_fullKeyColorFileName;
        File schemeFile = new File(fileName);
        try {
            FileReader fr = new FileReader(schemeFile);
            BufferedReader br = new BufferedReader(fr);
            StreamTokenizer st = new StreamTokenizer(br);
            st.parseNumbers();
            st.eolIsSignificant(true);
            st.wordChars(58, 58);
            st.nextToken();
            st.nextToken();
            st.nextToken();
            st.nextToken();
            st.nextToken();
            st.nextToken();
            st.nextToken();
            st.nextToken();
            int numTeeth = (int)st.nval;
            st.nextToken();
            st.nextToken();
            st.nextToken();
            double toothSlope = st.nval;
            st.nextToken();
            st.nextToken();
            st.nextToken();
            st.nextToken();
            st.nextToken();
            int numInts = 0;
            PiVector intValue = new PiVector(7);
            st.nextToken();
            while (st.ttype != -1) {
                if (st.ttype == 10) {
                    st.nextToken();
                    continue;
                }
                if (numInts >= intValue.getSize()) {
                    intValue.setSize(intValue.getSize() + 7);
                }
                intValue.m_data[numInts] = (int)st.nval;
                ++numInts;
                st.nextToken();
            }
            fr.close();
            boolean setData = true;
            if (numTeeth < 1) {
                PsDebug.warning((String)("Loaded num intervals = " + numTeeth));
                setData = false;
            }
            if (numInts / 7 < 1) {
                PsDebug.warning((String)("Loaded num keys = " + numInts / 7));
                setData = false;
            }
            if (numInts % 7 != 0) {
                PsDebug.warning((String)"Parsing Colors failed, each color should be one 0/1 flag and twice R G B (i.e. 7 numbers).");
                setData = false;
            }
            int i = 0;
            while (i < numInts / 7) {
                if (intValue.m_data[7 * i] < 0 || intValue.m_data[7 * i] > 1) {
                    PsDebug.warning((String)("Parsing Colors: First number of color " + i + " should be a 0/1 flag"));
                    setData = false;
                }
                int j = 1;
                while (j < 7) {
                    if (intValue.m_data[7 * i + j] < 0 || intValue.m_data[7 * i + j] > 255) {
                        PsDebug.warning((String)("Parsing Colors: " + j + "-th number of color " + i + " is not in 0 to 255 range."));
                        setData = false;
                    }
                    ++j;
                }
                ++i;
            }
            if (setData) {
                this.m_numTeeth = numTeeth;
                this.m_toothSlope = toothSlope;
                this.setNumKeys(numInts / 7);
                i = 0;
                while (i < this.m_numKeys) {
                    this.m_bActive[i] = intValue.m_data[7 * i] == 1;
                    this.m_lowerKeyColor[i] = new Color(intValue.m_data[7 * i + 1], intValue.m_data[7 * i + 2], intValue.m_data[7 * i + 3]);
                    this.m_upperKeyColor[i] = new Color(intValue.m_data[7 * i + 4], intValue.m_data[7 * i + 5], intValue.m_data[7 * i + 6]);
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void refine() {
        int numKeys = this.m_numKeys;
        this.setNumKeys(2 * numKeys - 1);
        int i = numKeys - 1;
        while (i >= 0) {
            this.m_upperKeyColor[2 * i] = this.m_upperKeyColor[i];
            this.m_lowerKeyColor[2 * i] = this.m_lowerKeyColor[i];
            this.m_bActive[2 * i] = this.m_bActive[i];
            if (i != numKeys - 1) {
                this.m_bActive[2 * i + 1] = false;
            }
            --i;
        }
        this.interpolateColors();
    }

    public void removeInactiveKeys() {
        int numActive = 0;
        int i = 0;
        while (i < this.m_numKeys) {
            if (this.keyIsActive(i)) {
                ++numActive;
            }
            ++i;
        }
        if (numActive < 2) {
            return;
        }
        numActive = 0;
        i = 0;
        while (i < this.m_numKeys) {
            if (this.keyIsActive(i)) {
                this.m_upperKeyColor[numActive] = this.m_upperKeyColor[i];
                this.m_lowerKeyColor[numActive] = this.m_lowerKeyColor[i];
                this.m_bActive[numActive] = true;
                ++numActive;
            }
            ++i;
        }
        this.setNumKeys(numActive);
    }

    @Override
    public int getColor(PdVector v) {
        return this.getColorImpl(v.m_data[0]);
    }

    public void resample() {
        PgPolygon poly = new PgPolygon(3);
        poly.setNumVertices(this.m_numKeys);
        poly.setClosed(false);
        int i = 0;
        while (i < this.m_numKeys) {
            double[] xyz = PuCSCustomColorBar1d.rgb2xyz(this.m_upperKeyColor[i].getRed(), this.m_upperKeyColor[i].getGreen(), this.m_upperKeyColor[i].getBlue());
            double[] cieLab = PuCSCustomColorBar1d.xyz2Cielab(xyz[0], xyz[1], xyz[2]);
            poly.setVertex(i, new PdVector(cieLab[0], cieLab[1], cieLab[2]));
            ++i;
        }
        PwCleanMesh.resamplePolygon((PgPolygon)poly, (int)this.m_numKeys);
        i = 0;
        while (i < this.m_numKeys) {
            PdVector vertex = poly.getVertex(i);
            double[] xyz = PuCSCustomColorBar1d.cielab2xyz(vertex.m_data[0], vertex.m_data[1], vertex.m_data[2]);
            int[] rgb = PuCSCustomColorBar1d.xyz2rgb(xyz[0], xyz[1], xyz[2]);
            this.m_upperKeyColor[i] = new Color(rgb[0], rgb[1], rgb[2]);
            this.m_lowerKeyColor[i] = this.m_upperKeyColor[i];
            this.m_bActive[i] = true;
            ++i;
        }
    }

    public void printColorDistances() {
        DecimalFormat df = new DecimalFormat("000.00");
        DecimalFormat intf = new DecimalFormat("000");
        PsDebug.message((String)"+------------+---------------+---------------+---------------+---------------+");
        PsDebug.message((String)"| Color Dist | in CIE-L*a*b* | in CIE-L*u*v* | in CIE 1994   | in CIEDE 2000 |");
        int i = 0;
        while (i < this.m_numKeys - 1) {
            if (i % 5 == 0) {
                PsDebug.message((String)"+------------+---------------+---------------+---------------+---------------+");
            }
            PsDebug.message((String)("| " + intf.format(i) + " to " + intf.format((i + 1) % this.m_numKeys) + " |" + "        " + df.format(PuCSCustomColorBar1d.colDist76Cielab(this.m_upperKeyColor[i], this.m_upperKeyColor[i + 1])) + " |" + "        " + df.format(PuCSCustomColorBar1d.colDist76Cieluv(this.m_upperKeyColor[i], this.m_upperKeyColor[i + 1])) + " |" + "        " + df.format(PuCSCustomColorBar1d.colDist94Cielab(this.m_upperKeyColor[i], this.m_upperKeyColor[i + 1])) + " |" + "        " + df.format(PuCSCustomColorBar1d.colDist2000Cielab(this.m_upperKeyColor[i], this.m_upperKeyColor[i + 1])) + " |"));
            ++i;
        }
        PsDebug.message((String)"+------------+---------------+---------------+---------------+---------------+");
    }

    public static double[] rgb2xyz(int r, int g, int b) {
        double rd = (double)r / 255.0;
        double gd = (double)g / 255.0;
        double bd = (double)b / 255.0;
        rd = rd > 0.04045 ? Math.pow((rd + 0.055) / 1.055, 2.4) : (rd /= 12.92);
        gd = gd > 0.04045 ? Math.pow((gd + 0.055) / 1.055, 2.4) : (gd /= 12.92);
        bd = bd > 0.04045 ? Math.pow((bd + 0.055) / 1.055, 2.4) : (bd /= 12.92);
        double x = (rd *= 100.0) * 0.4124 + (gd *= 100.0) * 0.3576 + (bd *= 100.0) * 0.1805;
        double y = rd * 0.2126 + gd * 0.7152 + bd * 0.0722;
        double z = rd * 0.0193 + gd * 0.1192 + bd * 0.9505;
        return new double[]{x, y, z};
    }

    public static int[] xyz2rgb(double x, double y, double z) {
        int blue;
        int green;
        double xx = x / 100.0;
        double yy = y / 100.0;
        double zz = z / 100.0;
        double r = xx * 3.2406 + yy * -1.5372 + zz * -0.4986;
        double g = xx * -0.9689 + yy * 1.8758 + zz * 0.0415;
        double b = xx * 0.0557 + yy * -0.204 + zz * 1.057;
        r = r > 0.0031308 ? 1.055 * Math.pow(r, 0.4166666666666667) - 0.055 : (r *= 12.92);
        g = g > 0.0031308 ? 1.055 * Math.pow(g, 0.4166666666666667) - 0.055 : (g *= 12.92);
        b = b > 0.0031308 ? 1.055 * Math.pow(b, 0.4166666666666667) - 0.055 : (b *= 12.92);
        int red = (int)(r * 255.0);
        if (red < 0) {
            red = 0;
        }
        if (red > 255) {
            red = 255;
        }
        if ((green = (int)(g * 255.0)) < 0) {
            green = 0;
        }
        if (green > 255) {
            green = 255;
        }
        if ((blue = (int)(b * 255.0)) < 0) {
            blue = 0;
        }
        if (blue > 255) {
            blue = 255;
        }
        return new int[]{red, green, blue};
    }

    public static double[] xyz2HunterLab(double x, double y, double z) {
        if (y <= 0.0) {
            return new double[]{0.0, 0.0, 0.0};
        }
        double L = 10.0 * Math.sqrt(y);
        double a = 17.5 * (1.02 * x - y) / Math.sqrt(y);
        double b = 7.0 * (y - 0.847 * z) / Math.sqrt(y);
        return new double[]{L, a, b};
    }

    public static double[] hunterLab2xyz(double L, double a, double b) {
        double y = L / 10.0;
        double x = a / 17.5 * L / 10.0;
        double z = b / 7.0 * L / 10.0;
        y *= y;
        x = (x + y) / 1.02;
        z = -(z - y) / 0.847;
        return new double[]{x, y, z};
    }

    public static double[] xyz2Cielab(double x, double y, double z) {
        double xx = x / 95.047;
        double yy = y / 100.0;
        double zz = z / 108.883;
        xx = xx > 0.008856 ? Math.pow(xx, 0.3333333333333333) : 7.787 * xx + 0.13793103448275862;
        yy = yy > 0.008856 ? Math.pow(yy, 0.3333333333333333) : 7.787 * yy + 0.13793103448275862;
        zz = zz > 0.008856 ? Math.pow(zz, 0.3333333333333333) : 7.787 * zz + 0.13793103448275862;
        double L = 116.0 * yy - 16.0;
        double a = 500.0 * (xx - yy);
        double b = 200.0 * (yy - zz);
        return new double[]{L, a, b};
    }

    public static double[] cielab2xyz(double L, double a, double b) {
        double y = (L + 16.0) / 116.0;
        double x = a / 500.0 + y;
        double z = y - b / 200.0;
        double y3 = Math.pow(y, 3.0);
        y = y3 > 0.008856 ? y3 : (y - 0.13793103448275862) / 7.787;
        double x3 = Math.pow(x, 3.0);
        x = x3 > 0.008856 ? x3 : (x - 0.13793103448275862) / 7.787;
        double z3 = Math.pow(z, 3.0);
        z = z3 > 0.008856 ? z3 : (z - 0.13793103448275862) / 7.787;
        return new double[]{x *= 95.047, y *= 100.0, z *= 108.883};
    }

    public static double[] xyz2Cieluv(double x, double y, double z) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return new double[]{0.0, 0.0, 0.0};
        }
        double u = 4.0 * x / (x + 15.0 * y + 3.0 * z);
        double v = 9.0 * y / (x + 15.0 * y + 3.0 * z);
        double yy = y / 100.0;
        yy = yy > 0.008856 ? Math.pow(yy, 0.3333333333333333) : 7.787 * yy + 0.13793103448275862;
        double ref_x = 95.047;
        double ref_y = 100.0;
        double ref_z = 108.883;
        double ref_u = 4.0 * ref_x / (ref_x + 15.0 * ref_y + 3.0 * ref_z);
        double ref_v = 9.0 * ref_y / (ref_x + 15.0 * ref_y + 3.0 * ref_z);
        double L = 116.0 * yy - 16.0;
        u = 13.0 * L * (u - ref_u);
        v = 13.0 * L * (v - ref_v);
        return new double[]{L, u, v};
    }

    public static double[] cieluv2xyz(double L, double u, double v) {
        if (L == 0.0) {
            return new double[]{0.0, 0.0, 0.0};
        }
        double y = (L + 16.0) / 116.0;
        double y3 = Math.pow(y, 3.0);
        y = y3 > 0.008856 ? y3 : (y - 0.13793103448275862) / 7.787;
        double ref_x = 95.047;
        double ref_y = 100.0;
        double ref_z = 108.883;
        double ref_u = 4.0 * ref_x / (ref_x + 15.0 * ref_y + 3.0 * ref_z);
        double ref_v = 9.0 * ref_y / (ref_x + 15.0 * ref_y + 3.0 * ref_z);
        double uu = u / (13.0 * L) + ref_u;
        double vv = v / (13.0 * L) + ref_v;
        double x = -9.0 * (y *= 100.0) * uu / ((uu - 4.0) * vv - uu * vv);
        double z = (9.0 * y - 15.0 * vv * y - vv * x) / (3.0 * vv);
        return new double[]{x, y, z};
    }

    public static double colDist76Cielab(Color col1, Color col2) {
        double[] xyz1 = PuCSCustomColorBar1d.rgb2xyz(col1.getRed(), col1.getGreen(), col1.getBlue());
        double[] xyz2 = PuCSCustomColorBar1d.rgb2xyz(col2.getRed(), col2.getGreen(), col2.getBlue());
        double[] cl1 = PuCSCustomColorBar1d.xyz2Cielab(xyz1[0], xyz1[1], xyz1[2]);
        double[] cl2 = PuCSCustomColorBar1d.xyz2Cielab(xyz2[0], xyz2[1], xyz2[2]);
        double ds = (cl1[0] - cl2[0]) * (cl1[0] - cl2[0]) + (cl1[1] - cl2[1]) * (cl1[1] - cl2[1]) + (cl1[2] - cl2[2]) * (cl1[2] - cl2[2]);
        return Math.sqrt(ds);
    }

    public static double colDist76Cieluv(Color col1, Color col2) {
        double[] xyz1 = PuCSCustomColorBar1d.rgb2xyz(col1.getRed(), col1.getGreen(), col1.getBlue());
        double[] xyz2 = PuCSCustomColorBar1d.rgb2xyz(col2.getRed(), col2.getGreen(), col2.getBlue());
        double[] cl1 = PuCSCustomColorBar1d.xyz2Cieluv(xyz1[0], xyz1[1], xyz1[2]);
        double[] cl2 = PuCSCustomColorBar1d.xyz2Cieluv(xyz2[0], xyz2[1], xyz2[2]);
        double ds = (cl1[0] - cl2[0]) * (cl1[0] - cl2[0]) + (cl1[1] - cl2[1]) * (cl1[1] - cl2[1]) + (cl1[2] - cl2[2]) * (cl1[2] - cl2[2]);
        return Math.sqrt(ds);
    }

    public static double colDist94Cielab(Color col1, Color col2) {
        double[] xyz1 = PuCSCustomColorBar1d.rgb2xyz(col1.getRed(), col1.getGreen(), col1.getBlue());
        double[] xyz2 = PuCSCustomColorBar1d.rgb2xyz(col2.getRed(), col2.getGreen(), col2.getBlue());
        double[] cl1 = PuCSCustomColorBar1d.xyz2Cielab(xyz1[0], xyz1[1], xyz1[2]);
        double[] cl2 = PuCSCustomColorBar1d.xyz2Cielab(xyz2[0], xyz2[1], xyz2[2]);
        double kL = 1.0;
        double sL = 1.0;
        double k1 = 0.045;
        double k2 = 0.015;
        double C1 = Math.sqrt(cl1[1] * cl1[1] + cl1[2] * cl1[2]);
        double C2 = Math.sqrt(cl2[1] * cl2[1] + cl2[2] * cl2[2]);
        double Cm = Math.sqrt(C1 * C2);
        double sC = 1.0 + k1 * Cm;
        double kC = 1.0;
        double kH = 1.0;
        double sH = 1.0 + k2 * Cm;
        double ds = (cl1[0] - cl2[0]) * (cl1[0] - cl2[0]) / (kL * sL) + (C1 - C2) * (C1 - C2) / (kC * sC) + ((cl1[1] - cl2[1]) * (cl1[1] - cl2[1]) + (cl1[2] - cl2[2]) * (cl1[2] - cl2[2]) - (C1 - C2) * (C1 - C2)) / (kH * sH);
        return Math.sqrt(ds);
    }

    public static double colDist2000Cielab(Color col1, Color col2) {
        double[] xyz1 = PuCSCustomColorBar1d.rgb2xyz(col1.getRed(), col1.getGreen(), col1.getBlue());
        double[] xyz2 = PuCSCustomColorBar1d.rgb2xyz(col2.getRed(), col2.getGreen(), col2.getBlue());
        double[] cl1 = PuCSCustomColorBar1d.xyz2Cielab(xyz1[0], xyz1[1], xyz1[2]);
        double[] cl2 = PuCSCustomColorBar1d.xyz2Cielab(xyz2[0], xyz2[1], xyz2[2]);
        double C1 = Math.sqrt(cl1[1] * cl1[1] + cl1[2] * cl1[2]);
        double C2 = Math.sqrt(cl2[1] * cl2[1] + cl2[2] * cl2[2]);
        double Cm = (C1 + C2) / 2.0;
        double Cm7 = Math.pow(Cm, 7.0);
        double G = 0.5 * (1.0 - Math.sqrt(Cm7 / (Cm7 + 6.103515625E9)));
        double as1 = (1.0 + G) * cl1[1];
        double as2 = (1.0 + G) * cl2[1];
        double Cs1 = Math.sqrt(as1 * as1 + cl1[2] * cl1[2]);
        double Cs2 = Math.sqrt(as2 * as2 + cl2[2] * cl2[2]);
        double hs1 = 0.0;
        if (as1 != 0.0 || cl1[2] != 0.0) {
            hs1 = Math.atan2(cl1[2], as1);
            if (hs1 < 0.0) {
                hs1 += Math.PI * 2;
            }
            hs1 *= 57.29577951308232;
        }
        double hs2 = 0.0;
        if (as2 != 0.0 || cl2[2] != 0.0) {
            hs2 = Math.atan2(cl2[2], as2);
            if (hs2 < 0.0) {
                hs2 += Math.PI * 2;
            }
            hs2 *= 57.29577951308232;
        }
        double dLs = cl2[0] - cl1[0];
        double dCs = Cs2 - Cs1;
        double dhs = 0.0;
        if (Cs1 * Cs2 != 0.0) {
            dhs = Math.abs(hs2 - hs1) <= 180.0 ? hs2 - hs1 : (hs2 - hs1 > 180.0 ? hs2 - hs1 - 360.0 : hs2 - hs1 + 360.0);
        }
        double dHs = 2.0 * Math.sqrt(Cs1 * Cs2) * Math.sin(dhs / 2.0 * Math.PI / 180.0);
        double Lms = (cl1[0] + cl2[0]) / 2.0;
        double Cms = (Cs1 + Cs2) / 2.0;
        double hms = hs1 + hs2;
        if (Cs1 * Cs2 != 0.0) {
            hms = Math.abs(hs2 - hs1) <= 180.0 ? (hs2 + hs1) / 2.0 : (hs1 + hs2 < 360.0 ? (hs1 + hs2 + 360.0) / 2.0 : (hs1 + hs2 - 360.0) / 2.0);
        }
        double T = 1.0 - 0.17 * Math.cos((hms - 30.0) * Math.PI / 180.0) + 0.24 * Math.cos(2.0 * hms * Math.PI / 180.0) + 0.32 * Math.cos((3.0 * hms + 6.0) * Math.PI / 180.0) - 0.2 * Math.cos((4.0 * hms - 63.0) * Math.PI / 180.0);
        double dth = 30.0 * Math.exp(-Math.pow((hms - 275.0) / 25.0, 2.0));
        double Cms7 = Math.pow(Cms, 7.0);
        double RC = 2.0 * Math.sqrt(Cms7 / (Cms7 + 6.103515625E9));
        double SL = 1.0 + 0.015 * (Lms - 50.0) * (Lms - 50.0) / Math.sqrt(20.0 + (Lms - 50.0) * (Lms - 50.0));
        double SC = 1.0 + 0.045 * Cms;
        double SH = 1.0 + 0.015 * Cms * T;
        double RT = -Math.sin(2.0 * dth * Math.PI / 180.0) * RC;
        double kL = 1.0;
        double kC = 1.0;
        double kH = 1.0;
        double ds = dLs * dLs / (kL * kL * SL * SL) + dCs * dCs / (kC * kC * SC * SC) + dHs * dHs / (kH * kH * SH * SH) + RT * dCs / (kC * SC) * dHs / (kH * SH);
        return Math.sqrt(ds);
    }

    public static double[] xyz2lmsCAT02(double x, double y, double z) {
        double L = 0.7328 * x + 0.4296 * y - 0.1624 * z;
        double M = -0.7036 * x + 1.6975 * y + 0.0061 * z;
        double S = 0.003 * x + 0.0136 * y + 0.9834 * z;
        return new double[]{L, M, S};
    }
}

