/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors.schemes;

import devDomainColoring.colors.PuAbstractColorScheme;
import devDomainColoring.colors.PuColorSchemeIf;
import devDomainColoring.colors.PuColorUtil;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;

public class PuCSConcentricCircles2d
extends PuAbstractColorScheme
implements PuColorSchemeIf {
    private static final double DEFAULT_DISTANCE = 0.5;
    private static final int DEFAULT_BRIGHTNESS = 20;
    protected PuDouble m_dist = new PuDouble("Circle Distance");
    protected PuInteger m_brightness;

    public PuCSConcentricCircles2d() {
        this(0.5, 20);
    }

    public PuCSConcentricCircles2d(double distance, int brightness) {
        super(2, "Concentric Circles");
        this.m_dist.setBounds(0.0, 10.0);
        this.m_dist.addUpdateListener((PsUpdateIf)this);
        this.m_brightness = new PuInteger("Brightness");
        this.m_brightness.setBounds(0, 255);
        this.m_brightness.addUpdateListener((PsUpdateIf)this);
        this.m_dist.setValue(distance);
        this.m_brightness.setValue(brightness);
    }

    public boolean update(Object event) {
        return super.update((Object)this);
    }

    public int getColorImpl(double x, double y) {
        double abs = Math.sqrt(x * x + y * y);
        double logAbs = Math.log(abs) / Math.log(2.0);
        double peak = Math.floor(logAbs / this.m_dist.getValue());
        double discrDist = this.m_dist.getValue() * peak;
        float eps = 0.025f;
        float rem = (float)(logAbs - discrDist);
        float nextRem = (float)(discrDist + this.m_dist.getValue() - logAbs);
        float s = rem <= eps ? rem / eps : (nextRem <= eps ? nextRem / eps : 1.0f);
        float v = (float)this.m_brightness.getValue() / 255.0f;
        int h = (int)((s + Math.abs(1.0f - 2.0f * v) * (v - s)) * 255.0f);
        float opPolCircles = 0.5f * (1.0f + s) + Math.abs(v - 0.5f) * (s - 1.0f);
        int alpha = (int)(255.0 * (1.0 - (double)opPolCircles));
        int bmPolarCircles = 0.98 <= abs && abs <= 1.02 ? PuColorUtil.rgbToInt(130, h / 4, h / 4, alpha) : PuColorUtil.rgbToInt(h, h, h, alpha);
        return bmPolarCircles;
    }

    @Override
    public int getColor(PdVector v) {
        return this.getColorImpl(v.m_data[0], v.m_data[1]);
    }
}

