/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors.schemes;

import devDomainColoring.colors.PuAbstractColorScheme;
import devDomainColoring.colors.PuColorSchemeIf;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jv.number.PuBoolean;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;

public class PuCSColorWheel2d
extends PuAbstractColorScheme
implements PuColorSchemeIf {
    private static final double DEFAULT_ANGLE_OFFSET = 0.0;
    protected PuDouble m_angleOffset = new PuDouble("Angle Offset");
    protected PuBoolean m_highlightPolesAndZeros;
    double hue0 = 0.0;
    double hue1 = 0.25;
    double hue2 = 0.5;
    double hue3 = 0.75;
    double hue4 = 1.0;
    double BRIGHTNESS_BOUNDARY_VALUE = 0.7;
    double SATURATION_BOUNDARY_VALUE = 0.7;
    protected static final double[] DEFAULT_LIGHTNESS_THRESHOLDS = new double[]{0.1, 0.7, 100.0, 120.0};
    protected static final String[] DEFAULT_LIGHTNESS_THRESHOLDS_DESCRIPTIONS = new String[]{"Black", "Fade in", "Full", "Fade out"};
    protected List<PuDouble> m_lightnessThresholds;

    public PuCSColorWheel2d() {
        super(2, "Color Wheel 2d");
        this.m_angleOffset.setValue(0.0);
        this.m_angleOffset.setBounds(-1.0, 1.0);
        this.m_angleOffset.addUpdateListener((PsUpdateIf)this);
        this.m_highlightPolesAndZeros = new PuBoolean("Highlight Poles and Zeros", (PsUpdateIf)this, true);
        this.m_lightnessThresholds = new ArrayList<PuDouble>(4);
        int i = 0;
        while (i < 4) {
            PuDouble pd = new PuDouble(DEFAULT_LIGHTNESS_THRESHOLDS_DESCRIPTIONS[i]);
            pd.addUpdateListener((PsUpdateIf)this);
            pd.setValue(DEFAULT_LIGHTNESS_THRESHOLDS[i]);
            pd.setBounds(0.0, DEFAULT_LIGHTNESS_THRESHOLDS[i]);
            this.m_lightnessThresholds.add(pd);
            ++i;
        }
    }

    public int getColorImpl(double x, double y) {
        double arg = Math.atan2(y, x) / (Math.PI * 2) + 0.5;
        double abs = Math.sqrt(x * x + y * y);
        arg = arg + this.m_angleOffset.getValue() - Math.floor(arg + this.m_angleOffset.getValue());
        float hue = 0.0f;
        float sat = 0.0f;
        float bri = 0.0f;
        hue = arg < 0.25 ? (float)(this.hue0 + 4.0 * arg * (this.hue1 - this.hue0)) : (arg < 0.5 ? (float)(this.hue1 + 4.0 * (arg - 0.25) * (this.hue2 - this.hue1)) : (arg < 0.75 ? (float)(this.hue2 + 4.0 * (arg - 0.5) * (this.hue3 - this.hue2)) : (float)(this.hue3 + 4.0 * (arg - 0.75) * (this.hue4 - this.hue3))));
        if (abs < Double.MIN_VALUE) {
            bri = 0.0f;
            sat = 0.0f;
        } else if (this.m_highlightPolesAndZeros.getState()) {
            double l0 = this.m_lightnessThresholds.get(0).getValue();
            double l3 = this.m_lightnessThresholds.get(3).getValue();
            if (abs < l0) {
                bri = 0.0f;
                sat = 0.0f;
            } else if (abs < l3) {
                double l1 = this.m_lightnessThresholds.get(1).getValue();
                double l2 = this.m_lightnessThresholds.get(2).getValue();
                sat = (float)this.fade(abs, l3, l3 - l2, this.SATURATION_BOUNDARY_VALUE);
                bri = (float)this.fade(abs, l0, l1 - l0, this.BRIGHTNESS_BOUNDARY_VALUE);
            } else {
                sat = 0.0f;
                bri = 1.0f;
            }
        } else {
            bri = 1.0f;
            sat = 1.0f;
        }
        return Color.HSBtoRGB(hue, sat, bri);
    }

    private double fade(double x, double zero, double radius, double valAtBoundary) {
        assert (radius > 0.0);
        return Math.exp(Math.log(valAtBoundary) * Math.pow(radius / (x - zero), 2.0));
    }

    public boolean update(Object event) {
        if (event == this.m_angleOffset || event == this.m_highlightPolesAndZeros || this.m_lightnessThresholds.contains(event)) {
            return super.update((Object)this);
        }
        return super.update(event);
    }

    @Override
    public int getColor(PdVector v) {
        return this.getColorImpl(v.m_data[0], v.m_data[1]);
    }
}

