/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors;

import devDomainColoring.colors.PuAbstractColorScheme;
import devDomainColoring.colors.PuColorSchemeIf;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.util.ArrayList;
import jv.function.PuComplexFunction;
import jv.number.PuComplex;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PuImageRenderer
extends Thread {
    public static final byte REmin = 0;
    public static final byte IMmin = 1;
    public static final byte REmax = 2;
    public static final byte IMmax = 3;
    private int xPixel;
    private int yPixel;
    private double[] bounds;
    private boolean m_midpointEvaluation = true;
    private PuColorSchemeIf m_cs;
    private PuComplexFunction f;
    private boolean sphereMode;
    private int m_noi = 1;
    private Image img;

    public PuImageRenderer(PuComplexFunction f, double[] bounds, int xPixel, int yPixel, int numOfIterations, PuColorSchemeIf cs, boolean sphereMode) {
        this.xPixel = xPixel;
        this.yPixel = yPixel;
        this.bounds = bounds;
        this.m_noi = numOfIterations;
        this.m_cs = cs;
        this.f = f;
        this.sphereMode = sphereMode;
    }

    @Override
    public void run() {
        PuComplexFunction f2 = new PuComplexFunction(1, 1);
        f2.setExpression(this.f.getExpression());
        this.f = f2;
        this.renderImage();
    }

    private Image renderImage() {
        int bufSize = this.xPixel * this.yPixel;
        try {
            PuColorSchemeIf cs = (PuColorSchemeIf)((PuAbstractColorScheme)this.m_cs).clone();
            PsDebug.notify((String)("\n>>Compute new images with the following settings...Domain size:\n\t reMin\t" + this.bounds[0] + "\n\t reMax\t" + this.bounds[2] + "\n\t imMin\t" + this.bounds[1] + "\n\t imMax\t" + this.bounds[3] + "#Pixel x: " + this.xPixel + "\n\t#Pixel y: " + this.yPixel + "Pixel buffer size: " + bufSize * 4 + "byte raw data."));
            PiVector pixBuffer = new PiVector(bufSize);
            PuComplex z = new PuComplex();
            PuComplex fz = new PuComplex();
            PdVector vWrapper = new PdVector(2);
            double xInc = (this.bounds[2] - this.bounds[0]) / (double)this.xPixel;
            double yInc = (this.bounds[1] - this.bounds[3]) / (double)this.yPixel;
            if (this.sphereMode) {
                double xInc1 = 1.0 / (double)this.xPixel;
                double yInc1 = -1.0 / (double)this.yPixel;
                int j = 0;
                while (j < this.yPixel) {
                    int i = 0;
                    while (i < this.xPixel) {
                        double u = (double)i * xInc1;
                        double v = this.bounds[3] + (double)j * yInc1;
                        double sx = Math.cos(Math.PI * 2 * u) * Math.cos(Math.PI * (v - 0.5));
                        double sy = Math.sin(Math.PI * 2 * u) * Math.cos(Math.PI * (v - 0.5));
                        double sz = Math.sin(Math.PI * (v - 0.5));
                        double newu = sx / (1.0 - sz);
                        double newv = sy / (1.0 - sz);
                        if (this.m_midpointEvaluation) {
                            u += xInc1 / 2.0;
                            v += yInc1 / 2.0;
                        }
                        z.set(newu, newv);
                        int l = 0;
                        while (l < this.m_noi) {
                            z = fz = this.f.eval(z);
                            ++l;
                        }
                        vWrapper.m_data[0] = fz.re;
                        vWrapper.m_data[1] = fz.im;
                        pixBuffer.m_data[j * this.xPixel + i] = this.m_cs.getColor(vWrapper);
                        ++i;
                    }
                    ++j;
                }
            } else {
                int y = 0;
                while (y < this.yPixel) {
                    int x = 0;
                    while (x < this.xPixel) {
                        double u = this.bounds[0] + (double)x * xInc;
                        double v = this.bounds[3] + (double)y * yInc;
                        if (this.m_midpointEvaluation) {
                            u += xInc / 2.0;
                            v += yInc / 2.0;
                        }
                        z.set(u, v);
                        int k = 0;
                        while (k < this.m_noi) {
                            z = fz = this.f.eval(z);
                            ++k;
                        }
                        pixBuffer.m_data[y * this.xPixel + x] = cs.getColor(vWrapper);
                        ++x;
                    }
                    ++y;
                }
            }
            MemoryImageSource mis = new MemoryImageSource(this.xPixel, this.yPixel, pixBuffer.m_data, 0, this.xPixel);
            PsDebug.notify((String)"...done.");
            this.img = Toolkit.getDefaultToolkit().createImage(mis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.img;
    }

    private static Image computeImage(PuComplexFunction f, double[] bounds, int xPixel, int yPixel, int numOfIterations, PuAbstractColorScheme cs, boolean sphereMode, int numOfThreads) throws InterruptedException {
        PsDebug.notify((String)("Using " + numOfThreads + " threads."));
        long start = System.currentTimeMillis();
        if (sphereMode) {
            numOfThreads = 1;
        }
        int yInc = yPixel / numOfThreads;
        double boundsInc = (bounds[3] - bounds[1]) / (double)numOfThreads;
        ArrayList<PuImageRenderer> threads = new ArrayList<PuImageRenderer>(numOfThreads);
        int i = 0;
        while (i < numOfThreads - 1) {
            double[] curBounds = new double[]{bounds[0], bounds[3] - (double)(i + 1) * boundsInc, bounds[2], bounds[3] - (double)i * boundsInc};
            try {
                PuComplexFunction f_copy = new PuComplexFunction(1, 1);
                f_copy.setExpression(f.getExpression());
                PuImageRenderer r = new PuImageRenderer(f_copy, curBounds, xPixel, yInc, numOfIterations, (PuAbstractColorScheme)cs.clone(), sphereMode);
                threads.add(r);
                r.start();
            }
            catch (Exception e) {
                System.out.println(e);
            }
            ++i;
        }
        double[] curBounds = new double[]{bounds[0], bounds[1], bounds[2], bounds[3] - (double)(numOfThreads - 1) * boundsInc};
        PuImageRenderer r = new PuImageRenderer(f, curBounds, xPixel, yPixel - (numOfThreads - 1) * yInc, numOfIterations, cs, sphereMode);
        threads.add(r);
        r.start();
        int i2 = 0;
        while (i2 < numOfThreads) {
            ((PuImageRenderer)threads.get(i2)).join();
            ++i2;
        }
        BufferedImage bufImg = new BufferedImage(xPixel, yPixel, 1);
        Graphics g = bufImg.getGraphics();
        int i3 = 0;
        while (i3 < numOfThreads) {
            Image img = ((PuImageRenderer)threads.get(i3)).getImg();
            g.drawImage(img, 0, i3 * yInc, null);
            ++i3;
        }
        long end = System.currentTimeMillis();
        PsDebug.message((String)("Rendering took " + (end - start) + "ms"));
        return bufImg;
    }

    public static Image computeImage(PuComplexFunction f, double[] bounds, int xPixel, int yPixel, int numOfIterations, PuAbstractColorScheme cs, boolean sphereMode) throws InterruptedException {
        return PuImageRenderer.computeImage(f, bounds, xPixel, yPixel, numOfIterations, cs, sphereMode, 1);
    }

    private Image getImg() {
        return this.img;
    }
}

