/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors;

import java.awt.Color;
import jv.number.PdColor;
import jv.object.PsDebug;

public final class PuColorUtil {
    private PuColorUtil() {
    }

    public static int blendRGB(int col1, int col2, double weight) {
        int r1 = col1 >> 16 & 0xFF;
        int g1 = col1 >> 8 & 0xFF;
        int b1 = col1 >> 0 & 0xFF;
        int r2 = col2 >> 16 & 0xFF;
        int g2 = col2 >> 8 & 0xFF;
        int b2 = col2 >> 0 & 0xFF;
        double dualWeight = 1.0 - weight;
        int R = (int)((double)r1 * dualWeight + (double)r2 * weight);
        int G = (int)((double)g1 * dualWeight + (double)g2 * weight);
        int B = (int)((double)b1 * dualWeight + (double)b2 * weight);
        return 0xFF000000 | R << 16 | G << 8 | B << 0;
    }

    public static int blendOver(int front, int back) {
        int A1 = front >> 24 & 0xFF;
        int R1 = front >> 16 & 0xFF;
        int G1 = front >> 8 & 0xFF;
        int B1 = front >> 0 & 0xFF;
        int A2 = back >> 24 & 0xFF;
        int R2 = back >> 16 & 0xFF;
        int G2 = back >> 8 & 0xFF;
        int B2 = back >> 0 & 0xFF;
        double a1 = (double)A1 / 255.0;
        double a2 = (double)A2 / 255.0;
        double a = a1 + a2 * (1.0 - a1);
        if (0.0 == a) {
            return 0;
        }
        int R = (int)(((double)R1 * a1 + (double)R2 * a2 * (1.0 - a1)) / a);
        int G = (int)(((double)G1 * a1 + (double)G2 * a2 * (1.0 - a1)) / a);
        int B = (int)(((double)B1 * a1 + (double)B2 * a2 * (1.0 - a1)) / a);
        return (int)(a * 255.0) << 24 | R << 16 | G << 8 | B << 0;
    }

    public static Color[] makeUniformDistributedColors(int numCols, Color[] colors) {
        if (colors == null) {
            colors = new Color[numCols];
        } else if (colors.length != numCols) {
            PsDebug.warning((String)"invalid length of colors array");
            return null;
        }
        if (numCols < 2) {
            int c = 0;
            while (c < numCols) {
                colors[c] = Color.white;
                ++c;
            }
            return colors;
        }
        int ind = 0;
        int numDim = (int)Math.ceil(Math.pow(numCols, 0.3333333333333333));
        float f = 1.0f / (float)(numDim - 1);
        int r = 0;
        while (r < numDim) {
            int g = 0;
            while (g < numDim) {
                int b = 0;
                while (b < numDim) {
                    if (ind >= numCols) {
                        return colors;
                    }
                    colors[ind] = new Color(1.0f - (float)r * f, 1.0f - (float)g * f, 1.0f - (float)b * f);
                    ++ind;
                    ++b;
                }
                ++g;
            }
            ++r;
        }
        return colors;
    }

    public static int rgbToInt(int R, int G, int B, int A) {
        return A << 24 | R << 16 | G << 8 | B << 0;
    }

    public static int rgbToInt(int R, int G, int B) {
        return PuColorUtil.rgbToInt(R, G, B, 255);
    }

    public static Color[] createLinearPalette(Color[] inputColors, int discretization) {
        int noc = inputColors.length;
        if (noc < 2) {
            return null;
        }
        int stepsPerInterval = (int)Math.floor(discretization / (noc - 1));
        Color[] palette = new Color[discretization + 1];
        double inc = 1.0 / (double)stepsPerInterval;
        int i = 0;
        while (i < noc - 1) {
            Color c_cur = inputColors[i];
            Color c_next = inputColors[i + 1];
            int d = 0;
            while (d < stepsPerInterval) {
                Color c;
                palette[i * stepsPerInterval + d] = c = PdColor.blend((double)(1.0 - (double)d * inc), (Color)c_cur, (double)((double)d * inc), (Color)c_next);
                ++d;
            }
            ++i;
        }
        palette[discretization] = inputColors[noc - 1];
        return palette;
    }
}

