/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors;

import devDomainColoring.colors.PuColorSchemeIf;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import jv.vecmath.PdVector;

public class PuColorSchemePreview
extends Canvas {
    private static final long serialVersionUID = 7436645569763143056L;
    private PuColorSchemeIf m_cs;
    private static double[] DEFAULT_DOMAIN = new double[]{-1.0, 1.0, -1.0, 1.0};
    private static int DEFAULT_X_PIXEL = 100;
    private static int DEFAULT_Y_PIXEL = 100;
    private double[] m_domain = DEFAULT_DOMAIN;
    private int m_xPixel = DEFAULT_X_PIXEL;
    private int m_yPixel = DEFAULT_Y_PIXEL;
    public static final byte Xmin = 0;
    public static final byte Xmax = 1;
    public static final byte Ymin = 2;
    public static final byte Ymax = 3;

    public PuColorSchemePreview() {
    }

    public PuColorSchemePreview(PuColorSchemeIf csSpec) {
        this();
        this.setColorScheme(csSpec);
    }

    public static Image getImage(PuColorSchemeIf cs, double[] domain, int xPixel, int yPixel) {
        int bufSize = xPixel * yPixel;
        int[] pixBuffer = new int[bufSize];
        PdVector vWrapper = new PdVector(2);
        double xInc = (domain[1] - domain[0]) / (double)xPixel;
        double yInc = (domain[2] - domain[3]) / (double)yPixel;
        int j = 0;
        while (j < yPixel) {
            int i = 0;
            while (i < xPixel) {
                double x = domain[0] + (double)i * xInc;
                double y = domain[3] + (double)j * yInc;
                vWrapper.m_data[0] = x;
                vWrapper.m_data[1] = y;
                pixBuffer[j * xPixel + i] = cs.getColor(vWrapper);
                ++i;
            }
            ++j;
        }
        MemoryImageSource mis = new MemoryImageSource(xPixel, yPixel, pixBuffer, 0, xPixel);
        return Toolkit.getDefaultToolkit().createImage(mis);
    }

    public Image getImage(double[] domain, int xPixel, int yPixel) {
        return PuColorSchemePreview.getImage(this.getColorScheme(), domain, xPixel, yPixel);
    }

    @Override
    public void paint(Graphics g) {
        Image im = this.getImage(this.m_domain, this.m_xPixel, this.m_yPixel);
        if (im != null) {
            g.drawImage(im, 0, 0, im.getWidth(null), im.getHeight(null), null);
        } else {
            System.out.println("No preview image available.");
        }
    }

    public void setColorScheme(PuColorSchemeIf cs) {
        this.m_cs = cs;
    }

    public PuColorSchemeIf getColorScheme() {
        return this.m_cs;
    }

    public double[] getDomain() {
        return this.m_domain;
    }

    public void setDomain(double[] domain) {
        this.m_domain = domain;
    }

    public int getXPixel() {
        return this.m_xPixel;
    }

    public void setXPixel(int xPixel) {
        this.m_xPixel = xPixel;
    }

    public int getYPixel() {
        return this.m_yPixel;
    }

    public void setYPixel(int yPixel) {
        this.m_yPixel = yPixel;
    }
}

