/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors;

import devDomainColoring.colors.PuAbstractColorScheme;
import devDomainColoring.colors.PuColorSchemeIf;
import devDomainColoring.colors.PuColorSchemeManager;
import java.awt.Button;
import java.awt.Component;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PuBoolean;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;

public class PuColorSchemeManager_IP
extends PsPanel
implements ItemListener,
ActionListener {
    private PuColorSchemeManager m_csManager;
    private List m_lBkgColorSchemes;
    private Button m_bConfigCS;
    private PsDialog m_configBkgCSDlg;

    public PuColorSchemeManager_IP() {
        if (this.getClass() == PuColorSchemeManager_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    private PsPanel createBkgColorSchemePanel() {
        PsPanel p = new PsPanel();
        p.addTitle("Background Color Schemes:");
        this.m_lBkgColorSchemes = new List(5, false);
        this.m_lBkgColorSchemes.addItemListener(this);
        for (Object bkgCS : this.m_csManager.m_bkgColorSchemes) {
            this.m_lBkgColorSchemes.add(((PuColorSchemeIf)bkgCS).getName());
        }
        if (this.m_csManager.m_bkgColorSchemes.size() > 0) {
            this.m_lBkgColorSchemes.select(0);
            this.m_csManager.m_activeBkgColorScheme = (PuColorSchemeIf)this.m_csManager.m_bkgColorSchemes.get(0);
        }
        p.add((Component)this.m_lBkgColorSchemes);
        this.m_bConfigCS = new Button("Config");
        this.m_bConfigCS.addActionListener(this);
        p.add((Component)this.m_bConfigCS);
        return p;
    }

    private PsPanel createFtrColorSchemePanel() {
        PsPanel p = new PsPanel();
        p.addTitle("Features:");
        int i = 0;
        while (i < this.m_csManager.m_ftrColorSchemes.size()) {
            PsPanel pCurSCPanel = new PsPanel();
            PuBoolean chkEnabled = (PuBoolean)this.m_csManager.m_activeFtrColorSchemes.get(i);
            PuAbstractColorScheme cs = (PuAbstractColorScheme)this.m_csManager.m_ftrColorSchemes.get(i);
            chkEnabled.setName(cs.getName());
            pCurSCPanel.add((Component)chkEnabled.getInfoPanel());
            pCurSCPanel.add((Component)cs.getInfoPanel());
            pCurSCPanel.addLine(1);
            p.add((Component)pCurSCPanel);
            ++i;
        }
        return p;
    }

    public void setParent(PsUpdateIf csManager) {
        super.setParent(csManager);
        this.m_csManager = (PuColorSchemeManager)csManager;
        PsPanel pBkgColorSchemes = this.createBkgColorSchemePanel();
        PsPanel pFtrColorSchemes = this.createFtrColorSchemePanel();
        this.add((Component)pBkgColorSchemes);
        this.add((Component)pFtrColorSchemes);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object s = e.getSource();
        if (s == this.m_lBkgColorSchemes) {
            int curIndex = this.m_lBkgColorSchemes.getSelectedIndex();
            this.m_csManager.m_activeBkgColorScheme = (PuColorSchemeIf)this.m_csManager.m_bkgColorSchemes.get(curIndex);
            this.m_csManager.update(this.m_csManager.m_activeBkgColorScheme);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.m_bConfigCS) {
            PsDebug.notify((String)"Config");
            PuAbstractColorScheme curCS = (PuAbstractColorScheme)this.m_csManager.m_activeBkgColorScheme;
            PsPanel infoPanel = curCS.getInfoPanel();
            this.m_configBkgCSDlg = new PsDialog(PsConfig.getFrame(), false);
            if (infoPanel == null) {
                PsDebug.notify((String)"No info panel exists for current color scheme.");
                this.m_configBkgCSDlg.add((Component)new Label("No config panel available for color scheme " + curCS.getName()));
            } else {
                this.m_configBkgCSDlg.add((Component)infoPanel);
            }
            Panel pButtons = this.m_configBkgCSDlg.getBottomButtons(5);
            this.m_configBkgCSDlg.add((Component)pButtons, (Object)"South");
            this.m_configBkgCSDlg.setParent((PsUpdateIf)this);
            this.m_configBkgCSDlg.pack();
            this.m_configBkgCSDlg.setVisible(true);
        }
    }
}

