/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors;

import devDomainColoring.colors.PuAbstractColorScheme;
import devDomainColoring.colors.PuColorSchemeIf;
import devDomainColoring.colors.PuColorUtil;
import java.util.Vector;
import jv.number.PuBoolean;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;

public class PuColorSchemeManager
extends PsObject {
    Vector m_bkgColorSchemes;
    Vector m_ftrColorSchemes;
    PuColorSchemeIf m_activeBkgColorScheme;
    Vector m_activeFtrColorSchemes;

    public PuColorSchemeManager(Vector bkgColorSchemes, Vector ftrColorSchemes) {
        this.m_bkgColorSchemes = bkgColorSchemes;
        this.m_ftrColorSchemes = ftrColorSchemes;
        this.m_activeFtrColorSchemes = new Vector(this.m_ftrColorSchemes.size());
        int i = 0;
        while (i < this.m_ftrColorSchemes.size()) {
            this.m_activeFtrColorSchemes.add(new PuBoolean(" ", (PsUpdateIf)this, false));
            ++i;
        }
        for (Object cs : this.m_bkgColorSchemes) {
            ((PuAbstractColorScheme)cs).addUpdateListener((PsUpdateIf)this);
        }
        for (Object cs : this.m_ftrColorSchemes) {
            ((PuAbstractColorScheme)cs).addUpdateListener((PsUpdateIf)this);
        }
    }

    public void enableFtrCS(PuColorSchemeIf ftrCs) {
        int index = this.m_ftrColorSchemes.indexOf(ftrCs);
        if (index != -1) {
            this.m_activeFtrColorSchemes.set(index, true);
        }
    }

    public void disableFtrCS(PuColorSchemeIf ftrCs) {
        int index = this.m_ftrColorSchemes.indexOf(ftrCs);
        if (index != -1) {
            this.m_activeFtrColorSchemes.set(index, false);
        }
    }

    public PuColorSchemeIf getActiveBkgCS() {
        return this.m_activeBkgColorScheme;
    }

    public Vector getActiveFtrCSs() {
        Vector activeFtrCSList = new Vector();
        int i = 0;
        while (i < this.m_ftrColorSchemes.size()) {
            if (((PuBoolean)this.m_activeFtrColorSchemes.get(i)).getState()) {
                activeFtrCSList.add(this.m_ftrColorSchemes.get(i));
            }
            ++i;
        }
        return activeFtrCSList;
    }

    public PuColorSchemeIf getComposedColorScheme() {
        return new PuColorSchemeIf(){

            @Override
            public String getName() {
                return null;
            }

            @Override
            public int getDimension() {
                return PuColorSchemeManager.this.m_activeBkgColorScheme.getDimension();
            }

            @Override
            public int getColor(PdVector v) {
                int col = PuColorSchemeManager.this.m_activeBkgColorScheme.getColor(v);
                int size = PuColorSchemeManager.this.m_ftrColorSchemes.size();
                int i = 0;
                while (i < size) {
                    if (((PuBoolean)PuColorSchemeManager.this.m_activeFtrColorSchemes.get(i)).getState()) {
                        PuColorSchemeIf cs = (PuColorSchemeIf)PuColorSchemeManager.this.m_ftrColorSchemes.get(i);
                        col = PuColorUtil.blendOver(cs.getColor(v), col);
                    }
                    ++i;
                }
                return col;
            }
        };
    }

    public boolean update(Object event) {
        if (this.m_bkgColorSchemes.contains(event) || this.m_activeFtrColorSchemes.contains(event) || this.m_ftrColorSchemes.contains(event)) {
            PsDebug.notify((String)"Color Scheme updated");
            return super.update((Object)this);
        }
        return super.update(event);
    }
}

