/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring.colors;

import devDomainColoring.colors.PuColorScheme2dIf;
import devDomainColoring.colors.PuColorScheme3dIf;
import devDomainColoring.colors.PuColorSchemeIf;
import jv.number.PuComplex;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdVector;

public abstract class PuAbstractColorScheme
extends PsObject
implements PuColorSchemeIf {
    public static final int DIMENSIONLESS = -1;
    private int m_dimension;

    private PuAbstractColorScheme() {
    }

    public PuAbstractColorScheme(int dimension, String name) {
        this.m_name = name;
        this.m_dimension = dimension;
    }

    @Override
    public int getDimension() {
        return this.m_dimension;
    }

    @Override
    public abstract int getColor(PdVector var1);

    public static PuColorScheme3dIf convertTo3dColorScheme(final PuColorSchemeIf cs) {
        return new PuAbstractColorScheme3d(){
            private PdVector m_vecWrapper;
            {
                this.m_vecWrapper = new PdVector(3);
                if (puColorSchemeIf.getDimension() != 3 && puColorSchemeIf.getDimension() != -1) {
                    PsDebug.error((String)("Color Scheme of dimension " + puColorSchemeIf.getDimension() + " cannot be converted to 3d. Dimension Inconsistency!"));
                }
            }

            @Override
            public int getColor(double x, double y, double z) {
                this.m_vecWrapper.m_data[0] = x;
                this.m_vecWrapper.m_data[1] = y;
                this.m_vecWrapper.m_data[2] = z;
                return cs.getColor(this.m_vecWrapper);
            }

            @Override
            public int getColor(PdVector v) {
                return cs.getColor(v);
            }
        };
    }

    public static PuColorScheme2dIf convertTo2dColorScheme(final PuColorSchemeIf cs) {
        return new PuAbstractColorScheme2d(){
            private PdVector m_vecWrapper;
            {
                this.m_vecWrapper = new PdVector(2);
                if (puColorSchemeIf.getDimension() != 2 && puColorSchemeIf.getDimension() != -1) {
                    PsDebug.error((String)("Color Scheme of dimension " + puColorSchemeIf.getDimension() + " cannot be converted to 2d. Dimension Inconsistency!"));
                }
            }

            @Override
            public int getColor(PuComplex z) {
                this.m_vecWrapper.m_data[0] = z.re;
                this.m_vecWrapper.m_data[1] = z.im;
                return cs.getColor(this.m_vecWrapper);
            }

            @Override
            public int getColor(double x, double y) {
                this.m_vecWrapper.m_data[0] = x;
                this.m_vecWrapper.m_data[1] = y;
                return cs.getColor(this.m_vecWrapper);
            }

            @Override
            public int getColor(PdVector v) {
                return cs.getColor(v);
            }
        };
    }

    /* synthetic */ PuAbstractColorScheme(PuAbstractColorScheme puAbstractColorScheme) {
        this();
    }

    private static abstract class PuAbstractColorScheme2d
    extends PuAbstractColorScheme
    implements PuColorScheme2dIf {
        private PuAbstractColorScheme2d() {
            super(null);
        }
    }

    private static abstract class PuAbstractColorScheme3d
    extends PuAbstractColorScheme
    implements PuColorScheme3dIf {
        private PuAbstractColorScheme3d() {
            super(null);
        }
    }
}

