/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring;

import devDomainColoring.PjDomainColoring;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsDialog;
import jv.object.PsPanel;

public class PsRenderToFileDlg
extends PsDialog
implements ActionListener,
ItemListener {
    private static byte X = 0;
    private static byte Y = 1;
    private static int[] DEFAULT_RESOLUTION = new int[]{500, 500};
    private static int[] A4_RESOLUTION = new int[]{3508, 2480};
    private static int[] A3_RESOLUTION = new int[]{4960, 3507};
    private static int[] SQUARE_RESOLUTION = new int[]{1181, 1181};
    private static int[] SQUARE_HIGHRES = new int[]{3500, 3500};
    private TextField m_tfResolutionX;
    private TextField m_tfResolutionY;
    private TextField m_tfFileName;
    private FileDialog m_fdFileDialog;
    private Button m_bChoose;
    private CheckboxGroup m_cbgPaperSize;
    private Checkbox m_cbPaperSizeDinA4;
    private Checkbox m_cbPaperSizeDinA3;
    private Checkbox m_cbPaperSizeTenSquare;
    private Checkbox m_cbPaperSizeSquareHighRes;
    private PjDomainColoring m_pjDomainColoring;

    public PsRenderToFileDlg(Frame frame, boolean modal, PjDomainColoring pjDomainColoring) {
        super(frame, modal);
        this.setTitle("Render to File");
        this.m_pjDomainColoring = pjDomainColoring;
        if (this.getClass() == PsRenderToFileDlg.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        PsPanel pFileName = new PsPanel((LayoutManager)new GridLayout(1, 2));
        pFileName.add((Component)new Label("Filename"));
        pFileName.setBackground(new Color(178, 223, 238));
        this.m_tfFileName = new TextField(String.valueOf(System.getProperty("user.home")) + "\\colorplot.png");
        pFileName.add((Component)this.m_tfFileName);
        this.add((Component)pFileName);
        this.m_bChoose = new Button("Choose");
        this.m_bChoose.addActionListener(this);
        this.add(this.m_bChoose);
        PsPanel pSize = new PsPanel((LayoutManager)new GridLayout(2, 1));
        PsPanel pResolution = new PsPanel((LayoutManager)new GridLayout(2, 2));
        pResolution.setBackground(new Color(178, 223, 238));
        pResolution.add((Component)new Label("Resolution X"));
        this.m_tfResolutionX = new TextField();
        this.m_tfResolutionX.setText(Integer.toString(DEFAULT_RESOLUTION[X]));
        pResolution.add((Component)this.m_tfResolutionX);
        pResolution.add((Component)new Label("Resolution Y"));
        this.m_tfResolutionY = new TextField();
        this.m_tfResolutionY.setText(Integer.toString(DEFAULT_RESOLUTION[Y]));
        pResolution.add((Component)this.m_tfResolutionY);
        pSize.add((Component)pResolution);
        PsPanel pFormat = new PsPanel((LayoutManager)new GridLayout(3, 2));
        this.m_cbgPaperSize = new CheckboxGroup();
        this.m_cbPaperSizeDinA4 = new Checkbox("DinA4", false, this.m_cbgPaperSize);
        this.m_cbPaperSizeDinA4.addItemListener(this);
        pFormat.add((Component)this.m_cbPaperSizeDinA4);
        this.m_cbPaperSizeDinA3 = new Checkbox("DinA3", false, this.m_cbgPaperSize);
        this.m_cbPaperSizeDinA3.addItemListener(this);
        pFormat.add((Component)this.m_cbPaperSizeDinA3);
        this.m_cbPaperSizeTenSquare = new Checkbox("10x10cm", false, this.m_cbgPaperSize);
        this.m_cbPaperSizeTenSquare.addItemListener(this);
        pFormat.add((Component)this.m_cbPaperSizeTenSquare);
        this.m_cbPaperSizeSquareHighRes = new Checkbox("3500^2 pixel", false, this.m_cbgPaperSize);
        this.m_cbPaperSizeSquareHighRes.addItemListener(this);
        pFormat.add((Component)this.m_cbPaperSizeSquareHighRes);
        pSize.add((Component)pFormat);
        this.add((Component)pSize);
        Panel pBottomButtons = this.getBottomButtons(5);
        this.add(pBottomButtons);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_bChoose) {
            this.m_fdFileDialog = new FileDialog((Dialog)((Object)this), "Select File", 1);
            this.m_fdFileDialog.setVisible(true);
            this.m_tfFileName.setText(String.valueOf(this.m_fdFileDialog.getDirectory()) + this.m_fdFileDialog.getFile());
            return;
        }
        if (source == this.m_bOk) {
            String savePath = this.m_tfFileName.getText();
            int resX = Integer.parseInt(this.m_tfResolutionX.getText());
            int resY = Integer.parseInt(this.m_tfResolutionY.getText());
            this.m_bOk.setBackground(Color.red);
            this.m_pjDomainColoring.saveImage(savePath, resX, resY);
            this.m_bOk.setBackground(Color.green);
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.actionPerformed(event);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object s = event.getSource();
        int[] format = s == this.m_cbPaperSizeDinA4 ? A4_RESOLUTION : (s == this.m_cbPaperSizeDinA3 ? A3_RESOLUTION : (s == this.m_cbPaperSizeTenSquare ? SQUARE_RESOLUTION : (s == this.m_cbPaperSizeSquareHighRes ? SQUARE_HIGHRES : DEFAULT_RESOLUTION)));
        this.m_tfResolutionX.setText(Integer.toString(format[X]));
        this.m_tfResolutionY.setText(Integer.toString(format[Y]));
    }
}

