/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring;

public class PnFastMath {
    private static final int ATAN2_BITS = 7;
    private static final int ATAN2_BITS2 = 14;
    private static final int ATAN2_MASK = 16383;
    private static final int ATAN2_COUNT = 16384;
    private static final int ATAN2_DIM = (int)Math.sqrt(16384.0);
    private static final float ATAN2_DIM_MINUS_1 = ATAN2_DIM - 1;
    private static final float[] atan2 = new float[16384];

    static {
        int i = 0;
        while (i < ATAN2_DIM) {
            int j = 0;
            while (j < ATAN2_DIM) {
                float x0 = (float)i / (float)ATAN2_DIM;
                float y0 = (float)j / (float)ATAN2_DIM;
                PnFastMath.atan2[j * PnFastMath.ATAN2_DIM + i] = (float)Math.atan2(y0, x0);
                ++j;
            }
            ++i;
        }
    }

    public static final float atan2(float y, float x) {
        float add;
        float mul;
        if (x < 0.0f) {
            if (y < 0.0f) {
                x = -x;
                y = -y;
                mul = 1.0f;
            } else {
                x = -x;
                mul = -1.0f;
            }
            add = (float)(-Math.PI);
        } else {
            if (y < 0.0f) {
                y = -y;
                mul = -1.0f;
            } else {
                mul = 1.0f;
            }
            add = 0.0f;
        }
        float invDiv = ATAN2_DIM_MINUS_1 / (x < y ? y : x);
        int xi = (int)(x * invDiv);
        int yi = (int)(y * invDiv);
        return (atan2[yi * ATAN2_DIM + xi] + add) * mul;
    }
}

