/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring;

import java.util.Iterator;
import jv.function.PuComplexFunction;
import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;

public class PnComplexExplicitEulerStepGenerator
extends PsObject
implements Iterator<PuComplex[]> {
    private static final double DEFAULT_TIME_INCR = 0.1;
    private static final double DEFAULT_START_TIME = 0.0;
    private static final int DEFAULT_ORDER = 1;
    private static final String DEFAULT_RHS_EXPR = "z";
    private static final String DEFAULT_VAR_NAME_TIME = "w";
    private static final String DEFAULT_VAR_NAME_UNKNOWN = "z";
    protected PuComplex m_curTime;
    protected double m_startTime;
    protected PuDouble m_timeIncr;
    protected PuComplexFunction m_rhs = new PuComplexFunction(2, 1);
    protected PuInteger m_order;
    private PuComplex[][] m_curState;
    private PuComplex[][] m_nextState;
    private PuComplex[] m_outBuffer;
    private int m_length;
    private PuComplex[][] m_initValues;

    public PnComplexExplicitEulerStepGenerator() {
        this.m_rhs.setName("ODE Law");
        this.m_rhs.setVariables(new String[]{DEFAULT_VAR_NAME_TIME, "z"});
        this.m_rhs.setExpression("z");
        this.m_curTime = new PuComplex(0.0);
        this.m_order = new PuInteger("Order");
        this.m_order.setDefValue(1);
        this.m_order.setDefBounds(1, 5, 1, 2);
        this.m_order.init();
        this.m_order.addUpdateListener((PsUpdateIf)this);
        this.m_startTime = 0.0;
        this.m_timeIncr = new PuDouble("Time increment");
        this.m_timeIncr.setDefValue(0.1);
        this.m_timeIncr.setDefBounds(0.0, 5.0, 0.05, 0.5);
        this.m_timeIncr.init();
        this.m_order.addUpdateListener((PsUpdateIf)this);
        this.m_initValues = new PuComplex[][]{{new PuComplex(1.0)}};
    }

    public PnComplexExplicitEulerStepGenerator(PuComplexFunction rhs, PuComplex[][] init_values, double startTime, double timeIncr, PuComplex[] outBuffer) {
        this();
        this.setRHS(rhs.getExpression());
        this.setInitValues(init_values);
        this.setStartTime(startTime);
        this.setTimeIncr(timeIncr);
        this.setOutBuffer(outBuffer);
        this.init();
    }

    public void setRHS(String rhsExpr) {
        this.m_rhs.setExpression(rhsExpr);
    }

    public void setOrder(int order) {
        if (order >= 1) {
            this.m_order.setValue(order);
        } else {
            PsDebug.warning((String)("Order " + order + " is not valid."));
        }
    }

    public void setInitValues(PuComplex[][] initValues) {
        this.m_initValues = initValues;
    }

    public void setOutBuffer(PuComplex[] outBuffer) {
        this.m_outBuffer = outBuffer;
    }

    public void setTimeIncr(double timeIncr) {
        this.m_timeIncr.setValue(timeIncr);
    }

    private boolean validateRHS() {
        int order = this.m_order.getValue();
        if (order != this.m_rhs.getNumVariables() - 1) {
            PsDebug.warning((String)"Order does not match number of variables in function object. \nReassign variable names and function object.");
            this.m_rhs.setNumVariables(order + 1);
            String[] varNames = new String[order + 1];
            varNames[0] = DEFAULT_VAR_NAME_TIME;
            varNames[1] = "z";
            String msgVarNames = "Variable names set to {";
            msgVarNames = String.valueOf(msgVarNames) + "w;z";
            int i = 2;
            while (i < order + 1) {
                varNames[i] = "z" + Integer.toString(i - 1);
                msgVarNames = String.valueOf(msgVarNames) + ";" + varNames[i];
                ++i;
            }
            msgVarNames = String.valueOf(msgVarNames) + "}.";
            PsDebug.message((String)msgVarNames);
            this.m_rhs.setNumVariables(order + 1);
            this.m_rhs.setVariables(varNames);
            this.m_rhs.updatePanels((Object)this.m_rhs);
            return false;
        }
        return true;
    }

    private boolean validateInitValues() {
        int order = this.m_order.getValue();
        PuComplex[][] validatedInitValues = this.m_initValues;
        this.m_length = validatedInitValues[0].length;
        if (order != validatedInitValues.length) {
            PsDebug.warning((String)("Order of ODE(" + this.m_order + ") does not match length of init value array (" + this.m_initValues.length + "). \n" + "Setting all higher order init values to zero."));
            validatedInitValues = new PuComplex[order][this.m_length];
            validatedInitValues[0] = this.m_initValues[0];
            int k = 1;
            while (k < order) {
                PuComplex[] init_values_order_k = new PuComplex[this.m_length];
                int i = 0;
                while (i < this.m_length) {
                    init_values_order_k[i] = new PuComplex(0.0);
                    ++i;
                }
                validatedInitValues[k] = init_values_order_k;
                ++k;
            }
            this.m_initValues = validatedInitValues;
            return false;
        }
        return true;
    }

    public void init() {
        super.init();
        this.validateRHS();
        this.validateInitValues();
        int order = this.m_order.getValue();
        this.m_curState = new PuComplex[order][this.m_length];
        this.m_nextState = new PuComplex[order][this.m_length];
        int k = 0;
        while (k < order) {
            int i = 0;
            while (i < this.m_length) {
                this.m_curState[k][i] = new PuComplex(this.m_initValues[k][i].re, this.m_initValues[k][i].im);
                this.m_nextState[k][i] = new PuComplex(0.0);
                ++i;
            }
            ++k;
        }
    }

    public void reset() {
        this.m_curTime.set(this.m_startTime, 0.0);
        this.init();
        this.update(this);
    }

    private void setStartTime(double startTime) {
        this.m_startTime = startTime;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public PuComplex[] next() {
        PuComplex reg = new PuComplex(0.0);
        int order = this.m_order.getValue();
        PuComplex[] args = new PuComplex[order + 1];
        args[0] = this.m_curTime;
        double dt = this.m_timeIncr.getValue();
        int i = 0;
        while (i < this.m_length) {
            int k = 0;
            while (k < order - 1) {
                reg.set(this.m_curState[k + 1][i].re, this.m_curState[k + 1][i].im);
                reg.mult(dt);
                reg.add(this.m_curState[k][i]);
                this.m_nextState[k][i].re = reg.re;
                this.m_nextState[k][i].im = reg.im;
                args[k + 1] = this.m_curState[k][i];
                ++k;
            }
            args[order] = this.m_curState[order - 1][i];
            PuComplex gz = this.m_rhs.eval(args);
            this.m_nextState[order - 1][i].set(gz.re, gz.im);
            this.m_nextState[order - 1][i].mult(dt);
            this.m_nextState[order - 1][i].add(this.m_curState[order - 1][i]);
            PuComplex w_nNext = this.m_nextState[0][i];
            this.m_outBuffer[i].set(w_nNext.re, w_nNext.im);
            ++i;
        }
        PuComplex[][] tmp = this.m_curState;
        this.m_curState = this.m_nextState;
        this.m_nextState = tmp;
        this.m_curTime.add(dt);
        this.update(this);
        return this.m_outBuffer;
    }

    public boolean update(Object event) {
        if (event == this.m_order) {
            this.init();
        }
        return super.update(event);
    }

    @Override
    public void remove() {
    }
}

