/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring;

import devDomainColoring.PjDomainColoring;
import devDomainColoring.PsRenderToFileDlg;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PdVector_IP;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsTabPanel;
import jv.project.PjProject_IP;

public class PjDomainColoring_IP
extends PjProject_IP
implements ActionListener,
ItemListener {
    private static final Color LIGHT_BLUE = new Color(220, 235, 255);
    private PjDomainColoring m_pjDomainColoring;
    private List m_lExamples;
    private Button m_bSave;
    private Button m_bPlot;
    private Button m_bRun;
    private Button m_bPause;
    private Button m_bReset;
    private PsRenderToFileDlg m_dlgSave;
    private PdVector_IP m_pDomainBoundsVectorIP;
    private Checkbox m_cModeFlat;
    private Checkbox m_cModeFlatGeom;
    private Checkbox m_cModePerspective;
    private Checkbox m_cModeRiemannSphere;
    private PsPanel m_pCESGen;

    public PjDomainColoring_IP() {
        if (this.getClass() == PjDomainColoring_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_pjDomainColoring = (PjDomainColoring)parent;
        this.makeLayout();
    }

    private void makeLayout() {
        PsTabPanel tabPanel = new PsTabPanel();
        tabPanel.addPanel("Functions", this.createFunctionPanel());
        tabPanel.addPanel("Colors", this.m_pjDomainColoring.m_csManager.getInfoPanel());
        tabPanel.addPanel("Render", this.createRenderPanel());
        tabPanel.addPanel("ODE", this.createODEPanel());
        this.add((Component)tabPanel);
    }

    private PsPanel createFunctionPanel() {
        PsPanel pFunction = new PsPanel();
        PsPanel pFunctionIP = this.m_pjDomainColoring.m_function.getInfoPanel();
        pFunctionIP.setBackColor(LIGHT_BLUE);
        pFunctionIP.add((Component)this.m_pjDomainColoring.m_numIterations.getInfoPanel());
        pFunction.add((Component)pFunctionIP);
        pFunction.add((Component)new Label(""));
        PsPanel pDomainBounds = new PsPanel();
        pDomainBounds.addTitle("Domain Bounds");
        this.m_pDomainBoundsVectorIP = new PdVector_IP();
        this.m_pDomainBoundsVectorIP.setTitle("Left, Bottom, Right, Top:");
        this.m_pDomainBoundsVectorIP.setParent((PsUpdateIf)this);
        this.m_pDomainBoundsVectorIP.setVector(this.m_pjDomainColoring.m_imageDomain.getDomainBounds());
        pDomainBounds.add((Component)this.m_pDomainBoundsVectorIP);
        pFunction.add((Component)pDomainBounds);
        pFunction.add((Component)new Label(""));
        PsPanel pExamples = new PsPanel();
        pExamples.addTitle("Select an Example");
        this.m_lExamples = new List(14);
        this.m_lExamples.addItemListener(this);
        int i = 0;
        while (i < PjDomainColoring.EXAMPLE_FUNCTIONS.length) {
            this.m_lExamples.add(PjDomainColoring.EXAMPLE_FUNCTIONS[i]);
            ++i;
        }
        pExamples.add((Component)this.m_lExamples);
        pFunction.add((Component)pExamples);
        return pFunction;
    }

    private PsPanel createRenderPanel() {
        PsPanel pRenderOptions = new PsPanel();
        pRenderOptions.addSubTitle("Viewing Mode");
        PsPanel pMode = new PsPanel((LayoutManager)new GridLayout(2, 2));
        CheckboxGroup cbgModes = new CheckboxGroup();
        this.m_cModeFlat = new Checkbox("Flat", true, cbgModes);
        this.m_cModeFlat.addItemListener(this);
        this.m_cModePerspective = new Checkbox("Perspective", false, cbgModes);
        this.m_cModePerspective.addItemListener(this);
        this.m_cModeFlatGeom = new Checkbox("Flat Geom", false, cbgModes);
        this.m_cModeFlatGeom.addItemListener(this);
        this.m_cModeRiemannSphere = new Checkbox("Riemann Sphere", false, cbgModes);
        this.m_cModeRiemannSphere.addItemListener(this);
        pMode.add((Component)this.m_cModeFlat);
        pMode.add((Component)this.m_cModePerspective);
        pMode.add((Component)this.m_cModeFlatGeom);
        pMode.add((Component)this.m_cModeRiemannSphere);
        pRenderOptions.add((Component)pMode);
        pRenderOptions.addLine(1);
        pRenderOptions.addTitle("Render Options");
        PsPanel pRes = new PsPanel();
        pRes.add((Component)this.m_pjDomainColoring.m_resolution.getInfoPanel());
        PsPanel pImg = this.m_pjDomainColoring.m_imageDomain.getInfoPanel();
        pImg.removeTitle();
        pRes.add((Component)pImg);
        pRenderOptions.add((Component)pRes);
        pRenderOptions.addLine(1);
        PsPanel pUVDiscretization = new PsPanel((LayoutManager)new GridLayout(2, 1));
        pUVDiscretization.add((Component)this.m_pjDomainColoring.m_geomLinesU.getInfoPanel());
        pUVDiscretization.add((Component)this.m_pjDomainColoring.m_geomLinesV.getInfoPanel());
        pRenderOptions.add((Component)pUVDiscretization);
        pRenderOptions.add((Component)this.m_pjDomainColoring.m_autoPlot.getInfoPanel());
        PsPanel pButtonPanel = new PsPanel((LayoutManager)new GridLayout(1, 2));
        this.m_bPlot = new Button("Replot");
        this.m_bPlot.addActionListener(this);
        pButtonPanel.add((Component)this.m_bPlot);
        this.m_bSave = new Button("Save Image");
        this.m_bSave.addActionListener(this);
        pButtonPanel.add((Component)this.m_bSave);
        pRenderOptions.add((Component)pButtonPanel);
        return pRenderOptions;
    }

    private PsPanel createODEPanel() {
        PsPanel pODE = new PsPanel();
        this.m_pCESGen = this.m_pjDomainColoring.m_cesGen.getInfoPanel();
        pODE.add((Component)this.m_pCESGen);
        PsPanel pButtons = new PsPanel((LayoutManager)new GridLayout(1, 3));
        this.m_bRun = new Button("Run");
        this.m_bRun.addActionListener(this);
        pButtons.add((Component)this.m_bRun);
        this.m_bPause = new Button("Pause");
        this.m_bPause.addActionListener(this);
        pButtons.add((Component)this.m_bPause);
        this.m_bReset = new Button("Reset");
        this.m_bReset.addActionListener(this);
        pButtons.add((Component)this.m_bReset);
        pODE.add((Component)pButtons);
        return pODE;
    }

    public boolean update(Object event) {
        if (this.m_pjDomainColoring == null) {
            PsDebug.warning((String)"missing parent.");
            return false;
        }
        if (event == this.m_pjDomainColoring) {
            PsPanel.setEnabled((Component)this.m_bPlot, (!this.m_pjDomainColoring.m_autoPlot.getState() ? 1 : 0) != 0);
            this.m_pDomainBoundsVectorIP.update((Object)this.m_pjDomainColoring.m_imageDomain.getDomainBounds());
        } else {
            if (event == this.m_pDomainBoundsVectorIP) {
                this.m_pjDomainColoring.update((Object)this.m_pjDomainColoring.m_imageDomain);
                return true;
            }
            if (event == this.m_pjDomainColoring.m_imageDomain.getDomainBounds()) {
                this.m_pDomainBoundsVectorIP.update((Object)this.m_pjDomainColoring.m_imageDomain.getDomainBounds());
                return true;
            }
        }
        return super.update(event);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        if (o == this.m_bSave) {
            this.m_dlgSave = new PsRenderToFileDlg(PsConfig.getFrame(), true, this.m_pjDomainColoring);
            this.m_dlgSave.setSize(500, 400);
            this.m_dlgSave.setVisible(true);
        } else if (o == this.m_bPlot) {
            this.m_pjDomainColoring.computeGeometry();
            this.m_pjDomainColoring.computeTextureImage(true);
            this.m_pjDomainColoring.computeTextureCoordinates();
            this.m_pjDomainColoring.m_geom.update((Object)this.m_pjDomainColoring.m_geom);
        } else if (o == this.m_bRun) {
            this.m_pjDomainColoring.initCESGen();
            this.m_pCESGen.setEnabled(false);
            this.m_pjDomainColoring.getAnimation().start();
        } else if (o == this.m_bPause) {
            this.m_pjDomainColoring.getAnimation().stop();
            this.m_pCESGen.setEnabled(true);
        } else if (o == this.m_bReset) {
            this.m_pjDomainColoring.getAnimation().stop();
            this.m_pCESGen.setEnabled(true);
            this.m_pjDomainColoring.m_cesGen.reset();
            this.m_pjDomainColoring.computeTextureImage(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object s = event.getSource();
        if (s == this.m_lExamples) {
            this.m_pjDomainColoring.setFunction(this.m_lExamples.getSelectedItem());
            this.m_pjDomainColoring.m_function.update((Object)this.m_pjDomainColoring.m_function);
            return;
        }
        if (s == this.m_cModeFlat) {
            this.m_pjDomainColoring.setMode(0);
        } else if (s == this.m_cModeFlatGeom) {
            this.m_pjDomainColoring.setMode(1);
        } else if (s == this.m_cModePerspective) {
            this.m_pjDomainColoring.setMode(2);
        } else if (s == this.m_cModeRiemannSphere) {
            this.m_pjDomainColoring.setMode(3);
        }
        this.m_pjDomainColoring.update(this.m_pjDomainColoring.m_function);
    }
}

