/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring;

import devDomainColoring.PiImageDomain;
import devDomainColoring.PnComplexExplicitEulerStepGenerator;
import devDomainColoring.colors.PuAbstractColorScheme;
import devDomainColoring.colors.PuColorSchemeManager;
import devDomainColoring.colors.schemes.PuCSBWGradient;
import devDomainColoring.colors.schemes.PuCSColorWheel2d;
import devDomainColoring.colors.schemes.PuCSConcentricCircles2d;
import devDomainColoring.colors.schemes.PuCSConstant;
import devDomainColoring.colors.schemes.PuCSCustomColorWheel2d;
import devDomainColoring.colors.schemes.PuCSDiscrete2d;
import devDomainColoring.colors.schemes.PuCSGrid;
import devDomainColoring.colors.schemes.PuCSHorizontalStripes;
import devDomainColoring.colors.schemes.PuCSModulusCircles2d;
import devDomainColoring.colors.schemes.PuCSPattern2d;
import devDomainColoring.colors.schemes.PuCSPolesAndZeros;
import devDomainColoring.colors.schemes.PuCSRadialLines2d;
import devDomainColoring.colors.schemes.PuCSVerticalStripes;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.util.Vector;
import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.function.PuComplexFunction;
import jv.geom.PgElementSet;
import jv.loader.PgLoader;
import jv.number.PuBoolean;
import jv.number.PuComplex;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvCameraIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.thirdParty.ruler.PgAxes;
import jv.vecmath.PdVector;
import jv.viewer.PvDisplay;
import jvx.imageDisplay.PiImageSource;
import jvx.imageDisplay.PvImageDisplay;

public class PjDomainColoring
extends PjProject
implements PvPickListenerIf {
    public static final String[] EXAMPLE_FUNCTIONS = new String[]{"z", "1/z", "z^2", "z^3", "sqrt(z)", "sin(z)", "exp(z)", "log(z)", "(z+1/z)/2", "(z^2-1)*(z-2-i)^2/(z^2+2+2*i)", "(z-1)*(z+1)^2/((z-i)^2*(z+i))", "z^5-1", "z+1/z^4", "cos(z)/(sin(z^4-1))"};
    private static final int GEOMETRY_DISCRETIZATION_U = 50;
    private static final int GEOMETRY_DISCRETIZATION_V = 50;
    private static final double[] DEFAULT_DOMAIN_BOUNDS = new double[]{-1.0, -1.0, 1.0, 1.0};
    protected static final int MODE_UNDEFINED = -1;
    protected static final int MODE_FLAT = 0;
    protected static final int MODE_FLAT_GEOM = 1;
    protected static final int MODE_PERSPECTIVE = 2;
    protected static final int MODE_RIEMANN_SPHERE = 3;
    private int m_mode = -1;
    public boolean m_bSphereModeEnabled = false;
    protected PgElementSet m_geom = new PgElementSet(3);
    protected PuInteger m_geomLinesU = new PuInteger("U Lines", (PsUpdateIf)this);
    protected PuInteger m_geomLinesV = new PuInteger("V Lines", (PsUpdateIf)this);
    protected PuComplexFunction m_function;
    protected PuInteger m_numIterations;
    protected PuBoolean m_autoPlot;
    protected PvImageDisplay m_imageDisplay;
    protected PiImageDomain m_imageDomain;
    protected PuInteger m_resolution = new PuInteger("Resolution", (PsUpdateIf)this);
    protected PuColorSchemeManager m_csManager;
    protected PnComplexExplicitEulerStepGenerator m_cesGen;

    public PjDomainColoring() {
        super("Domain Coloring");
        this.m_function = new PuComplexFunction(1, 1);
        this.m_function.setParent((PsUpdateIf)this);
        this.m_numIterations = new PuInteger("Num. of Iterations", (PsUpdateIf)this);
        this.m_imageDomain = new PiImageDomain();
        this.m_imageDomain.setParent((PsUpdateIf)this);
        this.m_imageDisplay = new PvImageDisplay();
        this.m_imageDisplay.setParent((PsUpdateIf)this);
        this.m_imageDisplay.setImageSource((PiImageSource)this.m_imageDomain);
        PuCSRadialLines2d ftrcs1 = new PuCSRadialLines2d();
        PuCSModulusCircles2d ftrcs2 = new PuCSModulusCircles2d();
        PuCSConcentricCircles2d ftrcs3 = new PuCSConcentricCircles2d();
        PuCSGrid ftrcs4 = new PuCSGrid();
        PuCSPolesAndZeros ftrcs5 = new PuCSPolesAndZeros();
        Vector<PuAbstractColorScheme> ftrCS = new Vector<PuAbstractColorScheme>();
        ftrCS.add(ftrcs1);
        ftrCS.add(ftrcs2);
        ftrCS.add(ftrcs3);
        ftrCS.add(ftrcs4);
        ftrCS.add(ftrcs5);
        PuCSColorWheel2d bkgcs1 = new PuCSColorWheel2d();
        PuCSBWGradient bkgcs2 = new PuCSBWGradient();
        PuCSDiscrete2d bkgcs3 = new PuCSDiscrete2d();
        PuCSPattern2d bkgcs4 = new PuCSPattern2d();
        PuCSVerticalStripes bkgcs5 = new PuCSVerticalStripes();
        PuCSHorizontalStripes bkgcs6 = new PuCSHorizontalStripes();
        PuCSCustomColorWheel2d bkgcs7 = new PuCSCustomColorWheel2d();
        PuCSConstant bkgcs8 = new PuCSConstant();
        Vector<PuAbstractColorScheme> bkgCS = new Vector<PuAbstractColorScheme>();
        bkgCS.add(bkgcs1);
        bkgCS.add(bkgcs2);
        bkgCS.add(bkgcs3);
        bkgCS.add(bkgcs4);
        bkgCS.add(bkgcs5);
        bkgCS.add(bkgcs6);
        bkgCS.add(bkgcs7);
        bkgCS.add(bkgcs8);
        this.m_csManager = new PuColorSchemeManager(bkgCS, ftrCS);
        this.m_csManager.addUpdateListener((PsUpdateIf)this);
        this.m_autoPlot = new PuBoolean("Automatic Replot");
        this.m_autoPlot.addUpdateListener((PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == PjDomainColoring.class) {
            this.init();
        }
        this.setAnimation(new PsAnimation());
        this.m_anim.setName("Animation Object");
        this.m_anim.setRepeat(1);
        this.m_anim.setSpeedType(0);
        this.m_anim.addTimeListener((PsTimeListenerIf)this);
        this.m_anim.setTimeInterval(0.0, 50.0);
        this.m_cesGen = new PnComplexExplicitEulerStepGenerator();
    }

    public void init() {
        super.init();
        this.m_geom.setDimOfTextures(2);
        this.m_geom.assureVertexTextures();
        this.m_geom.showVertexTexture(true);
        this.m_geom.showEdges(false);
        this.m_geom.showVertices(false);
        this.m_imageDomain.setDomainBounds(DEFAULT_DOMAIN_BOUNDS);
        this.m_geomLinesU.setDefBounds(10, 250, 1, 5);
        this.m_geomLinesU.setDefValue(50);
        this.m_geomLinesU.init();
        this.m_geomLinesV.setDefBounds(10, 250, 1, 5);
        this.m_geomLinesV.setDefValue(50);
        this.m_geomLinesV.init();
        this.m_function.setExpression("z");
        this.m_function.setName("Type a Function");
        this.m_numIterations.setDefBounds(1, 50, 1, 2);
        this.m_numIterations.setDefValue(1);
        this.m_numIterations.init();
        this.m_resolution.setDefBounds(100, 2000, 1, 10);
        this.m_resolution.setDefValue(500);
        this.m_resolution.init();
        this.m_imageDomain.setBlockSize(2);
        this.m_autoPlot.setState(true);
    }

    public void start() {
        super.start();
        if (this.m_display == null) {
            PsDebug.warning((String)"missing display");
        }
        this.m_display.setBackgroundColor(Color.black);
        this.m_display.setForegroundColor(Color.white);
        this.m_imageDisplay.setDistance(3.0);
        this.m_imageDisplay.setInterest(new PdVector(0.0, 0.0, 0.0));
        this.m_imageDomain.createImage(null, this.m_display.getSize().width, this.m_display.getSize().height);
        this.m_display.showAxes(true);
        PgAxes axes = ((PvDisplay)this.m_display).getAxes();
        axes.setEnabledAutoBounds(false);
        this.updateAxes();
        this.computeTextureImage(false);
        this.m_imageDisplay.start();
        this.setMode(0);
    }

    public void setDisplay(PvDisplayIf disp) {
        if (disp == null) {
            PsDebug.warning((String)"missing argument");
            return;
        }
        if (this.m_imageDisplay == null) {
            PsDebug.error((String)"missing internal instance m_imageDisplay");
            return;
        }
        super.setDisplay(disp);
        this.m_imageDisplay.setImageDisplay(disp);
    }

    private void updateAxes() {
        PgAxes axes = ((PvDisplay)this.m_display).getAxes();
        if (axes == null) {
            return;
        }
        PdVector domBnds = this.m_imageDomain.getDomainBounds();
        PdVector[] bndBox = new PdVector[]{new PdVector(domBnds.getEntry(0), domBnds.getEntry(1), 0.0), new PdVector(domBnds.getEntry(2), domBnds.getEntry(3), 0.0)};
        axes.setBounds(bndBox);
        axes.update((Object)axes);
    }

    public boolean update(Object event) {
        PsDebug.initTime();
        if (event == this.m_function || event == this.m_numIterations) {
            if (!this.m_autoPlot.getState()) {
                return true;
            }
            this.computeTextureImage(true);
            if (this.getMode() != 0) {
                this.computeGeometry();
                this.m_geom.update((Object)this.m_geom);
                this.m_display.fit();
            }
            this.m_anim.stop();
        } else if (event == this.m_resolution) {
            this.m_imageDomain.createImage(null, this.m_resolution.getValue(), this.m_resolution.getValue());
            if (!this.m_autoPlot.getState()) {
                return true;
            }
            this.computeTextureImage(true);
            this.m_geom.update((Object)this.m_geom);
            this.m_anim.stop();
        } else if (event == this.m_csManager) {
            if (!this.m_autoPlot.getState()) {
                return true;
            }
            this.computeTextureImage(false);
            this.m_geom.update((Object)this.m_geom);
            this.m_anim.stop();
        } else if (event == this.m_geomLinesU || event == this.m_geomLinesV) {
            if (!this.m_autoPlot.getState()) {
                return true;
            }
            if (this.getMode() != 0) {
                this.computeTextureImage(true);
                this.computeGeometry();
                this.computeTextureCoordinates();
                this.m_geom.update((Object)this.m_geom);
            }
        } else {
            if (event == this.m_imageDisplay) {
                Dimension size = this.m_imageDisplay.getImageDisplay().getSize();
                System.out.println("Display resolution: " + size.width + " x " + size.height);
                this.updateAxes();
                return super.update((Object)this);
            }
            if (event == this.m_imageDomain) {
                if (!this.m_autoPlot.getState()) {
                    return true;
                }
                this.computeTextureImage(true);
                if (this.getMode() != 0) {
                    this.computeGeometry();
                    this.computeTextureCoordinates();
                    this.m_geom.update((Object)this.m_geom);
                    this.m_display.fit();
                }
                return true;
            }
            if (event == this.m_autoPlot) {
                if (this.m_autoPlot.getState()) {
                    this.computeTextureImage(true);
                    if (this.getMode() != 0) {
                        this.computeGeometry();
                        this.computeTextureCoordinates();
                        this.m_geom.update((Object)this.m_geom);
                        this.m_display.fit();
                    }
                }
                return super.update((Object)this);
            }
            return super.update(event);
        }
        PsDebug.notify((String)("usedTime (update): " + PsDebug.getTimeIncr()));
        return super.update((Object)this);
    }

    public void computeTextureCoordinates() {
        this.m_geom.makeVertexTextureFromUV(this.m_geomLinesU.getValue(), this.m_geomLinesV.getValue(), 0);
    }

    public void computeTextureImage(boolean bFuncEval) {
        Image imDomainColoring = null;
        this.m_imageDomain.setNumIterations(this.m_numIterations.getValue());
        this.m_imageDomain.setFunction(this.m_function);
        this.m_imageDomain.setColorScheme(this.m_csManager.getComposedColorScheme());
        if (bFuncEval) {
            this.m_imageDomain.compute();
        } else {
            this.m_imageDomain.computeColors();
        }
        imDomainColoring = this.m_imageDomain.getImage();
        this.m_geom.setTextureImage(imDomainColoring);
        if (this.getMode() == 0) {
            this.m_display.setBackgroundImage(imDomainColoring);
            this.m_display.showBackgroundImage(true);
        }
        this.m_display.update(null);
    }

    public void computeGeometry() {
        int linesU = this.m_geomLinesU.getValue();
        int linesV = this.m_geomLinesV.getValue();
        double[] bounds = null;
        this.setEnabledSphereMode(this.m_mode == 3);
        int RE_MIN = 0;
        int RE_MAX = 2;
        int IM_MIN = 1;
        int IM_MAX = 3;
        switch (this.m_mode) {
            case 1: {
                bounds = this.m_imageDomain.getDomainBounds().m_data;
                this.m_geom.computePlane(linesU, linesV, bounds[RE_MIN], bounds[IM_MIN], bounds[RE_MAX], bounds[IM_MAX]);
                this.m_geom.setName("Complex Plane");
                break;
            }
            case 2: {
                bounds = this.m_imageDomain.getDomainBounds().m_data;
                this.m_geom.computePlane(linesU, linesV, bounds[RE_MIN], bounds[IM_MIN], bounds[RE_MAX], bounds[IM_MAX]);
                this.deformGeometry();
                this.m_geom.setName("Height Map");
                break;
            }
            case 3: {
                this.m_geom.computeSphere(linesV, linesU, 1.0);
                this.m_geom.setName("Riemann Sphere");
                break;
            }
            default: {
                return;
            }
        }
    }

    private void deformGeometry() {
        double CUTMAX = 4.0;
        int nov = this.m_geom.getNumVertices();
        PuComplex z = new PuComplex();
        int i = 0;
        while (i < nov) {
            double h;
            PdVector vertex = this.m_geom.getVertex(i);
            z.set(vertex);
            PuComplex fz = this.m_function.eval(z);
            vertex.m_data[2] = h = Math.min(fz.abs(), CUTMAX);
            ++i;
        }
        this.m_geom.makeVertexNormals();
    }

    public void setEnabledSphereMode(boolean sphereModeEnabled) {
        this.m_bSphereModeEnabled = sphereModeEnabled;
    }

    public boolean setFunction(String f) {
        if (!this.m_function.setExpression(f)) {
            PsDebug.warning((String)("Could not parse function: " + f));
            return false;
        }
        return true;
    }

    public boolean saveImage(String savePath, int resX, int resY) {
        try {
            PvDisplayIf disp = this.m_imageDisplay.getImageDisplay();
            PvCameraIf cam = disp.getCamera();
            double dist = cam.getDist();
            PdVector interest = cam.getInterest();
            Dimension size = new Dimension(resX, resY);
            PdVector domainBounds = PvImageDisplay.computeDomainBounds((Dimension)size, (PdVector)interest, (double)dist);
            Image im = PiImageDomain.computeImage(this.m_function, this.m_numIterations.getValue(), domainBounds, resX, resY, this.m_csManager.getComposedColorScheme(), this.m_bSphereModeEnabled);
            PgLoader loader = new PgLoader();
            loader.saveImage(im, savePath);
            System.out.println("Successfully saved to " + savePath);
            return true;
        }
        catch (Exception e) {
            PsDebug.error((String)("Error: writing image to file failed, file = " + savePath));
            e.printStackTrace();
            return false;
        }
    }

    public void pickInitial(PvPickEvent pos) {
        PuComplex z;
        PdVector v = pos.getVertex();
        PuComplex fz = z = new PuComplex(v.getEntry(0), v.getEntry(1));
        int i = 0;
        while (i < this.m_numIterations.getValue()) {
            fz = this.m_function.eval(fz);
            ++i;
        }
        double arg = Math.atan2(z.im, z.re);
        double h = arg / (Math.PI * 2) + 0.5;
        System.out.println("********* Point Info *********");
        System.out.println("* Point: " + z);
        System.out.println("* Argument: " + arg);
        System.out.println("* Interpolation parameter: " + h);
        System.out.println("* f(z): " + fz);
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int mode) {
        if (this.m_mode == mode) {
            return;
        }
        this.m_mode = mode;
        switch (this.m_mode) {
            default: {
                this.m_mode = 0;
            }
            case 0: {
                this.m_imageDomain.setSphereMode(false);
                if (this.m_display.containsGeometry((PgGeometryIf)this.m_geom)) {
                    this.m_display.removeGeometry((PgGeometryIf)this.m_geom);
                }
                this.m_display.showAxes(false);
                this.m_display.showBndBox(false);
                this.m_display.setBackgroundImage(this.m_imageDomain.getImage());
                this.m_display.showBackgroundImage(true);
                this.m_display.selectCamera(1);
                this.m_display.setMajorMode(3);
                break;
            }
            case 1: {
                this.m_imageDomain.setSphereMode(false);
                this.computeGeometry();
                this.computeTextureImage(true);
                this.computeTextureCoordinates();
                if (!this.m_display.containsGeometry((PgGeometryIf)this.m_geom)) {
                    this.m_display.addGeometry((PgGeometryIf)this.m_geom);
                }
                this.m_display.showAxes(true);
                this.m_display.showBndBox(false);
                this.m_display.showBackgroundImage(false);
                this.m_display.selectCamera(1);
                this.m_display.setMajorMode(3);
                break;
            }
            case 2: 
            case 3: {
                if (this.m_mode == 3) {
                    this.m_imageDomain.setSphereMode(true);
                }
                this.computeGeometry();
                this.computeTextureImage(true);
                this.computeTextureCoordinates();
                this.computeGeometry();
                if (!this.m_display.containsGeometry((PgGeometryIf)this.m_geom)) {
                    this.m_display.addGeometry((PgGeometryIf)this.m_geom);
                }
                this.m_display.showAxes(false);
                this.m_display.showBndBox(true);
                this.m_display.showBackgroundImage(false);
                this.m_display.selectCamera(0);
                this.m_display.setMajorMode(0);
            }
        }
        this.m_resolution.setEnabled(this.m_mode != 0);
        this.m_geomLinesU.setEnabled(this.m_mode != 0);
        this.m_geomLinesV.setEnabled(this.m_mode != 0);
        if (this.m_mode != 0) {
            this.m_display.fit();
        }
    }

    public boolean setTime(PsTimeEvent time) {
        this.m_cesGen.next();
        this.m_imageDomain.computeColors();
        Image imDomainColoring = this.m_imageDomain.getImage();
        this.m_geom.setTextureImage(imDomainColoring);
        this.m_display.setBackgroundImage(imDomainColoring);
        this.m_display.showBackgroundImage(true);
        this.m_display.update(null);
        System.out.println("Time step");
        return super.setTime(time);
    }

    protected void initCESGen() {
        PuComplex[] outBuffer = this.m_imageDomain.getFunctionValues();
        PuComplex[][] initValues = new PuComplex[1][outBuffer.length];
        int i = 0;
        while (i < outBuffer.length) {
            initValues[0][i] = new PuComplex(outBuffer[i].re, outBuffer[i].im);
            ++i;
        }
        this.m_cesGen.setInitValues(initValues);
        this.m_cesGen.setOutBuffer(outBuffer);
        this.m_cesGen.init();
    }
}

