/*
 * Decompiled with CFR 0.152.
 */
package devDomainColoring;

import devDomainColoring.colors.PuColorSchemeIf;
import java.awt.Image;
import jv.function.PuComplexFunction;
import jv.number.PuComplex;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jvx.imageDisplay.PiImageSource;

public class PiImageDomain
extends PiImageSource {
    private PuComplexFunction m_function;
    private int m_numIterations;
    private PuColorSchemeIf m_colorScheme;
    private PuComplex[] m_pixIter;
    private boolean m_sphereMode;

    public PiImageDomain() {
        this.setName("Image Domain");
        this.m_pixIter = null;
        if (((Object)((Object)this)).getClass() == PiImageDomain.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_pixIter = null;
        this.setDomainBounds(-1.0, -1.0, 1.0, 1.0);
        this.m_blockSize.setValue(1);
        this.m_numIterations = 1;
    }

    public boolean update(Object event) {
        return super.update(event);
    }

    public PuComplex[] getFunctionValues() {
        return this.m_pixIter;
    }

    public static Image computeImage(PuComplexFunction function, int numIterations, PdVector domainBounds, int imgWidth, int imgHeight, PuColorSchemeIf colorScheme, boolean sphereMode) {
        PiImageDomain imgDomain = new PiImageDomain();
        imgDomain.createImage(null, imgWidth, imgHeight);
        imgDomain.setDomainBounds(domainBounds);
        imgDomain.setNumIterations(numIterations);
        imgDomain.setFunction(function);
        imgDomain.setColorScheme(colorScheme);
        imgDomain.setSphereMode(sphereMode);
        imgDomain.compute();
        imgDomain.computeColors();
        Image img = imgDomain.getImage();
        return img;
    }

    public boolean setImageSize(int width, int height) {
        if (!super.setImageSize(width, height)) {
            return false;
        }
        this.m_pixIter = new PuComplex[this.m_imageWidth * this.m_imageHeight];
        int i = this.m_imageWidth * this.m_imageHeight - 1;
        while (i >= 0) {
            this.m_pixIter[i] = new PuComplex();
            --i;
        }
        return true;
    }

    public synchronized void compute() {
        if (this.m_imageWidth <= 0 || this.m_imageHeight <= 0) {
            return;
        }
        int blockSize = this.m_blockSize.getValue();
        double xMin = this.m_domainBounds.m_data[0];
        double xMax = this.m_domainBounds.m_data[2];
        double yMin = this.m_domainBounds.m_data[1];
        double yMax = this.m_domainBounds.m_data[3];
        this.computeFunctionValues(this.m_pixIter, this.m_imageWidth, this.m_imageHeight, blockSize, xMin, yMin, xMax, yMax, this.m_sphereMode);
        this.computeColors();
    }

    private void computeFunctionValues(PuComplex[] pixIter, int imageWidth, int imageHeight, int blockSize, double xMin, double yMin, double xMax, double yMax, boolean sphereMode) {
        if (imageWidth <= 1 || imageHeight <= 1) {
            return;
        }
        PuComplex z = new PuComplex();
        PuComplex fz = new PuComplex();
        int ind = 0;
        if (sphereMode) {
            double du1 = (double)blockSize * 1.0 / ((double)imageWidth - 1.0);
            double dv1 = (double)blockSize * 1.0 / ((double)imageHeight - 1.0);
            double v = 1.0 - dv1 / 2.0;
            int i = 0;
            while (i < imageHeight) {
                int indPrev = ind;
                double u = du1 / 2.0;
                int j = 0;
                while (j < imageWidth) {
                    double sx = Math.cos(Math.PI * 2 * u) * Math.cos(Math.PI * (v - 0.5));
                    double sy = Math.sin(Math.PI * 2 * u) * Math.cos(Math.PI * (v - 0.5));
                    double sz = Math.sin(Math.PI * (v - 0.5));
                    double newu = sx / (1.0 - sz);
                    double newv = sy / (1.0 - sz);
                    z.set(newu, newv);
                    fz = this.m_function.eval(z);
                    int k = 1;
                    while (k < this.m_numIterations) {
                        fz = this.m_function.eval(fz);
                        ++k;
                    }
                    int blockRemainW = Math.min(blockSize, imageWidth - j);
                    int k2 = 0;
                    while (k2 < blockRemainW) {
                        pixIter[ind++].copy(fz);
                        ++k2;
                    }
                    u += du1;
                    j += blockSize;
                }
                int blockRemainH = Math.min(blockSize, imageHeight - i) - 1;
                int k = 0;
                while (k < blockRemainH) {
                    int indHor = indPrev;
                    int j2 = 0;
                    while (j2 < imageWidth) {
                        pixIter[ind++].copy(pixIter[indHor++]);
                        ++j2;
                    }
                    ++k;
                }
                v -= dv1;
                i += blockSize;
            }
        } else {
            double du = (double)blockSize * (xMax - xMin) / ((double)imageWidth - 1.0);
            double dv = (double)blockSize * (yMax - yMin) / ((double)imageHeight - 1.0);
            double v = yMax - dv / 2.0;
            int i = 0;
            while (i < imageHeight) {
                int k;
                int indPrev = ind;
                double u = xMin + du / 2.0;
                int j = 0;
                while (j < imageWidth) {
                    z.set(u, v);
                    fz = this.m_function.eval(z);
                    k = 1;
                    while (k < this.m_numIterations) {
                        fz = this.m_function.eval(fz);
                        ++k;
                    }
                    int blockRemainW = Math.min(blockSize, imageWidth - j);
                    int k3 = 0;
                    while (k3 < blockRemainW) {
                        pixIter[ind++].copy(fz);
                        ++k3;
                    }
                    u += du;
                    j += blockSize;
                }
                int blockRemainH = Math.min(blockSize, imageHeight - i) - 1;
                k = 0;
                while (k < blockRemainH) {
                    int indHor = indPrev;
                    int j3 = 0;
                    while (j3 < imageWidth) {
                        pixIter[ind++].copy(pixIter[indHor++]);
                        ++j3;
                    }
                    ++k;
                }
                v -= dv;
                i += blockSize;
            }
        }
    }

    public void computeColors() {
        if (this.m_imageWidth <= 0 || this.m_imageHeight <= 0) {
            return;
        }
        if (this.m_colorScheme == null) {
            PsDebug.warning((String)"missing color scheme");
            return;
        }
        int numPixels = this.m_imageWidth * this.m_imageHeight;
        this.computeColors(this.m_pix.m_data, this.m_pixIter, numPixels, this.m_imageWidth, this.m_imageHeight, this.m_blockSize.getValue());
        super.computeColors();
    }

    private void computeColors(int[] pixArr, PuComplex[] valArr, int len, int imageWidth, int imageHeight, int blockSize) {
        PdVector vWrapper = new PdVector(2);
        int ind = 0;
        int i = 0;
        while (i < imageHeight) {
            int indPrev = ind;
            int j = 0;
            while (j < imageWidth) {
                PuComplex z = valArr[ind];
                vWrapper.m_data[0] = z.re;
                vWrapper.m_data[1] = z.im;
                int col = this.m_colorScheme.getColor(vWrapper);
                int blockRemainW = Math.min(blockSize, imageWidth - j);
                int k = 0;
                while (k < blockRemainW) {
                    pixArr[ind++] = col;
                    ++k;
                }
                j += blockSize;
            }
            int blockRemainH = Math.min(blockSize, imageHeight - i) - 1;
            int k = 0;
            while (k < blockRemainH) {
                System.arraycopy(pixArr, indPrev, pixArr, ind, imageWidth);
                ind += imageWidth;
                ++k;
            }
            i += blockSize;
        }
    }

    public PuComplexFunction getFunction() {
        return this.m_function;
    }

    public void setFunction(PuComplexFunction function) {
        this.m_function = function;
    }

    public void setSphereMode(boolean mode) {
        this.m_sphereMode = mode;
    }

    public PuColorSchemeIf getColorScheme() {
        return this.m_colorScheme;
    }

    public void setColorScheme(PuColorSchemeIf colorScheme) {
        this.m_colorScheme = colorScheme;
    }

    public int getNumIterations() {
        return this.m_numIterations;
    }

    public void setNumIterations(int numIterations) {
        this.m_numIterations = numIterations;
    }
}

