/*
 * Decompiled with CFR 0.152.
 */
package dev6.vector;

import dev6.vector.PuHMFUtil;
import dev6.vector.PwHMF;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgVectorField;
import jv.loader.PgFileDialog;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsMultiLineLabel;
import jv.objectGui.PsTabPanel;
import jvx.project.PjWorkshop_IP;

public class PwHMF_IP
extends PjWorkshop_IP
implements ItemListener {
    protected PwHMF m_pwHMF;
    private Checkbox m_cModeHMFD;
    private Checkbox m_cModeHMFN;
    private Checkbox m_cModeFD;
    private Checkbox m_cModeFN;
    private Checkbox m_cModeFiveTerm;
    protected Button m_bDecompose;
    private Checkbox m_cBasisDirichlet;
    private Checkbox m_cBasisExactDirichlet;
    private Checkbox m_cBasisBndCoexactDirichlet;
    private Checkbox m_cBasisNeumann;
    private Checkbox m_cBasisCoexactNeumann;
    private Checkbox m_cBasisBndExactNeumann;
    private Button m_bComputeBasis;
    private Button m_bExportMatrix;
    private Button m_bSelect;
    private TextField m_tfFile;
    private String m_exportFile;
    private Button m_bSelectVFData;
    private Button m_bImportVFData;
    private String m_importVFDataFile;
    private TextField m_tfLoadVF;
    private Checkbox m_cImportPCVF;
    private Checkbox m_cImportLagrangeGradient;
    private Checkbox m_cImportCRCogradient;
    private Checkbox m_cNormL1;
    private Checkbox m_cNormL2;
    private TextField m_tfNorm;
    private Button m_bComputeNorm;
    private static final String DESCR_FD = "Exact-0 + Coexact + Dirichlet";
    private static final String DESCR_FN = "Exact + Coexact-0 + Dirichlet";
    private static final String DESCR_HMFD = "Exact-0 + Coexact-0 + Coexact-Harmonic + Dirichlet";
    private static final String DESCR_HMFN = "Exact-0 + Coexact-0 + Exact-Harmonic + Neumann";
    private static final String DESCR_FIVETERM = "Exact-0 + Coexact-0 + Harmonic-Center + Dirichlet + Neumann";
    private static final String DESCR_PW = "Compute Hodge-type vector field decompositions and harmonic bases on triangulated surfaces with boundary.\nThe theory behind these decompositions is explained in [Poelke, Polthier: Boundary-aware Hodge Decompositions for Piecewise Constant Vector Fields, CAD 2016]";

    public PwHMF_IP() {
        this.setTitle("Compute Hodge-Type Decompositions");
        this.m_exportFile = String.valueOf(PsConfig.getUserBase()) + "exportmatrix.txt";
        PsTabPanel tabPanel = new PsTabPanel();
        PsPanel pDecompositions = new PsPanel();
        PsPanel pMode = new PsPanel((LayoutManager)new GridLayout(5, 2));
        CheckboxGroup cbgModes = new CheckboxGroup();
        this.m_cModeFD = new Checkbox("Fundamental-Dirichlet", true, cbgModes);
        this.m_cModeFD.addItemListener(this);
        this.m_cModeFN = new Checkbox("Fundamental-Neumann", false, cbgModes);
        this.m_cModeFN.addItemListener(this);
        this.m_cModeHMFD = new Checkbox("HMF-Dirichlet", false, cbgModes);
        this.m_cModeHMFD.addItemListener(this);
        this.m_cModeHMFN = new Checkbox("HMF-Neumann", false, cbgModes);
        this.m_cModeHMFN.addItemListener(this);
        this.m_cModeFiveTerm = new Checkbox("Five-Term*", false, cbgModes);
        this.m_cModeFiveTerm.addItemListener(this);
        pMode.add((Component)this.m_cModeFD);
        pMode.add((Component)new PsMultiLineLabel(DESCR_FD));
        pMode.add((Component)this.m_cModeFN);
        pMode.add((Component)new PsMultiLineLabel(DESCR_FN));
        pMode.add((Component)this.m_cModeHMFD);
        pMode.add((Component)new PsMultiLineLabel(DESCR_HMFD));
        pMode.add((Component)this.m_cModeHMFN);
        pMode.add((Component)new PsMultiLineLabel(DESCR_HMFN));
        pMode.add((Component)this.m_cModeFiveTerm);
        pMode.add((Component)new PsMultiLineLabel(DESCR_FIVETERM));
        pDecompositions.add((Component)pMode);
        pDecompositions.add((Component)new Label("*Only reasonable for genus = 0"));
        Panel pDecompose = new Panel(new FlowLayout());
        this.m_bDecompose = new Button("Decompose");
        this.m_bDecompose.addActionListener((ActionListener)((Object)this));
        pDecompose.add(this.m_bDecompose);
        pDecompositions.add((Component)pDecompose);
        PsPanel pBases = new PsPanel();
        PsPanel pModeBasis = new PsPanel();
        CheckboxGroup cbgBases = new CheckboxGroup();
        this.m_cBasisDirichlet = new Checkbox("Dirichlet", true, cbgBases);
        this.m_cBasisDirichlet.addItemListener(this);
        this.m_cBasisExactDirichlet = new Checkbox("Exact Dirichlet", false, cbgBases);
        this.m_cBasisExactDirichlet.addItemListener(this);
        this.m_cBasisBndCoexactDirichlet = new Checkbox("Bnd.-Coexact Dirichlet", false, cbgBases);
        this.m_cBasisBndCoexactDirichlet.addItemListener(this);
        this.m_cBasisNeumann = new Checkbox("Neumann", false, cbgBases);
        this.m_cBasisNeumann.addItemListener(this);
        this.m_cBasisCoexactNeumann = new Checkbox("Coexact Neumann", false, cbgBases);
        this.m_cBasisCoexactNeumann.addItemListener(this);
        this.m_cBasisBndExactNeumann = new Checkbox("Bnd.-Exact Neumann", false, cbgBases);
        this.m_cBasisBndExactNeumann.addItemListener(this);
        pModeBasis.add((Component)this.m_cBasisDirichlet);
        pModeBasis.add((Component)this.m_cBasisExactDirichlet);
        pModeBasis.add((Component)this.m_cBasisBndCoexactDirichlet);
        pModeBasis.add((Component)this.m_cBasisNeumann);
        pModeBasis.add((Component)this.m_cBasisCoexactNeumann);
        pModeBasis.add((Component)this.m_cBasisBndExactNeumann);
        pBases.add((Component)pModeBasis);
        PsPanel pExportMatrix = new PsPanel();
        this.m_tfFile = new TextField(this.m_exportFile);
        pExportMatrix.add((Component)this.m_tfFile);
        Panel pSelectExport = new Panel(new GridLayout(1, 2));
        this.m_bSelect = new Button("Select");
        this.m_bSelect.addActionListener((ActionListener)((Object)this));
        pSelectExport.add(this.m_bSelect);
        this.m_bExportMatrix = new Button("Export Matrix");
        this.m_bExportMatrix.addActionListener((ActionListener)((Object)this));
        pSelectExport.add(this.m_bExportMatrix);
        pExportMatrix.add((Component)pSelectExport);
        pBases.add((Component)pExportMatrix);
        this.m_bComputeBasis = new Button("Compute Basis");
        this.m_bComputeBasis.addActionListener((ActionListener)((Object)this));
        this.m_bComputeBasis.setEnabled(false);
        pBases.add((Component)this.m_bComputeBasis);
        PsPanel pIO = new PsPanel();
        Panel pImportAs = new Panel(new GridLayout(4, 1));
        pImportAs.add(new Label("Import as..."));
        CheckboxGroup cbgImportMode = new CheckboxGroup();
        this.m_cImportPCVF = new Checkbox("PCVF", true, cbgImportMode);
        this.m_cImportLagrangeGradient = new Checkbox("Lagrange-Gradient", false, cbgImportMode);
        this.m_cImportCRCogradient = new Checkbox("CR-Cogradient", false, cbgImportMode);
        pImportAs.add(this.m_cImportPCVF);
        pImportAs.add(this.m_cImportLagrangeGradient);
        pImportAs.add(this.m_cImportCRCogradient);
        pIO.add((Component)pImportAs);
        PsPanel pLoad = new PsPanel();
        this.m_tfLoadVF = new TextField("Vector Field Data File");
        pLoad.add((Component)this.m_tfLoadVF);
        Panel pSelectImport = new Panel(new GridLayout(1, 2));
        this.m_bSelectVFData = new Button("Select VF Data");
        this.m_bSelectVFData.addActionListener((ActionListener)((Object)this));
        this.m_bImportVFData = new Button("Import Data");
        this.m_bImportVFData.addActionListener((ActionListener)((Object)this));
        pSelectImport.add(this.m_bSelectVFData);
        pSelectImport.add(this.m_bImportVFData);
        pLoad.add((Component)pSelectImport);
        pIO.add((Component)pLoad);
        PsPanel pInfo = new PsPanel();
        PsPanel psNorm = new PsPanel((LayoutManager)new GridLayout(2, 2));
        CheckboxGroup cbgNorms = new CheckboxGroup();
        this.m_cNormL1 = new Checkbox("L1", false, cbgNorms);
        this.m_cNormL1.addItemListener(this);
        this.m_cNormL2 = new Checkbox("L2", true, cbgNorms);
        this.m_cNormL2.addItemListener(this);
        this.m_tfNorm = new TextField();
        this.m_bComputeNorm = new Button("Compute Norm");
        this.m_bComputeNorm.addActionListener((ActionListener)((Object)this));
        psNorm.add((Component)this.m_cNormL1);
        psNorm.add((Component)this.m_cNormL2);
        psNorm.add((Component)this.m_tfNorm);
        psNorm.add((Component)this.m_bComputeNorm);
        pInfo.add((Component)psNorm);
        tabPanel.addPanel("Decompositions", pDecompositions);
        tabPanel.addPanel("Harmonic Bases", pBases);
        tabPanel.addPanel("I/O", pIO);
        tabPanel.addPanel("Info", pInfo);
        this.add((Component)tabPanel);
        this.validate();
        if (this.getClass() == PwHMF_IP.class) {
            this.init();
        }
    }

    public String getNotice() {
        return DESCR_PW;
    }

    public Dimension getDialogSize() {
        return new Dimension(500, 600);
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_pwHMF = (PwHMF)parent;
    }

    public void actionPerformed(ActionEvent event) {
        if (this.m_pwHMF == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_bDecompose) {
            this.m_pwHMF.decompose();
            this.m_pwHMF.update((Object)this.m_pwHMF);
        } else if (source == this.m_bComputeNorm) {
            PgVectorField vf = this.m_pwHMF.m_geom.getSelectedVectorField();
            double norm = 0.0;
            norm = this.m_cNormL1.getState() ? PuHMFUtil.norm(vf, 1) : (this.m_cNormL2.getState() ? PuHMFUtil.norm(vf, 2) : -1.0);
            this.m_tfNorm.setText(Double.toString(norm));
        } else {
            if (source == this.m_bComputeBasis) {
                PsDebug.warning((String)"Not implemented yet.");
                return;
            }
            if (source == this.m_bSelect) {
                PgFileDialog fd = new PgFileDialog(PsConfig.getFrame(), "Select File", 1);
                fd.show();
                if (!fd.isFileSelected()) {
                    return;
                }
                this.m_exportFile = String.valueOf(fd.getDirectory()) + fd.getFile();
                this.m_tfFile.setText(this.m_exportFile);
            } else if (source == this.m_bExportMatrix) {
                this.m_bExportMatrix.setBackground(Color.red);
                this.m_pwHMF.exportBasisMatrix(this.m_exportFile);
                this.m_bExportMatrix.setBackground(Color.gray);
            } else if (source == this.m_bSelectVFData) {
                PgFileDialog fd = new PgFileDialog(PsConfig.getFrame(), "Select VF Data", 0);
                fd.show();
                if (!fd.isFileSelected()) {
                    return;
                }
                this.m_importVFDataFile = String.valueOf(fd.getDirectory()) + fd.getFile();
                this.m_tfLoadVF.setText(this.m_importVFDataFile);
            } else if (source == this.m_bImportVFData) {
                if (this.m_cImportPCVF.getState()) {
                    this.m_pwHMF.importVFs(this.m_importVFDataFile, 0);
                } else if (this.m_cImportLagrangeGradient.getState()) {
                    this.m_pwHMF.importVFs(this.m_importVFDataFile, 1);
                } else if (this.m_cImportCRCogradient.getState()) {
                    this.m_pwHMF.importVFs(this.m_importVFDataFile, 2);
                }
            } else {
                super.actionPerformed(event);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (this.m_pwHMF == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_cModeFD) {
            this.m_pwHMF.setDecompositionMode(1);
        } else if (source == this.m_cModeFN) {
            this.m_pwHMF.setDecompositionMode(2);
        } else if (source == this.m_cModeHMFD) {
            this.m_pwHMF.setDecompositionMode(3);
        } else if (source == this.m_cModeHMFN) {
            this.m_pwHMF.setDecompositionMode(4);
        } else if (source == this.m_cModeFiveTerm) {
            this.m_pwHMF.setDecompositionMode(5);
        } else if (source == this.m_cBasisDirichlet) {
            this.m_pwHMF.setBasisMode(0);
        } else if (source == this.m_cBasisNeumann) {
            this.m_pwHMF.setBasisMode(1);
        } else if (source == this.m_cBasisExactDirichlet) {
            this.m_pwHMF.setBasisMode(2);
        } else if (source == this.m_cBasisBndCoexactDirichlet) {
            this.m_pwHMF.setBasisMode(3);
        } else if (source == this.m_cBasisCoexactNeumann) {
            this.m_pwHMF.setBasisMode(4);
        } else if (source == this.m_cBasisBndExactNeumann) {
            this.m_pwHMF.setBasisMode(5);
        }
    }
}

