/*
 * Decompiled with CFR 0.152.
 */
package dev6.vector;

import dev6.util.PuJVtoPy;
import dev6.vector.PnHMFBases;
import dev6.vector.PnHMFDecompose;
import dev6.vector.PuHMFUtil;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jvx.numeric.PnSparseMatrix;
import jvx.project.PjWorkshop;

public class PwHMF
extends PjWorkshop {
    public static final int DECOMPOSITION_MODE_FD = 1;
    public static final int DECOMPOSITION_MODE_FN = 2;
    public static final int DECOMPOSITION_MODE_HMFD = 3;
    public static final int DECOMPOSITION_MODE_HMFN = 4;
    public static final int DECOMPOSITION_MODE_FIVETERM = 5;
    public static final int BASIS_DIRICHLET = 0;
    public static final int BASIS_NEUMANN = 1;
    public static final int BASIS_EXACT_DIRICHLET = 2;
    public static final int BASIS_BNDCOEXACT_DIRICHLET = 3;
    public static final int BASIS_COEXACT_NEUMANN = 4;
    public static final int BASIS_BNDEXACT_NEUMANN = 5;
    protected PgElementSet m_geom;
    protected PgVectorField m_vf;
    protected int m_decompositionMode;
    private int m_basisMode;

    public PwHMF() {
        super("Hodge-Type Decompositions");
        if (((Object)((Object)this)).getClass() == PwHMF.class) {
            this.init();
        }
    }

    public void init() {
        this.m_decompositionMode = 1;
        super.init();
    }

    public void setGeometry(PgGeometry geom) {
        if (geom == null || !(geom instanceof PgElementSet)) {
            PsDebug.warning((String)"Geometry is no instance of PgElementSet");
            return;
        }
        PgElementSet domain = (PgElementSet)geom;
        super.setGeometry((PgGeometry)domain);
        if (domain.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry not triangulated. Triangulating.");
            PgElementSet.triangulate((PgElementSet)domain);
        }
        this.m_geom = domain;
        this.m_vf = this.m_geom.getSelectedVectorField();
    }

    public void decompose() {
        this.m_vf = this.m_geom.getSelectedVectorField();
        if (this.m_vf == null) {
            PsDebug.warning((String)"No vector field selected.");
            return;
        }
        PgVectorField[] vfs = null;
        switch (this.m_decompositionMode) {
            case 1: {
                vfs = PnHMFDecompose.decomposeFD(this.m_geom, this.m_vf);
                break;
            }
            case 2: {
                vfs = PnHMFDecompose.decomposeFN(this.m_geom, this.m_vf);
                break;
            }
            case 3: {
                vfs = PnHMFDecompose.decomposeHMFD(this.m_geom, this.m_vf);
                break;
            }
            case 4: {
                vfs = PnHMFDecompose.decomposeHMFN(this.m_geom, this.m_vf);
                break;
            }
            case 5: {
                vfs = PnHMFDecompose.decomposeFiveTerm(this.m_geom, this.m_vf);
                break;
            }
        }
        if (vfs != null) {
            PgVectorField[] pgVectorFieldArray = vfs;
            int n = vfs.length;
            int n2 = 0;
            while (n2 < n) {
                PgVectorField vf = pgVectorFieldArray[n2];
                this.m_geom.addVectorField(vf);
                ++n2;
            }
        }
        this.m_geom.update((Object)this.m_geom);
    }

    public void exportBasisMatrix(String filename) {
        PnSparseMatrix sA;
        switch (this.m_basisMode) {
            case 0: {
                sA = PnHMFBases.assembleDirichletMatrix(this.m_geom);
                break;
            }
            case 1: {
                sA = PnHMFBases.assembleNeumannMatrix(this.m_geom);
                break;
            }
            case 2: {
                sA = PnHMFBases.assembleExactDirichletMatrix(this.m_geom);
                break;
            }
            case 3: {
                PsDebug.warning((String)"Not implemented yet");
                return;
            }
            case 4: {
                sA = PnHMFBases.assembleCoexactNeumannMatrix(this.m_geom);
                break;
            }
            case 5: {
                PsDebug.warning((String)"Not implemented yet");
                return;
            }
            default: {
                PsDebug.warning((String)"Not a valid option for a harmonic basis.");
                return;
            }
        }
        PuJVtoPy.dumpSparseMatrix(sA, filename);
    }

    public void importVFs(String filename, int vfType) {
        PgVectorField[] vfs;
        PdVector[] vfData = PuJVtoPy.loadVectors(filename);
        PgVectorField[] pgVectorFieldArray = vfs = PuHMFUtil.vfFromData(this.m_geom, vfData, vfType);
        int n = vfs.length;
        int n2 = 0;
        while (n2 < n) {
            PgVectorField v = pgVectorFieldArray[n2];
            this.m_geom.addVectorField(v);
            ++n2;
        }
    }

    public void setDecompositionMode(int decompositionMode) {
        this.m_decompositionMode = decompositionMode;
    }

    public void setBasisMode(int basisMode) {
        this.m_basisMode = basisMode;
    }

    public static void decompose(PgElementSet pgElementSet, int decompositionModeFiveterm) {
        PwHMF hd = new PwHMF();
        hd.setGeometry((PgGeometry)pgElementSet);
        hd.setDecompositionMode(decompositionModeFiveterm);
        hd.decompose();
    }
}

