/*
 * Decompiled with CFR 0.152.
 */
package dev6.vector;

import java.util.LinkedList;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnSparseMatrix;
import jvx.vector.PwVectorField;

public class PuHMFUtil {
    public static final int NORM_L1 = 1;
    public static final int NORM_L2 = 2;
    public static final int VF_TYPE_PCVF = 0;
    public static final int VF_TYPE_LAGRANGE_GRAD = 1;
    public static final int VF_TYPE_CR_COGRAD = 2;

    public static double norm(PgVectorField vf, int whichNorm) {
        if (whichNorm != 1 && whichNorm != 2) {
            PsDebug.warning((String)"Not a valid norm.");
            return -1.0;
        }
        PgElementSet geom = (PgElementSet)vf.getGeometry();
        if (vf.getBasedOn() != 1) {
            PsDebug.warning((String)"Vector field is not element based.");
            return -1.0;
        }
        int noe = geom.getNumElements();
        double norm = 0.0;
        PdVector[] vectors = vf.getVectors();
        int i = 0;
        while (i < noe) {
            double area = geom.getAreaOfElement(i);
            double len = vectors[i].length();
            switch (whichNorm) {
                case 1: {
                    norm += area * len;
                    break;
                }
                case 2: {
                    norm += area * len * len;
                    break;
                }
            }
            ++i;
        }
        switch (whichNorm) {
            case 1: {
                return norm;
            }
            case 2: {
                return Math.sqrt(norm);
            }
        }
        return -1.0;
    }

    public static PgVectorField[] vfFromData(PgElementSet geom, PdVector[] vfCoeffs, int vfType) {
        LinkedList<PgVectorField> vfs = new LinkedList<PgVectorField>();
        PdVector[] pdVectorArray = vfCoeffs;
        int n = vfCoeffs.length;
        int n2 = 0;
        while (n2 < n) {
            PdVector v = pdVectorArray[n2];
            PgVectorField vf = null;
            switch (vfType) {
                case 0: {
                    vf = PuHMFUtil.coeffsToPCVF(geom, v);
                    break;
                }
                case 1: {
                    vf = PuHMFUtil.coeffsToLagrangeGradient(geom, v);
                    break;
                }
                case 2: {
                    vf = PuHMFUtil.coeffsToCRCograd(geom, v);
                    break;
                }
            }
            vfs.add(vf);
            ++n2;
        }
        PgVectorField[] vfArray = new PgVectorField[vfs.size()];
        return vfs.toArray(vfArray);
    }

    public static PgVectorField coeffsToGradientField(PgElementSet geom, PdVector coeffs, boolean conforming, boolean cogradient) {
        if (geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Surface is not triangulated.");
            return null;
        }
        if (geom.getElementEdges() == null) {
            geom.setEnabledEdges(true);
            geom.makeEdgeStars();
        }
        PgVectorField vf = new PgVectorField(3, 1);
        vf.setGeometry((PgPointSet)geom);
        vf.setNumVectors(geom.getNumElements());
        PdVector[] vertices = geom.getVertices();
        int noe = geom.getNumElements();
        PdVector vectorOnElement = new PdVector(3);
        PdVector basisVectorOnElement = new PdVector(3);
        int f = 0;
        while (f < noe) {
            vectorOnElement.setConstant(0.0);
            PiVector elementEdgeIndices = geom.getElementEdges()[f];
            double area = geom.getAreaOfElement(f);
            double weight = conforming ? 0.5 / area : 1.0 / area;
            PiVector element = geom.getElement(f);
            int k = 0;
            while (k < 3) {
                int i = conforming ? element.m_data[k] : elementEdgeIndices.m_data[k];
                basisVectorOnElement.sub(vertices[element.m_data[(k + 2) % 3]], vertices[element.m_data[(k + 1) % 3]]);
                basisVectorOnElement.cross(geom.getElementNormal(f), basisVectorOnElement);
                if (!conforming) {
                    basisVectorOnElement.multScalar(-1.0);
                }
                basisVectorOnElement.multScalar(weight);
                basisVectorOnElement.multScalar(coeffs.getEntry(i));
                vectorOnElement.add(basisVectorOnElement);
                ++k;
            }
            vf.setVector(f, vectorOnElement);
            ++f;
        }
        if (cogradient) {
            PwVectorField.rotateVectorField((PgVectorField)vf);
        }
        return vf;
    }

    public static PgVectorField coeffsToPCVF(PgElementSet geom, PdVector coeffs) {
        PgVectorField vf = new PgVectorField(3, 1);
        vf.setGeometry((PgPointSet)geom);
        int numElements = geom.getNumElements();
        int e = 0;
        while (e < numElements) {
            PdVector v = new PdVector(coeffs.m_data[3 * e], coeffs.m_data[3 * e + 1], coeffs.m_data[3 * e + 2]);
            vf.setVector(e, v);
            ++e;
        }
        return vf;
    }

    public static PgVectorField coeffsToLagrangeGradient(PgElementSet geom, PdVector coeffs) {
        return PuHMFUtil.coeffsToGradientField(geom, coeffs, true, false);
    }

    public static PgVectorField coeffsToCRCograd(PgElementSet geom, PdVector coeffs) {
        return PuHMFUtil.coeffsToGradientField(geom, coeffs, false, true);
    }

    public static PiVector getBndVertexIndices(PgElementSet geom) {
        PgEdgeStar[] edgeStars = geom.makeEdgeStars();
        int noe = geom.getNumEdges();
        PiVector bndVertexIndices = new PiVector();
        int e = 0;
        while (e < noe) {
            int val = edgeStars[e].getValence();
            if (val == 1) {
                int v1 = edgeStars[e].getFirstEntry();
                int v2 = edgeStars[e].getLastEntry();
                bndVertexIndices.addEntry(v1);
                bndVertexIndices.addEntry(v2);
            }
            ++e;
        }
        bndVertexIndices.sort();
        bndVertexIndices.removeSuccessiveDuplicates();
        return bndVertexIndices;
    }

    public static PiVector getBndEdgeIndices(PgElementSet geom) {
        PgEdgeStar[] edgeStars = geom.makeEdgeStars();
        int noe = geom.getNumEdges();
        PiVector bndEdgeIndices = new PiVector();
        int e = 0;
        while (e < noe) {
            int val = edgeStars[e].getValence();
            if (val == 1) {
                bndEdgeIndices.addEntry(e);
            }
            ++e;
        }
        return bndEdgeIndices;
    }

    public static PnSparseMatrix assembleMixedStiffnessMatrix(PgElementSet geom, FemType femType1, OperatorType opType1, FemType femType2, OperatorType opType2) {
        geom.setEnabledEdges(true);
        geom.makeEdgeStars();
        geom.makeElementNormals();
        int numVertices = geom.getNumVertices();
        int numEdges = geom.getNumEdges();
        int numElements = geom.getNumElements();
        int[] dims = new int[2];
        FemType[] femTypes = new FemType[]{femType1, femType2};
        int k = 0;
        while (k < 2) {
            switch (femTypes[k]) {
                case LAGRANGE: {
                    dims[k] = numVertices;
                    break;
                }
                case CROUZEIX_RAVIART: {
                    dims[k] = numEdges;
                    break;
                }
                default: {
                    PsDebug.warning((String)"Not a valid FEM type.");
                    return null;
                }
            }
            ++k;
        }
        PnSparseMatrix stiff = new PnSparseMatrix(dims[0], dims[1], 5);
        PdVector[] vertices = geom.getVertices();
        PdVector[] edges = new PdVector[]{new PdVector(3), new PdVector(3), new PdVector(3)};
        PdVector leftVec = new PdVector(3);
        PdVector rightVec = new PdVector(3);
        int i = -1;
        int j = -1;
        int f = 0;
        while (f < numElements) {
            PiVector element = geom.getElement(f);
            double elementArea = geom.getAreaOfElement(f);
            PiVector elementEdgeIndices = geom.getElementEdges()[f];
            edges[0].sub(vertices[element.m_data[2]], vertices[element.m_data[1]]);
            edges[1].sub(vertices[element.m_data[0]], vertices[element.m_data[2]]);
            edges[2].sub(vertices[element.m_data[1]], vertices[element.m_data[0]]);
            int locI = 0;
            while (locI < 3) {
                switch (femType1) {
                    case LAGRANGE: {
                        i = element.m_data[locI];
                        switch (opType1) {
                            case GRADIENT: {
                                leftVec.cross(geom.getElementNormal(f), edges[locI]);
                                break;
                            }
                            case COGRADIENT: {
                                leftVec.set(edges[locI], 0, 3);
                                leftVec.multScalar(-1.0);
                            }
                        }
                        leftVec.multScalar(1.0 / (2.0 * elementArea));
                        break;
                    }
                    case CROUZEIX_RAVIART: {
                        i = elementEdgeIndices.m_data[locI];
                        switch (opType1) {
                            case GRADIENT: {
                                leftVec.cross(geom.getElementNormal(f), edges[locI]);
                                leftVec.multScalar(-1.0);
                                break;
                            }
                            case COGRADIENT: {
                                leftVec.set(edges[locI], 0, 3);
                            }
                        }
                        leftVec.multScalar(1.0 / elementArea);
                    }
                }
                int locJ = 0;
                while (locJ < 3) {
                    switch (femType2) {
                        case LAGRANGE: {
                            j = element.m_data[locJ];
                            switch (opType2) {
                                case GRADIENT: {
                                    rightVec.cross(geom.getElementNormal(f), edges[locJ]);
                                    break;
                                }
                                case COGRADIENT: {
                                    rightVec.set(edges[locJ], 0, 3);
                                    rightVec.multScalar(-1.0);
                                }
                            }
                            rightVec.multScalar(1.0 / (2.0 * elementArea));
                            break;
                        }
                        case CROUZEIX_RAVIART: {
                            j = elementEdgeIndices.m_data[locJ];
                            switch (opType2) {
                                case GRADIENT: {
                                    rightVec.cross(geom.getElementNormal(f), edges[locJ]);
                                    rightVec.multScalar(-1.0);
                                    break;
                                }
                                case COGRADIENT: {
                                    rightVec.set(edges[locJ], 0, 3);
                                }
                            }
                            rightVec.multScalar(1.0 / elementArea);
                        }
                    }
                    double aij = elementArea * leftVec.dot(rightVec);
                    stiff.appendEntry(i, j, aij);
                    ++locJ;
                }
                ++locI;
            }
            ++f;
        }
        stiff.validate();
        return stiff;
    }

    public static void applyDirichletBC(PnSparseMatrix A, PdVector b, PgElementSet geom) {
        PiVector bndIndices;
        int numRows;
        int numCols = A.getNumCols();
        if (numCols != (numRows = A.getNumRows())) {
            PsDebug.warning((String)"Not a square matrix.");
            return;
        }
        int nov = geom.getNumVertices();
        int noe = geom.getNumEdges();
        if (nov == numCols) {
            bndIndices = PuHMFUtil.getBndVertexIndices(geom);
        } else if (noe == numCols) {
            bndIndices = PuHMFUtil.getBndEdgeIndices(geom);
        } else {
            PsDebug.warning((String)"Cannot apply Dirichlet boundary condition.\nMatrix uses neither Lagrange nodal basis nor Crouzeix-Raviart edge basis.");
            return;
        }
        int nobIdxs = bndIndices.getSize();
        int i = 0;
        while (i < nobIdxs) {
            int bIdx = bndIndices.getEntry(i);
            A.clearRow(bIdx);
            A.clearColumn(bIdx);
            A.setEntry(bIdx, bIdx, 1.0);
            b.setEntry(bIdx, 0.0);
            ++i;
        }
        A.validate();
    }

    public static PnSparseMatrix assembleStiffnessMatrix(PgElementSet geom, boolean conforming) {
        if (!conforming) {
            geom.setEnabledEdges(true);
            geom.makeEdgeStars();
        }
        int numVariables = conforming ? geom.getNumVertices() : geom.getNumEdges();
        int noe = geom.getNumElements();
        PnSparseMatrix stiff = new PnSparseMatrix(numVariables, numVariables, 5);
        PdVector[] vertices = geom.getVertices();
        PdVector[] edges = new PdVector[]{new PdVector(3), new PdVector(3), new PdVector(3)};
        int f = 0;
        while (f < noe) {
            PiVector element = geom.getElement(f);
            double areaWeight = 0.25 / geom.getAreaOfElement(f);
            PiVector elementEdgeIndices = conforming ? null : geom.getElementEdges()[f];
            edges[0].sub(vertices[element.m_data[2]], vertices[element.m_data[1]]);
            edges[1].sub(vertices[element.m_data[0]], vertices[element.m_data[2]]);
            edges[2].sub(vertices[element.m_data[1]], vertices[element.m_data[0]]);
            int locI = 0;
            while (locI < 3) {
                int i = conforming ? element.m_data[locI] : elementEdgeIndices.m_data[locI];
                int locJ = 0;
                while (locJ < 3) {
                    int j = conforming ? element.m_data[locJ] : elementEdgeIndices.m_data[locJ];
                    double aij = areaWeight * edges[locI].dot(edges[locJ]);
                    stiff.appendEntry(i, j, aij);
                    ++locJ;
                }
                ++locI;
            }
            ++f;
        }
        stiff.validate();
        if (!conforming) {
            stiff.multScalar(4.0);
        }
        return stiff;
    }

    public static PdVector assembleRHS(PgElementSet geom, PgVectorField vf, boolean conforming, boolean cogradient) {
        if (!conforming) {
            geom.setEnabledEdges(true);
            geom.makeEdgeStars();
            geom.makeElementNormals();
        }
        int numVariables = conforming ? geom.getNumVertices() : geom.getNumEdges();
        int noe = geom.getNumElements();
        PdVector[] vertices = geom.getVertices();
        PiVector[] elementEdgeIndices = geom.getElementEdges();
        PdVector rhs = new PdVector(numVariables);
        PdVector edge = new PdVector(3);
        int f = 0;
        while (f < noe) {
            PiVector element = geom.getElement(f);
            int k = 0;
            while (k < 3) {
                int i;
                edge.sub(vertices[element.m_data[(k + 2) % 3]], vertices[element.m_data[(k + 1) % 3]]);
                if (conforming) {
                    i = element.m_data[k];
                    if (!cogradient) {
                        edge.cross(geom.getElementNormal(f), edge);
                    } else {
                        edge.multScalar(-1.0);
                    }
                } else {
                    i = elementEdgeIndices[f].m_data[k];
                    if (!cogradient) {
                        edge.cross(geom.getElementNormal(f), edge);
                        edge.multScalar(-1.0);
                    }
                }
                int n = i;
                rhs.m_data[n] = rhs.m_data[n] + edge.dot(vf.getVector(f));
                ++k;
            }
            ++f;
        }
        if (conforming) {
            rhs.multScalar(0.5);
        }
        return rhs;
    }

    public static PdVector[] sNullspace(PnSparseMatrix sA, int basisSize) {
        PsDebug.warning((String)"Not implemented yet.");
        return null;
    }

    public static enum FemType {
        LAGRANGE,
        CROUZEIX_RAVIART;

    }

    public static enum OperatorType {
        GRADIENT,
        COGRADIENT;

    }
}

