/*
 * Decompiled with CFR 0.152.
 */
package dev6.vector;

import dev6.vector.PuHMFUtil;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jvx.numeric.PnConjugateGradientMatrix;
import jvx.numeric.PnSparseMatrix;

public class PnHMFDecompose {
    public static PdVector projectOntoGradient(PgElementSet geom, PgVectorField vf, boolean conforming, boolean cogradient, boolean bndZero) {
        if (vf.getBasedOn() != 1) {
            PsDebug.warning((String)"Vector field is not element-based.");
            return null;
        }
        PnSparseMatrix A = PuHMFUtil.assembleStiffnessMatrix(geom, conforming);
        PdVector b = PuHMFUtil.assembleRHS(geom, vf, conforming, cogradient);
        PdVector x = new PdVector(b.getSize());
        if (bndZero) {
            PsDebug.notify((String)"Applying Dirichlet Boundary Condition");
            PuHMFUtil.applyDirichletBC(A, b, geom);
        }
        PsDebug.notify((String)"Solving system Ax=b..");
        double residual = new PnConjugateGradientMatrix().solve(A, x, b);
        System.out.println(residual);
        PsDebug.notify((String)"..done.");
        return x;
    }

    public static PgVectorField[] decomposeHMFD(PgElementSet geom, PgVectorField vf) {
        PgVectorField[] componentsFD = PnHMFDecompose.decomposeFD(geom, vf);
        PgVectorField vfCoexact = componentsFD[1];
        PdVector coexactBndConstrainedCoeffs = PnHMFDecompose.projectOntoGradient(geom, vfCoexact, false, true, true);
        PgVectorField vfCoexactBndConstrained = PuHMFUtil.coeffsToGradientField(geom, coexactBndConstrainedCoeffs, false, true);
        vfCoexactBndConstrained.setName(String.valueOf(vf.getName()) + "_Coexact-with-Bnd-Constraints");
        PgVectorField vfCoexactHarmonic = vfCoexact;
        vfCoexactHarmonic.sub(vfCoexactBndConstrained);
        vfCoexactHarmonic.setName(String.valueOf(vf.getName()) + "_Coexact-Harmonic");
        PgVectorField[] components = new PgVectorField[]{componentsFD[0], vfCoexactBndConstrained, vfCoexactHarmonic, componentsFD[2]};
        return components;
    }

    public static PgVectorField[] decomposeHMFN(PgElementSet geom, PgVectorField vf) {
        PgVectorField[] componentsFN = PnHMFDecompose.decomposeFN(geom, vf);
        PgVectorField vfExact = componentsFN[0];
        PdVector exactBndConstrainedCoeffs = PnHMFDecompose.projectOntoGradient(geom, vfExact, true, false, true);
        PgVectorField vfExactBndConstrained = PuHMFUtil.coeffsToGradientField(geom, exactBndConstrainedCoeffs, true, false);
        vfExactBndConstrained.setName(String.valueOf(vf.getName()) + "_Exact-with-Bnd-Constraints");
        PgVectorField vfExactHarmonic = vfExact;
        vfExactHarmonic.sub(vfExactBndConstrained);
        vfExactHarmonic.setName(String.valueOf(vf.getName()) + "_Exact-Harmonic");
        PgVectorField[] components = new PgVectorField[]{vfExactBndConstrained, componentsFN[1], vfExactHarmonic, componentsFN[2]};
        return components;
    }

    public static PgVectorField[] decomposeHMFDdTGS(PgElementSet geom, PgVectorField vf) {
        PsDebug.warning((String)"Not implemented yet.");
        return null;
    }

    public static PgVectorField[] decomposeHMFNdTGS(PgElementSet geom, PgVectorField vf) {
        PsDebug.warning((String)"Not implemented yet.");
        return null;
    }

    public static PgVectorField[] decomposeFD(PgElementSet geom, PgVectorField vf) {
        if (vf.getBasedOn() != 1) {
            PsDebug.warning((String)"Vector field is not element-based.");
            return null;
        }
        PgVectorField vfc = (PgVectorField)vf.clone();
        vfc.setGeometry((PgPointSet)geom);
        PdVector exactBndConstrainedCoeffs = PnHMFDecompose.projectOntoGradient(geom, vfc, true, false, true);
        PgVectorField vfExactBndConstrained = PuHMFUtil.coeffsToGradientField(geom, exactBndConstrainedCoeffs, true, false);
        vfExactBndConstrained.setName(String.valueOf(vf.getName()) + "_Exact-with-Bnd-Constraints");
        vfc.sub(vfExactBndConstrained);
        PdVector coexactCoeffs = PnHMFDecompose.projectOntoGradient(geom, vfc, false, true, false);
        PgVectorField vfCoexact = PuHMFUtil.coeffsToGradientField(geom, coexactCoeffs, false, true);
        vfCoexact.setName(String.valueOf(vf.getName()) + "_Coexact");
        vfc.sub(vfCoexact);
        vfc.setName(String.valueOf(vf.getName()) + "_Harmonic-Dirichlet");
        PgVectorField vfHarmonicDirichlet = vfc;
        PgVectorField[] components = new PgVectorField[]{vfExactBndConstrained, vfCoexact, vfHarmonicDirichlet};
        return components;
    }

    public static PgVectorField[] decomposeFN(PgElementSet geom, PgVectorField vf) {
        if (vf.getBasedOn() != 1) {
            PsDebug.warning((String)"Vector field is not element-based.");
            return null;
        }
        PgVectorField vfc = (PgVectorField)vf.clone();
        vfc.setGeometry((PgPointSet)geom);
        PdVector exactCoeffs = PnHMFDecompose.projectOntoGradient(geom, vfc, true, false, false);
        PgVectorField vfExact = PuHMFUtil.coeffsToGradientField(geom, exactCoeffs, true, false);
        vfExact.setName(String.valueOf(vf.getName()) + "_Exact");
        vfc.sub(vfExact);
        PdVector coexactBndConstrainedCoeffs = PnHMFDecompose.projectOntoGradient(geom, vfc, false, true, true);
        PgVectorField vfCoexactBndConstrained = PuHMFUtil.coeffsToGradientField(geom, coexactBndConstrainedCoeffs, false, true);
        vfCoexactBndConstrained.setName(String.valueOf(vf.getName()) + "_Coexact-with-Bnd-Constraints");
        vfc.sub(vfCoexactBndConstrained);
        vfc.setName(String.valueOf(vf.getName()) + "_Harmonic-Neumann");
        PgVectorField vfHarmonicNeumann = vfc;
        PgVectorField[] components = new PgVectorField[]{vfExact, vfCoexactBndConstrained, vfHarmonicNeumann};
        return components;
    }

    public static PgVectorField[] decomposeFiveTerm(PgElementSet geom, PgVectorField vf) {
        PgVectorField[] componentsHMFD = PnHMFDecompose.decomposeHMFD(geom, vf);
        PgVectorField vfCoexactHarmonic = componentsHMFD[2];
        PdVector harmonicCenterCoeffs = PnHMFDecompose.projectOntoGradient(geom, vfCoexactHarmonic, true, false, false);
        PgVectorField vfHarmonicCenter = PuHMFUtil.coeffsToGradientField(geom, harmonicCenterCoeffs, true, false);
        vfHarmonicCenter.setName(String.valueOf(vf.getName()) + "_Harmonic-Center");
        PgVectorField vfHarmonicNeumann = vfCoexactHarmonic;
        vfHarmonicNeumann.sub(vfHarmonicCenter);
        vfHarmonicNeumann.setName(String.valueOf(vf.getName()) + "_Harmonic-Neumann");
        PgVectorField[] components = new PgVectorField[]{componentsHMFD[0], componentsHMFD[1], vfHarmonicCenter, vfHarmonicNeumann, componentsHMFD[3]};
        return components;
    }
}

