/*
 * Decompiled with CFR 0.152.
 */
package dev6.vector;

import dev6.vector.PuHMFUtil;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnSparseMatrix;

public class PnHMFBases {
    public static final int EXACT_DIRICHLET = 0;
    public static final int COEXACT_NEUMANN = 1;

    public static PnSparseMatrix assembleHarmonicBasisMatrix(PgElementSet geom, boolean potBndZero, boolean copotBndZero) {
        geom.setEnabledEdges(true);
        geom.makeEdgeStars();
        geom.makeElementNormals();
        int numVertices = geom.getNumVertices();
        int numElements = geom.getNumElements();
        int numEdges = geom.getNumEdges();
        int dimR = 3 * numElements;
        PnSparseMatrix mGrad = new PnSparseMatrix(numVertices, dimR);
        PnSparseMatrix mCograd = new PnSparseMatrix(numEdges, dimR);
        PnSparseMatrix mNormal = new PnSparseMatrix(numElements, dimR);
        PdVector[] vertices = geom.getVertices();
        PdVector[] edges = new PdVector[]{new PdVector(3), new PdVector(3), new PdVector(3)};
        PdVector grad = new PdVector(3);
        PsDebug.notify((String)"Assembling matrix...");
        int f = 0;
        while (f < numElements) {
            PiVector element = geom.getElement(f);
            PiVector elementEdgeIndices = geom.getElementEdges()[f];
            edges[0].sub(vertices[element.m_data[2]], vertices[element.m_data[1]]);
            edges[1].sub(vertices[element.m_data[0]], vertices[element.m_data[2]]);
            edges[2].sub(vertices[element.m_data[1]], vertices[element.m_data[0]]);
            int locIdx = 0;
            while (locIdx < 3) {
                int iMGrad = element.m_data[locIdx];
                int iMCograd = elementEdgeIndices.m_data[locIdx];
                grad.cross(geom.getElementNormal(f), edges[locIdx]);
                PdVector cograd = edges[locIdx];
                int k = 0;
                while (k < 3) {
                    int j = 3 * f + k;
                    mGrad.appendEntry(iMGrad, j, grad.m_data[k]);
                    mCograd.appendEntry(iMCograd, j, cograd.m_data[k]);
                    ++k;
                }
                ++locIdx;
            }
            PdVector normal = geom.getElementNormal(f);
            mNormal.appendEntry(f, 3 * f, normal.m_data[0]);
            mNormal.appendEntry(f, 3 * f + 1, normal.m_data[1]);
            mNormal.appendEntry(f, 3 * f + 2, normal.m_data[2]);
            ++f;
        }
        mGrad.multScalar(0.5);
        mGrad.validate();
        mCograd.validate();
        mNormal.validate();
        if (potBndZero) {
            PiVector bndVertexIndices = PuHMFUtil.getBndVertexIndices(geom);
            bndVertexIndices.invert();
            int numBndVertices = bndVertexIndices.getSize();
            int i = 0;
            while (i < numBndVertices) {
                mGrad.deleteRow(bndVertexIndices.getEntry(i));
                ++i;
            }
        } else {
            mGrad.deleteRow(0);
        }
        if (copotBndZero) {
            PiVector bndEdgeIndices = PuHMFUtil.getBndEdgeIndices(geom);
            bndEdgeIndices.invert();
            int numBndEdges = bndEdgeIndices.getSize();
            int i = 0;
            while (i < numBndEdges) {
                mCograd.deleteRow(bndEdgeIndices.getEntry(i));
                ++i;
            }
        } else {
            mCograd.deleteRow(0);
        }
        PnSparseMatrix sA = PnSparseMatrix.vstackSparseMatrices((PnSparseMatrix[])new PnSparseMatrix[]{mGrad, mCograd, mNormal});
        return sA;
    }

    private static PnSparseMatrix assembleExactHarmonicBasisMatrix(PgElementSet geom, int which) {
        PnSparseMatrix mixedStiffnessMatrix;
        if (which != 0 && which != 1) {
            PsDebug.warning((String)"Not a valid specifier.");
            return null;
        }
        geom.setEnabledEdges(true);
        geom.makeEdgeStars();
        geom.makeElementNormals();
        int numVertices = geom.getNumVertices();
        int numEdges = geom.getNumEdges();
        PnSparseMatrix mGrad = null;
        PnSparseMatrix mCograd = null;
        PnSparseMatrix excludeKernel = null;
        PiVector bndVertexIndices = PuHMFUtil.getBndVertexIndices(geom);
        PiVector bndEdgeIndices = PuHMFUtil.getBndEdgeIndices(geom);
        int numBndVertices = bndVertexIndices.getSize();
        int numBndEdges = bndEdgeIndices.getSize();
        if (which == 0) {
            mGrad = PuHMFUtil.assembleStiffnessMatrix(geom, true);
            bndVertexIndices.invert();
            int k = 0;
            while (k < numBndVertices) {
                mGrad.deleteRow(bndVertexIndices.getEntry(k));
                ++k;
            }
            mixedStiffnessMatrix = PuHMFUtil.assembleMixedStiffnessMatrix(geom, PuHMFUtil.FemType.CROUZEIX_RAVIART, PuHMFUtil.OperatorType.COGRADIENT, PuHMFUtil.FemType.LAGRANGE, PuHMFUtil.OperatorType.GRADIENT);
            mCograd = PnSparseMatrix.extractRows((PnSparseMatrix)mixedStiffnessMatrix, (PiVector)bndEdgeIndices);
            excludeKernel = new PnSparseMatrix(1, numVertices);
            excludeKernel.setEntry(0, 0, 1.0);
        } else if (which == 1) {
            mCograd = PuHMFUtil.assembleStiffnessMatrix(geom, false);
            bndEdgeIndices.invert();
            int k = 0;
            while (k < numBndEdges) {
                mCograd.deleteRow(bndEdgeIndices.getEntry(k));
                ++k;
            }
            mixedStiffnessMatrix = PuHMFUtil.assembleMixedStiffnessMatrix(geom, PuHMFUtil.FemType.LAGRANGE, PuHMFUtil.OperatorType.GRADIENT, PuHMFUtil.FemType.CROUZEIX_RAVIART, PuHMFUtil.OperatorType.COGRADIENT);
            mGrad = PnSparseMatrix.extractRows((PnSparseMatrix)mixedStiffnessMatrix, (PiVector)bndVertexIndices);
            excludeKernel = new PnSparseMatrix(1, numEdges);
            excludeKernel.setEntry(0, 0, 1.0);
        }
        mGrad.validate();
        mCograd.validate();
        excludeKernel.validate();
        PnSparseMatrix sA = PnSparseMatrix.vstackSparseMatrices((PnSparseMatrix[])new PnSparseMatrix[]{mGrad, mCograd, excludeKernel});
        return sA;
    }

    public static PnSparseMatrix assembleDirichletMatrix(PgElementSet geom) {
        return PnHMFBases.assembleHarmonicBasisMatrix(geom, true, false);
    }

    public static PnSparseMatrix assembleNeumannMatrix(PgElementSet geom) {
        return PnHMFBases.assembleHarmonicBasisMatrix(geom, false, true);
    }

    public static PnSparseMatrix assembleExactDirichletMatrix(PgElementSet geom) {
        return PnHMFBases.assembleExactHarmonicBasisMatrix(geom, 0);
    }

    public static PnSparseMatrix assembleCoexactNeumannMatrix(PgElementSet geom) {
        return PnHMFBases.assembleExactHarmonicBasisMatrix(geom, 1);
    }
}

