/*
 * Decompiled with CFR 0.152.
 */
package dev6.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Locale;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnSparseMatrix;

public class PuJVtoPy {
    public static Locale LOCALE = Locale.ENGLISH;
    public static String FORMAT = "%.2f";
    private static String SPACE = " ";

    public static boolean dumpMatrix(double[][] array, String filename) {
        assert (array != null);
        double[] a1 = array[0];
        int numRows = array.length;
        assert (a1 != null);
        int numCols = a1.length;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int i = 0;
            while (i < numRows) {
                if (array[i].length != numCols) {
                    out.close();
                    throw new ArrayIndexOutOfBoundsException("Row " + i + " does not have " + numCols + " entries.");
                }
                int j = 0;
                while (j < numCols - 1) {
                    String aij = String.format(LOCALE, FORMAT, array[i][j]);
                    out.write(String.valueOf(aij) + " ");
                    ++j;
                }
                String aij = String.format(Locale.ENGLISH, FORMAT, array[i][numCols - 1]);
                out.write(aij);
                out.newLine();
                ++i;
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.println("Could not create file " + filename);
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Row sizes not equal");
            return false;
        }
        return true;
    }

    public static boolean dumpMatrix(PnSparseMatrix sm, String filename) {
        PdMatrix m = sm.toPdMatrix();
        return PuJVtoPy.dumpMatrix(m, filename);
    }

    public static boolean dumpMatrix(PdMatrix m, String filename) {
        return PuJVtoPy.dumpMatrix(m.m_data, filename);
    }

    public static boolean dumpVectorField(PgVectorField v) {
        String name = String.valueOf(v.getName()) + ".txt";
        return PuJVtoPy.dumpVectorField(v, name);
    }

    public static boolean dumpVectorField(PgVectorField v, String filename) {
        int dimOfVectors = v.getDimOfVectors();
        int length = v.getNumVectors();
        PdVector[] vectors = v.getVectors();
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int n = 0;
            while (n < length) {
                int i = 0;
                while (i < dimOfVectors) {
                    String vi = String.format(Locale.ENGLISH, FORMAT, vectors[n].getEntry(i));
                    out.write(String.valueOf(vi) + " ");
                    ++i;
                }
                ++n;
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.println("Could not create file " + filename);
            return false;
        }
        return true;
    }

    public static boolean dumpVector(PdVector v, String filename) {
        if (v == null) {
            PsDebug.warning((String)"Vector is null");
            return false;
        }
        int length = v.getSize();
        if (length == 0) {
            PsDebug.warning((String)"Vector has no entries.");
            return false;
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int n = 0;
            while (n < length) {
                String vi = String.format(Locale.ENGLISH, FORMAT, v.getEntry(n));
                out.write(String.valueOf(vi) + " ");
                ++n;
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.println("Could not create file " + filename);
            return false;
        }
        return true;
    }

    public static PdVector loadTxtVector(String filename) {
        PdVector v = null;
        String line = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(filename));
            line = br.readLine();
            if (line != null) {
                String[] theline = line.split(" ");
                int length = theline.length;
                v = new PdVector(length);
                int i = 0;
                while (i < length) {
                    v.setEntry(i, Double.parseDouble(theline[i]));
                    ++i;
                }
            }
            br.close();
        }
        catch (FileNotFoundException fN) {
            PsDebug.warning((String)("Could not find file " + filename));
            return v;
        }
        catch (IOException e) {
            PsDebug.warning((String)"IO problem during file read");
            e.printStackTrace();
        }
        return v;
    }

    public static boolean dumpVectors(PdVector[] vectors, String filename) {
        if (vectors == null) {
            PsDebug.warning((String)"Vector array is null");
            return false;
        }
        int length = vectors.length;
        if (length == 0) {
            PsDebug.warning((String)"Array has no entries.");
            return false;
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            PdVector[] pdVectorArray = vectors;
            int n = vectors.length;
            int n2 = 0;
            while (n2 < n) {
                PdVector v = pdVectorArray[n2];
                int n3 = 0;
                while (n3 < v.getSize()) {
                    String vi = String.format(Locale.ENGLISH, FORMAT, v.getEntry(n3));
                    out.write(String.valueOf(vi) + " ");
                    ++n3;
                }
                out.write("\n");
                ++n2;
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.println("Could not create file " + filename);
            return false;
        }
        return true;
    }

    public static PdVector[] loadVectors(String filename) {
        LinkedList<PdVector> vectors = new LinkedList<PdVector>();
        String line = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(filename));
            while ((line = br.readLine()) != null) {
                String[] theline = line.split(" ");
                int length = theline.length;
                PdVector v = new PdVector(length);
                int i = 0;
                while (i < length) {
                    v.setEntry(i, Double.parseDouble(theline[i]));
                    ++i;
                }
                vectors.add(v);
            }
            br.close();
        }
        catch (FileNotFoundException fN) {
            PsDebug.warning((String)("Could not find file " + filename));
            return null;
        }
        catch (IOException e) {
            PsDebug.warning((String)"IO problem during file read");
            e.printStackTrace();
            return null;
        }
        PdVector[] vectorsArray = new PdVector[vectors.size()];
        vectorsArray = vectors.toArray(vectorsArray);
        return vectorsArray;
    }

    public static boolean dumpSparseMatrix(PnSparseMatrix sA, String filename) {
        if (sA == null) {
            PsDebug.warning((String)"Matrix is null.");
            return false;
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int numCols = sA.getNumCols();
            int numRows = sA.getNumRows();
            int nnz = sA.getNumEntries().sum();
            PiVector[] colIndices = sA.getColIndices();
            PdVector[] values = sA.getEntries();
            String sMatrixInfo = "";
            StringBuilder rowIndicesBuilder = new StringBuilder();
            StringBuilder colIndicesBuilder = new StringBuilder();
            StringBuilder valuesBuilder = new StringBuilder();
            int i = 0;
            while (i < numRows) {
                PiVector ci = colIndices[i];
                if (ci != null) {
                    PdVector vi = values[i];
                    int numEntries = ci.getSize();
                    int j = 0;
                    while (j < numEntries) {
                        rowIndicesBuilder.append(i).append(" ");
                        colIndicesBuilder.append(ci.getEntry(j)).append(" ");
                        valuesBuilder.append(vi.getEntry(j)).append(" ");
                        ++j;
                    }
                }
                ++i;
            }
            sMatrixInfo = String.format(Locale.ENGLISH, "%d %d %d %n", numRows, numCols, nnz);
            rowIndicesBuilder.append("\n");
            colIndicesBuilder.append("\n");
            valuesBuilder.append("\n");
            out.write(sMatrixInfo);
            out.write(rowIndicesBuilder.toString());
            out.write(colIndicesBuilder.toString());
            out.write(valuesBuilder.toString());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            PsDebug.warning((String)"IO problem during file read");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PnSparseMatrix loadSparseMatrix(String filename) {
        PnSparseMatrix sA = null;
        String line = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(filename));
            line = br.readLine();
            if (line != null) {
                String[] lineEntries = line.split(" ");
                if (lineEntries.length != 3) {
                    PsDebug.warning((String)"First line of sparse matrix file has wrong format (not 'm n nnz')");
                    br.close();
                    return null;
                }
                int m = Integer.parseInt(lineEntries[0]);
                int n = Integer.parseInt(lineEntries[1]);
                int nnz = Integer.parseInt(lineEntries[2]);
                PsDebug.notify((String)("Parsing sparse matrix with " + nnz + " nonzero entries."));
                sA = new PnSparseMatrix(m, n);
                String[] lineRowIdxEntries = br.readLine().split(SPACE);
                String[] lineColIdxEntries = br.readLine().split(SPACE);
                String[] lineValuesEntries = br.readLine().split(SPACE);
                int length = lineRowIdxEntries.length;
                int i = 0;
                while (i < length) {
                    int rowIdx = Integer.parseInt(lineRowIdxEntries[i]);
                    int colIdx = Integer.parseInt(lineColIdxEntries[i]);
                    double value = Double.parseDouble(lineValuesEntries[i]);
                    sA.setEntry(rowIdx, colIdx, value);
                    ++i;
                }
            }
            br.close();
        }
        catch (FileNotFoundException fN) {
            PsDebug.warning((String)("Could not find file " + filename));
            return null;
        }
        catch (IOException e) {
            PsDebug.warning((String)"IO problem during file read");
            e.printStackTrace();
        }
        sA.validate();
        return sA;
    }
}

