/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.tetgen;

import dev6.thirdParty.tetgen.PnTetgen;
import jv.geom.PgElementSet;
import jv.geom.PgTetraSet;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jvx.project.PjWorkshop;

public class PwTetgen
extends PjWorkshop {
    protected PgElementSet m_geom;
    private PgTetraSet m_tetraSet;
    public PuDouble m_minRadiusEdge = new PuDouble("Min Radius/Edge");
    public PuDouble m_minVolume;

    public PwTetgen() {
        super("Tetgen workshop");
        this.m_minRadiusEdge.setDefBounds(1.0, 10.0, 1.0, 1.0);
        this.m_minRadiusEdge.setDefValue(2.0);
        this.m_minRadiusEdge.init();
        this.m_minVolume = new PuDouble("Min Volume");
        this.m_minVolume.setDefBounds(0.0, 16.0, 1.0, 1.0);
        this.m_minVolume.setDefValue(0.0);
        this.m_minVolume.init();
        if (((Object)((Object)this)).getClass() == PwTetgen.class) {
            this.init();
        }
    }

    public PwTetgen(PgElementSet geom) {
        this();
        this.setGeometry((PgGeometry)geom);
    }

    public void init() {
        super.init();
    }

    public void setGeometry(PgGeometry geom) {
        if (geom == null || !(geom instanceof PgElementSet)) {
            PsDebug.warning((String)"Geom is not an PgElementSet.");
            return;
        }
        super.setGeometry(geom);
        this.m_geom = (PgElementSet)geom;
        double d = this.m_geom.getDiameter();
        this.m_minVolume.setValue(d * d * d / 8192.0);
        this.update((Object)this);
    }

    public void setDisplay(PvDisplayIf display) {
        super.setDisplay(display);
    }

    public boolean update(Object event) {
        return super.update(event);
    }

    public String getName() {
        return "Tetgen workshop";
    }

    public void tetrahedralize() {
        if (this.m_tetraSet != null) {
            this.getDisplay().removeGeometry((PgGeometryIf)this.m_tetraSet);
        }
        PnTetgen tetgen = new PnTetgen();
        tetgen.setMinRadiusEdgeRatio(this.m_minRadiusEdge.getValue());
        tetgen.setMinVolume(this.m_minVolume.getValue());
        PgTetraSet tetraSet = tetgen.tetrahedralize(this.m_geom);
        tetraSet.showVertices(true);
        this.m_tetraSet = tetraSet;
        this.m_geom.setVisible(false);
        this.m_geom.update((Object)this.m_geom);
        this.getDisplay().addGeometry((PgGeometryIf)tetraSet);
        this.getDisplay().selectGeometry((PgGeometryIf)tetraSet);
        this.getDisplay().update((Object)this.getDisplay());
    }
}

