/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.tetgen;

import jv.geom.PgElementSet;
import jv.geom.PgTetraSet;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PnTetgen {
    private static boolean m_libraryLoaded = false;
    private PdVector[] m_vertexAttributes;
    private PiVector m_vertexMarker;
    private double m_minRadiusEdgeRatio = 0.0;
    private double m_minVolume = 0.0;
    private boolean m_quiet = true;
    private double m_tolerance;
    private boolean m_avoidSteiner;
    private boolean m_avoidSteinerAll;

    static {
        try {
            System.loadLibrary("TetgenJni");
            m_libraryLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            m_libraryLoaded = false;
        }
    }

    public static boolean isLibraryLoaded() {
        return m_libraryLoaded;
    }

    public PgTetraSet tetrahedralize(PgElementSet geom) {
        return this.tetrahedralize(geom, null, null, null);
    }

    public PgTetraSet tetrahedralize(PgElementSet geom, PdVector[] vertexAttributes, PiVector vertexMarker, PiVector elementMarker) {
        if (!m_libraryLoaded) {
            PsDebug.warning((String)"External tetgen library is not loaded.");
            return null;
        }
        String parameter = "pz";
        if (this.m_minRadiusEdgeRatio > 0.0) {
            parameter = String.valueOf(parameter) + "q" + PuString.toString((double)this.m_minRadiusEdgeRatio, (int)8);
        }
        if (this.m_minVolume > 0.0) {
            parameter = String.valueOf(parameter) + "a" + PuString.toString((double)this.m_minVolume, (int)8);
        }
        if (this.m_quiet) {
            parameter = String.valueOf(parameter) + "Q";
        }
        if (this.m_tolerance > 0.0) {
            parameter = String.valueOf(parameter) + "T" + PuString.toString((double)this.m_tolerance, (int)12);
        }
        if (this.m_avoidSteinerAll) {
            parameter = String.valueOf(parameter) + "YY";
        } else if (this.m_avoidSteiner) {
            parameter = String.valueOf(parameter) + "Y";
        }
        return this.tetrahedralize(geom, parameter, vertexAttributes, vertexMarker, elementMarker);
    }

    public PdVector[] getVertexAttributes() {
        return this.m_vertexAttributes;
    }

    public PiVector getVertexMarker() {
        return this.m_vertexMarker;
    }

    public void setMinRadiusEdgeRatio(double minRadiusEdge) {
        this.m_minRadiusEdgeRatio = minRadiusEdge;
    }

    public void setMinVolume(double minVolume) {
        this.m_minVolume = minVolume;
    }

    public void setQuietMode(boolean quiet) {
        this.m_quiet = quiet;
    }

    public void setTolerance(double tolerance) {
        this.m_tolerance = tolerance;
    }

    public void setAvoidSteinerPoints(boolean avoid, boolean avoidAll) {
        this.m_avoidSteiner = avoid;
        this.m_avoidSteinerAll = avoidAll;
    }

    private PgTetraSet tetrahedralize(PgElementSet geom, String commandLineParameter, PdVector[] vertexAttributes, PiVector vertexMarker, PiVector elementMarker) {
        int v;
        int numV = geom.getNumVertices();
        PdVector[] vertices = geom.getVertices();
        int v2 = 0;
        while (v2 < numV) {
            if (vertices[v2] == null || vertices[v2].getSize() != 3) {
                PsDebug.warning((String)("Vertex " + v2 + " has not dimension 3"));
                return null;
            }
            ++v2;
        }
        PiVector[] elements = geom.getElements();
        if (elements == null) {
            PsDebug.warning((String)"No elements in geometry.");
            return null;
        }
        this.tetrahedralize_(commandLineParameter, vertices, elements, vertexAttributes, vertexMarker, elementMarker);
        double[][] newVertices = this.getVertices_();
        int[][] tets = this.getTets_();
        double[][] newVertexAttributes = this.getVertexAttributes_();
        int[] newVertexMarker = this.getVertexMarker_();
        this.dispose_();
        int newNumV = newVertices.length;
        if (vertexAttributes == null) {
            this.m_vertexAttributes = null;
        } else {
            int numVA = newVertexAttributes[0].length;
            this.m_vertexAttributes = PdVector.realloc((PdVector[])this.m_vertexAttributes, (int)newNumV, (int)numVA);
            v = 0;
            while (v < newNumV) {
                int i = 0;
                while (i < numVA) {
                    this.m_vertexAttributes[v].m_data[i] = newVertexAttributes[v][i];
                    ++i;
                }
                ++v;
            }
        }
        if (newVertexMarker == null) {
            this.m_vertexMarker = null;
        } else {
            this.m_vertexMarker = new PiVector(newNumV);
            int v3 = 0;
            while (v3 < newNumV) {
                this.m_vertexMarker.m_data[v3] = newVertexMarker[v3];
                ++v3;
            }
        }
        PgTetraSet tetraSet = new PgTetraSet(3);
        tetraSet.setNumVertices(newNumV);
        v = 0;
        while (v < newNumV) {
            tetraSet.setVertex(v, new PdVector(newVertices[v]));
            ++v;
        }
        tetraSet.setNumTetras(tets.length);
        int t = 0;
        while (t < tets.length) {
            tetraSet.setTetra(t, new PiVector(tets[t]));
            ++t;
        }
        tetraSet.makeNeighbour();
        tetraSet.setName("Tets of " + geom.getName());
        return tetraSet;
    }

    private void tetrahedralize_(String parameter, PdVector[] vertices, PiVector[] elements, PdVector[] vertexAttributes, PiVector vertexMarker, PiVector elementMarker) {
        int numV = vertices.length;
        double[][] newV = new double[numV][];
        int v = 0;
        while (v < numV) {
            newV[v] = vertices[v].m_data;
            ++v;
        }
        int numE = elements.length;
        int[][] newE = new int[numE][];
        int e = 0;
        while (e < numE) {
            newE[e] = elements[e].m_data;
            ++e;
        }
        int numAttributes = vertexAttributes == null ? 0 : vertexAttributes[0].getSize();
        double[][] newVertexAttributes = null;
        if (numAttributes > 0) {
            newVertexAttributes = new double[numV][numAttributes];
            int v2 = 0;
            while (v2 < numV) {
                if (vertexAttributes[v2] == null || vertexAttributes[v2].getSize() != numAttributes) {
                    PsDebug.warning((String)("Number of attributes for vertex " + v2 + " must be " + numAttributes));
                    return;
                }
                System.arraycopy(vertexAttributes[v2].m_data, 0, newVertexAttributes[v2], 0, numAttributes);
                ++v2;
            }
        }
        int[] newVertexMarker = null;
        if (vertexMarker != null) {
            if (vertexMarker.getSize() != numV) {
                PsDebug.warning((String)("Number of vertex marker must be " + numV));
                return;
            }
            newVertexMarker = vertexMarker.m_data;
        }
        int[] newElementMarker = null;
        if (elementMarker != null) {
            if (elementMarker.getSize() != numE) {
                PsDebug.warning((String)("Number of element marker must be " + numE));
                return;
            }
            newElementMarker = elementMarker.m_data;
        }
        this.tetrahedralize_(parameter, newV, newE, numAttributes, newVertexAttributes, newVertexMarker, newElementMarker);
    }

    private native void tetrahedralize_(String var1, double[][] var2, int[][] var3, int var4, double[][] var5, int[] var6, int[] var7);

    private native double[][] getVertices_();

    private native int[][] getTets_();

    private native double[][] getVertexAttributes_();

    private native int[] getVertexMarker_();

    private native void dispose_();
}

