/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.pngj.samples;

import dev6.thirdParty.pngj.ImageLine;
import dev6.thirdParty.pngj.PngReader;
import dev6.thirdParty.pngj.PngWriter;

public class PngReencode {
    public static void reencode(String orig, String dest, int filter, int cLevel) {
        PngReader pngr = new PngReader(orig);
        PngWriter pngw = new PngWriter(dest, pngr.imgInfo);
        pngw.setOverrideFile(true);
        System.out.println(pngr.toString());
        pngw.setFilterType(filter);
        pngw.setCompLevel(cLevel);
        pngw.prepare(pngr);
        System.out.println("Creating Image " + pngw.getFilename() + "  filter=" + filter + "   compLevel=" + cLevel);
        int row = 0;
        while (row < pngr.imgInfo.rows) {
            ImageLine l1 = pngr.readRow(row);
            pngw.writeRow(l1);
            ++row;
        }
        pngr.end();
        pngw.end();
        System.out.println("Done");
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.err.println("Arguments: [pngsrc] [pngdest] [filter] [compressionlevel]");
            System.err.println(" Where filter = 0..4  , compressionLevel = 0 .. 9");
            System.exit(1);
        }
        PngReencode.reencode(args[0], args[1], Integer.parseInt(args[2]), Integer.parseInt(args[3]));
    }
}

