/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.pngj.samples;

import dev6.thirdParty.pngj.ImageInfo;
import dev6.thirdParty.pngj.ImageLine;
import dev6.thirdParty.pngj.PngWriter;

public class PngCreate {
    private static void makeTestImage(PngWriter png) throws Exception {
        int cols = png.imgInfo.cols;
        int rows = png.imgInfo.rows;
        boolean alpha = png.imgInfo.alpha;
        int channels = png.imgInfo.channels;
        int valuesPerRow = png.imgInfo.samplesPerRow;
        ImageLine iline = new ImageLine(png.imgInfo);
        iline.setRown(0);
        iline.setValD(0, 1.0);
        iline.setValD(1, 1.0);
        iline.setValD(2, 0.0);
        iline.setValD(valuesPerRow - channels, 0.0);
        iline.setValD(valuesPerRow - channels + 1, 1.0);
        iline.setValD(valuesPerRow - channels + 2, 0.0);
        int j = 1;
        while (j < cols - 1) {
            iline.setValD(j * channels, 1.0);
            iline.setValD(j * channels + 1, 1.0);
            iline.setValD(j * channels + 2, 1.0);
            ++j;
        }
        if (alpha) {
            PngCreate.addAlpha(iline);
        }
        png.writeRow(iline);
        iline.incRown();
        j = 1;
        while (j < cols - 1) {
            iline.setValD(j * channels, 0.0);
            iline.setValD(j * channels + 1, 0.0);
            iline.setValD(j * channels + 2, 0.0);
            ++j;
        }
        if (alpha) {
            PngCreate.addAlpha(iline);
        }
        png.writeRow(iline);
        iline.incRown();
        while (iline.getRown() < rows) {
            j = 1;
            while (j < cols - 1) {
                iline.setValD(j * channels, PngCreate.clamp((double)(2 * j / cols) - 0.3, 0.0, 1.0));
                iline.setValD(j * channels + 1, PngCreate.clamp((double)(2 * iline.getRown() / rows) - 0.4, 0.0, 1.0));
                iline.setValD(j * channels + 2, PngCreate.clamp(0.55 * Math.sin(13.0 * (double)iline.getRown() / (double)rows + (double)j * 25.0 / (double)cols) + 0.5, 0.0, 1.0));
                ++j;
            }
            if (alpha) {
                PngCreate.addAlpha(iline);
            }
            png.writeRow(iline);
            iline.incRown();
        }
    }

    private static void addAlpha(ImageLine iline) {
        int cols = iline.imgInfo.cols;
        int rows = iline.imgInfo.rows;
        int i = 0;
        while (i < iline.imgInfo.cols) {
            double alpha;
            if (i == 0 || i == iline.imgInfo.cols - 1 || iline.getRown() < 2) {
                alpha = 1.0;
            } else {
                double d = Math.sqrt(0.5 * (double)i / (double)cols + 0.0 + (0.5 * (double)(rows - iline.getRown()) / (double)rows + 0.0));
                d = d * 1.3 - 0.2;
                alpha = PngCreate.clamp(d, 0.0, 1.0);
            }
            iline.setValD(i * 4 + 3, PngCreate.clamp(alpha, 0.0, 1.0));
            ++i;
        }
    }

    private static double clamp(double d, double d0, double d1) {
        return d > d1 ? d1 : (d < d0 ? d0 : d);
    }

    public static void createTest1(String orig, int cols, int rows, int bitspc, int channels) throws Exception {
        if (channels != 3 && channels != 4) {
            throw new RuntimeException("bad channels number (must be 3 or 4)");
        }
        PngWriter i2 = new PngWriter(orig, new ImageInfo(cols, rows, bitspc, channels == 4));
        i2.setOverrideFile(true);
        PngCreate.makeTestImage(i2);
        i2.end();
        System.out.println("Done: " + i2.getFilename());
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 5) {
            System.err.println("Arguments: [pngdest] [cols] [rows] [bitsc] [channels] [type]");
            System.err.println(" Where bitsc=8|16, channels=3|4");
            System.err.println("type : 0: gray opaque image  1=test image with colors (default) ");
            System.exit(1);
        }
        int type = args.length == 6 ? Integer.parseInt(args[5]) : 1;
        int cols = Integer.parseInt(args[1]);
        int rows = Integer.parseInt(args[2]);
        int bitspc = Integer.parseInt(args[3]);
        int chan = Integer.parseInt(args[4]);
        if (type == 0) {
            throw new RuntimeException("no implementado");
        }
        PngCreate.createTest1(args[0], cols, rows, bitspc, chan);
    }
}

