/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.pngj.samples;

import dev6.thirdParty.pngj.ImageLine;
import dev6.thirdParty.pngj.PngReader;

public class ImgDiff {
    private static int[] computeDiffLine(ImageLine l1, ImageLine l2) {
        double maxDif = -1.0;
        int maxDifCol = -1;
        int channels = l1.imgInfo.channels;
        int col = 0;
        while (col < l1.imgInfo.cols) {
            double dif = Math.abs(l1.scanline[col * channels] - l2.scanline[col * channels]) + Math.abs(l1.scanline[col * channels + 1] - l2.scanline[col * channels + 1]) + Math.abs(l1.scanline[col * channels + 2] - l2.scanline[col * channels + 2]);
            if (channels == 4) {
                dif += (double)Math.abs(l1.scanline[col * channels + 3] - l2.scanline[col * channels + 3]);
            }
            if (dif > maxDif) {
                maxDif = dif;
                maxDifCol = col;
            }
            ++col;
        }
        return new int[]{(int)(maxDif + 0.5), maxDifCol};
    }

    public static void showDiff(String f1, String f2) {
        int maxDif = -1;
        int maxDifCol = -1;
        int maxDifRow = -1;
        PngReader i1 = new PngReader(f1);
        PngReader i2 = new PngReader(f2);
        System.out.println(i1.toString());
        System.out.println(i2.toString());
        if (!i1.imgInfo.equals(i2.imgInfo)) {
            throw new RuntimeException("Images must be comparable ");
        }
        int rows = i1.imgInfo.rows;
        int row = 0;
        while (row < rows) {
            ImageLine l2;
            ImageLine l1 = i1.readRow(row);
            int[] res = ImgDiff.computeDiffLine(l1, l2 = i2.readRow(row));
            if (res[0] > maxDif) {
                maxDif = res[0];
                maxDifCol = res[1];
                maxDifRow = row;
            }
            ++row;
        }
        i1.end();
        i2.end();
        if (maxDif == 0) {
            System.out.println("No diffence");
        } else {
            System.out.println("Images differ. MaxDif=" + maxDif + " [" + maxDifCol + " " + maxDifRow + "]");
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Enter two filenames (images to be compared)");
            System.exit(1);
        }
        ImgDiff.showDiff(args[0], args[1]);
    }
}

