/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.pngj.samples;

import dev6.thirdParty.pngj.ImageLine;
import dev6.thirdParty.pngj.PngReader;
import dev6.thirdParty.pngj.PngWriter;

public class DecreaseRed {
    public static void decreaseRed(String origFilename, String destFilename) {
        PngReader pngr = new PngReader(origFilename);
        PngWriter pngw = new PngWriter(destFilename, pngr.imgInfo);
        pngw.setOverrideFile(true);
        System.out.println(pngr.toString());
        pngw.prepare(pngr);
        int channels = pngr.imgInfo.channels;
        if (channels < 3) {
            throw new RuntimeException("Only for truecolour images");
        }
        int row = 0;
        while (row < pngr.imgInfo.rows) {
            ImageLine l1 = pngr.readRow(row);
            int j = 0;
            while (j < pngr.imgInfo.cols) {
                int n = j * channels;
                l1.scanline[n] = l1.scanline[n] / 2;
                ++j;
            }
            pngw.writeRow(l1);
            ++row;
        }
        pngr.end();
        pngw.end();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Arguments: [pngsrc] [pngdest]");
            System.exit(1);
        }
        DecreaseRed.decreaseRed(args[0], args[1]);
        System.out.println("Done");
    }
}

