/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.pngj;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class ProgressiveOutputStream
extends ByteArrayOutputStream {
    private final int size;

    public ProgressiveOutputStream(int size) {
        this.size = size;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.checkFlushBuffer(true);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        super.write(b, off, len);
        this.checkFlushBuffer(false);
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
        this.checkFlushBuffer(false);
    }

    @Override
    public void write(int arg0) {
        super.write(arg0);
        this.checkFlushBuffer(false);
    }

    @Override
    public synchronized void reset() {
        super.reset();
    }

    private void checkFlushBuffer(boolean forced) {
        while (forced || this.count >= this.size) {
            int bytesleft;
            int nb = this.size;
            if (nb > this.count) {
                nb = this.count;
            }
            if (nb == 0) {
                return;
            }
            this.flushBuffer(this.buf, nb);
            this.count = bytesleft = this.count - nb;
            if (bytesleft <= 0) continue;
            System.arraycopy(this.buf, nb, this.buf, 0, bytesleft);
        }
    }

    public abstract void flushBuffer(byte[] var1, int var2);
}

