/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.pngj;

import dev6.thirdParty.pngj.ImageInfo;
import dev6.thirdParty.pngj.ImageLine;
import dev6.thirdParty.pngj.PngChunk;
import dev6.thirdParty.pngj.PngHelper;
import dev6.thirdParty.pngj.PngIDatChunkOutputStream;
import dev6.thirdParty.pngj.PngReader;
import dev6.thirdParty.pngj.PngjException;
import dev6.thirdParty.pngj.PngjOutputException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PngWriter {
    public static final int FILTER_NONE = 0;
    public static final int FILTER_SUB = 1;
    public static final int FILTER_UP = 2;
    public static final int FILTER_AVERAGE = 3;
    public static final int FILTER_PAETH = 4;
    private final String filename;
    private boolean overwrite = false;
    public final ImageInfo imgInfo;
    private final int valsPerRow;
    private final int bytesPerRow;
    private int compLevel = 6;
    private int filterType = 4;
    private Double dpi = null;
    private PngTxtInfo txtInfo = new PngTxtInfo();
    private boolean initialized = false;
    protected final CRC32 crcEngine;
    private int rowNum = -1;
    private int[] scanline = null;
    private int[] rowb = null;
    private int[] rowbprev = null;
    private byte[] rowbfilter = null;
    protected OutputStream os;
    private PngIDatChunkOutputStream datStream;
    private DeflaterOutputStream datStreamDeflated;

    public PngWriter(String filename, ImageInfo imgInfo) {
        this.filename = filename;
        this.imgInfo = imgInfo;
        this.bytesPerRow = imgInfo.cols * imgInfo.bytesPixel;
        this.valsPerRow = imgInfo.cols * imgInfo.channels;
        this.crcEngine = new CRC32();
        this.scanline = new int[this.valsPerRow];
        this.rowb = new int[this.bytesPerRow + 1];
        this.rowbprev = new int[this.bytesPerRow + 1];
        this.rowbfilter = new byte[this.bytesPerRow + 1];
    }

    public void prepare(PngReader reader) {
        if (this.initialized) {
            return;
        }
        File f = new File(this.filename);
        if (f.exists() && !this.overwrite) {
            throw new PngjException("File exists (and overwrite=false) " + this.filename);
        }
        try {
            this.os = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new PngjOutputException("error opening " + this.filename + " for writing", e);
        }
        this.datStream = new PngIDatChunkOutputStream(this.os, 8192);
        this.datStreamDeflated = new DeflaterOutputStream((OutputStream)this.datStream, new Deflater(this.compLevel));
        this.writeHeader();
        boolean physChunkDone = false;
        if (this.dpi != null) {
            this.writePhysChunk();
            physChunkDone = true;
        }
        if (reader != null) {
            int size = reader.getChunks1().size();
            int i = 0;
            while (i < size) {
                PngChunk chunk = (PngChunk)reader.getChunks1().get(i);
                if (!(!chunk.id.equals("PLTE") && (chunk.isCritical() || !chunk.isSafeToCopy()) || chunk.id.equals("pHYs") && physChunkDone)) {
                    chunk.writeChunk(this.os);
                }
                ++i;
            }
        }
        this.txtInfo.writeChunks();
        this.initialized = true;
    }

    public void prepare(PngReader reader, OutputStream out) {
        if (this.initialized) {
            return;
        }
        this.os = out;
        this.datStream = new PngIDatChunkOutputStream(this.os, 8192);
        this.datStreamDeflated = new DeflaterOutputStream((OutputStream)this.datStream, new Deflater(this.compLevel));
        this.writeHeader();
        boolean physChunkDone = false;
        if (this.dpi != null) {
            this.writePhysChunk();
            physChunkDone = true;
        }
        if (reader != null) {
            int size = reader.getChunks1().size();
            int i = 0;
            while (i < size) {
                PngChunk chunk = (PngChunk)reader.getChunks1().get(i);
                if (!(!chunk.id.equals("PLTE") && (chunk.isCritical() || !chunk.isSafeToCopy()) || chunk.id.equals("pHYs") && physChunkDone)) {
                    chunk.writeChunk(this.os);
                }
                ++i;
            }
        }
        this.txtInfo.writeChunks();
        this.initialized = true;
    }

    public void doInit() {
        this.prepare(null);
    }

    private void writeHeader() {
        PngHelper.writeBytes(this.os, PngHelper.pngIdBytes);
        ByteArrayOutputStream tstream = new ByteArrayOutputStream();
        PngHelper.writeInt4(tstream, this.imgInfo.cols);
        PngHelper.writeInt4(tstream, this.imgInfo.rows);
        PngHelper.writeByte(tstream, (byte)this.imgInfo.bitDepth);
        int colormodel = 0;
        if (this.imgInfo.alpha) {
            colormodel += 4;
        }
        if (this.imgInfo.indexed) {
            ++colormodel;
        }
        if (!this.imgInfo.greyscale) {
            colormodel += 2;
        }
        PngHelper.writeByte(tstream, (byte)colormodel);
        PngHelper.writeByte(tstream, (byte)0);
        PngHelper.writeByte(tstream, (byte)0);
        PngHelper.writeByte(tstream, (byte)0);
        byte[] b = tstream.toByteArray();
        if (b.length != 13) {
            throw new PngjOutputException("BAD IDHR!");
        }
        PngHelper.writeChunk(this.os, b, 0, b.length, PngHelper.IHDR, this.crcEngine);
    }

    protected void writePhysChunk() {
        ByteArrayOutputStream tstream = new ByteArrayOutputStream();
        int pixelsPerMeter = (int)(this.dpi * 100.0 / 2.54 + 0.5);
        PngHelper.writeInt4(tstream, pixelsPerMeter);
        PngHelper.writeInt4(tstream, pixelsPerMeter);
        PngHelper.writeByte(tstream, (byte)1);
        byte[] b = tstream.toByteArray();
        PngHelper.writeChunk(this.os, b, 0, b.length, PngHelper.IPHYS, this.crcEngine);
    }

    protected void endchunk() {
        byte[] b = new byte[]{};
        PngHelper.writeChunk(this.os, b, 0, 0, PngHelper.IEND, this.crcEngine);
    }

    public void writeRow(int[] newrow, int n) {
        if (!this.initialized) {
            this.doInit();
        }
        if (n < 0 || n > this.imgInfo.rows) {
            throw new RuntimeException("invalid value for row ");
        }
        ++this.rowNum;
        if (this.rowNum != n) {
            throw new RuntimeException("write order must be strict for rows " + n + " (expected=" + this.rowNum + ")");
        }
        this.scanline = newrow;
        int[] tmp = this.rowb;
        this.rowb = this.rowbprev;
        this.rowbprev = tmp;
        this.convertRowToBytes();
        this.filterRow();
        try {
            this.datStreamDeflated.write(this.rowbfilter, 0, this.bytesPerRow + 1);
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    public void writeRow(ImageLine imgline) {
        this.writeRow(imgline.scanline, imgline.getRown());
    }

    public void end() {
        if (this.rowNum != this.imgInfo.rows - 1) {
            throw new PngjOutputException("all rows have not been written");
        }
        try {
            this.datStreamDeflated.finish();
            this.datStream.flush();
            this.endchunk();
            this.os.close();
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    private void filterRow() {
        this.rowbfilter[0] = (byte)this.filterType;
        switch (this.filterType) {
            case 0: {
                this.filterRowNone();
                break;
            }
            case 1: {
                this.filterRowSub();
                break;
            }
            case 2: {
                this.filterRowUp();
                break;
            }
            case 3: {
                this.filterRowAverage();
                break;
            }
            case 4: {
                this.filterRowPaeth();
                break;
            }
            default: {
                throw new PngjOutputException("Filter type " + this.filterType + " not implemented");
            }
        }
    }

    private void filterRowNone() {
        int i = 1;
        while (i <= this.bytesPerRow) {
            this.rowbfilter[i] = (byte)this.rowb[i];
            ++i;
        }
    }

    private void filterRowSub() {
        int i = 1;
        while (i <= this.imgInfo.bytesPixel) {
            this.rowbfilter[i] = (byte)this.rowb[i];
            ++i;
        }
        int j = 1;
        i = this.imgInfo.bytesPixel + 1;
        while (i <= this.bytesPerRow) {
            this.rowbfilter[i] = (byte)(this.rowb[i] - this.rowb[j]);
            ++i;
            ++j;
        }
    }

    private void filterRowUp() {
        int i = 1;
        while (i <= this.bytesPerRow) {
            this.rowbfilter[i] = (byte)(this.rowb[i] - this.rowbprev[i]);
            ++i;
        }
    }

    private void filterRowAverage() {
        int i = 1;
        while (i <= this.bytesPerRow) {
            if (this.rowb[i] < 0 || this.rowb[i] > 255) {
                throw new PngjOutputException("??" + this.rowb[i]);
            }
            if (this.rowbprev[i] < 0 || this.rowbprev[i] > 255) {
                throw new PngjOutputException("??" + this.rowbprev[i]);
            }
            ++i;
        }
        int j = 1 - this.imgInfo.bytesPixel;
        i = 1;
        while (i <= this.bytesPerRow) {
            int x = j > 0 ? this.rowb[j] : 0;
            this.rowbfilter[i] = (byte)(this.rowb[i] - (this.rowbprev[i] + x) / 2);
            ++i;
            ++j;
        }
    }

    private void filterRowPaeth() {
        int i = 1;
        while (i <= this.bytesPerRow) {
            if (this.rowb[i] < 0 || this.rowb[i] > 255) {
                throw new PngjOutputException("??" + this.rowb[i] + " i=" + i + " row=" + this.rowNum);
            }
            if (this.rowbprev[i] < 0 || this.rowbprev[i] > 255) {
                throw new PngjOutputException("??" + this.rowbprev[i]);
            }
            ++i;
        }
        int j = 1 - this.imgInfo.bytesPixel;
        i = 1;
        while (i <= this.bytesPerRow) {
            int x = j > 0 ? this.rowb[j] : 0;
            int y = j > 0 ? this.rowbprev[j] : 0;
            this.rowbfilter[i] = (byte)(this.rowb[i] - PngHelper.filterPaethPredictor(x, this.rowbprev[i], y));
            ++i;
            ++j;
        }
    }

    private void convertRowToBytes() {
        this.rowb[0] = this.filterType;
        if (this.imgInfo.bitDepth == 8) {
            int i = 0;
            int j = 1;
            while (i < this.valsPerRow) {
                this.rowb[j++] = this.scanline[i] & 0xFF;
                ++i;
            }
        } else {
            int i = 0;
            int j = 1;
            while (i < this.valsPerRow) {
                int x = this.scanline[i] & 0xFFFF;
                this.rowb[j++] = (x & 0xFF00) >> 8;
                this.rowb[j++] = x & 0xFF;
                ++i;
            }
        }
    }

    public void setOverrideFile(boolean overrideFile) {
        this.overwrite = overrideFile;
    }

    public void setDpi(Double dpi) {
        this.dpi = dpi;
    }

    public void setFilterType(int filterType) {
        if (filterType < 0 || filterType > 4) {
            throw new PngjException("filterType  invalid (" + filterType + ") Must be 0..4");
        }
        this.filterType = filterType;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public void setCompLevel(int compLevel) {
        if (compLevel < 0 || compLevel > 9) {
            throw new PngjException("Compression level invalid (" + compLevel + ") Must be 0..9");
        }
        this.compLevel = compLevel;
    }

    public int getCompLevel() {
        return this.compLevel;
    }

    public int getCols() {
        return this.imgInfo.cols;
    }

    public int getRows() {
        return this.imgInfo.rows;
    }

    public String getFilename() {
        return this.filename;
    }

    public class PngTxtInfo {
        public String title;
        public String author;
        public String description;
        public String creation_time;
        public String software;
        public String disclaimer;
        public String warning;
        public String source;
        public String comment;

        public void writeChunks() {
            this.writeChunk("Title", this.title);
            this.writeChunk("Author", this.author);
            this.writeChunk("Description", this.description);
            this.writeChunk("Creation Time", this.creation_time);
            this.writeChunk("Software", this.software);
            this.writeChunk("Disclaimer", this.disclaimer);
            this.writeChunk("Software", this.software);
            this.writeChunk("Warning", this.warning);
            this.writeChunk("Source", this.source);
            this.writeChunk("Comment", this.comment);
        }

        private void writeChunk(String name, String val) {
            if (val == null) {
                return;
            }
            PngChunk p = PngChunk.createTextChunk(name, val, PngWriter.this.crcEngine);
            p.writeChunk(PngWriter.this.os);
        }
    }
}

