/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.pngj;

import dev6.thirdParty.pngj.ImageInfo;
import dev6.thirdParty.pngj.ImageLine;
import dev6.thirdParty.pngj.PngChunk;
import dev6.thirdParty.pngj.PngHelper;
import dev6.thirdParty.pngj.PngIDatChunkInputStream;
import dev6.thirdParty.pngj.PngjException;
import dev6.thirdParty.pngj.PngjInputException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.zip.CRC32;
import java.util.zip.InflaterInputStream;

public class PngReader {
    public static final int FILTER_NONE = 0;
    public static final int FILTER_SUB = 1;
    public static final int FILTER_UP = 2;
    public static final int FILTER_AVERAGE = 3;
    public static final int FILTER_PAETH = 4;
    public final ImageInfo imgInfo;
    public final String filename;
    private final InputStream is;
    private final InflaterInputStream idatIstream;
    private final PngIDatChunkInputStream iIdatCstream;
    private int offset = 0;
    private CRC32 crcengine;
    private static final int MAX_BYTES_CHUNKS_TO_LOAD = 64000;
    private int bytesChunksLoaded;
    private List chunks1 = new ArrayList();
    private List chunks2 = new ArrayList();
    private final int bytesPerRow;
    private final int valsPerRow;
    private int rowNum = -1;
    private ImageLine imgLine;
    private int[] rowb = null;
    private int[] rowbprev = null;
    private byte[] rowbfilter = null;
    private double dpi = 0.0;

    public PngReader(String filename) {
        boolean grayscale;
        this.filename = filename;
        this.crcengine = new CRC32();
        File file = new File(filename);
        if (!file.exists() || !file.canRead()) {
            throw new PngjInputException("Can open file for reading (" + filename + ") [" + file.getAbsolutePath() + "]");
        }
        try {
            this.is = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new PngjInputException("Can open file for reading (" + filename + ")");
        }
        byte[] pngid = new byte[PngHelper.pngIdBytes.length];
        PngHelper.readBytes(this.is, pngid, 0, pngid.length);
        this.offset += pngid.length;
        if (!Arrays.equals(pngid, PngHelper.pngIdBytes)) {
            throw new PngjInputException("Bad file id (" + filename + ")");
        }
        int clen = PngHelper.readInt4(this.is);
        this.offset += 4;
        if (clen != 13) {
            throw new RuntimeException("IDHR chunk len != 13 ?? " + clen);
        }
        byte[] chunkid = new byte[4];
        PngHelper.readBytes(this.is, chunkid, 0, 4);
        this.offset += 4;
        PngChunk ihdr = new PngChunk(clen, chunkid, this.crcengine);
        if (!ihdr.id.equals("IHDR")) {
            throw new PngjInputException("IHDR not found as first chunk??? [" + ihdr + "]");
        }
        ihdr.readChunk(this.is);
        this.offset += ihdr.len + 4;
        this.addChunkToList(ihdr, this.chunks1, true);
        ByteArrayInputStream ihdr_s = ihdr.getAsByteStream();
        int cols = PngHelper.readInt4(ihdr_s);
        int rows = PngHelper.readInt4(ihdr_s);
        int bitspc = PngHelper.readByte(ihdr_s);
        int colormodel = PngHelper.readByte(ihdr_s);
        int compmeth = PngHelper.readByte(ihdr_s);
        int filmeth = PngHelper.readByte(ihdr_s);
        int interlaced = PngHelper.readByte(ihdr_s);
        if (interlaced != 0) {
            throw new PngjInputException("Interlaced no implemented");
        }
        if (filmeth != 0 || compmeth != 0) {
            throw new PngjInputException("compmethod o filtermethod unrecognized");
        }
        boolean alpha = (colormodel & 4) != 0;
        boolean palette = (colormodel & 1) != 0;
        boolean bl = grayscale = colormodel == 0 || colormodel == 4;
        if (bitspc != 8 && bitspc != 16) {
            throw new RuntimeException("Bit depth not supported " + bitspc);
        }
        this.imgInfo = new ImageInfo(cols, rows, bitspc, alpha, grayscale, palette);
        this.imgLine = new ImageLine(this.imgInfo);
        this.bytesPerRow = this.imgInfo.bytesPixel * this.imgInfo.cols;
        this.valsPerRow = this.imgInfo.cols * this.imgInfo.channels;
        this.rowb = new int[this.bytesPerRow + 1];
        this.rowbprev = new int[this.bytesPerRow + 1];
        this.rowbfilter = new byte[this.bytesPerRow + 1];
        int idatLen = this.readFirstChunks();
        if (idatLen < 0) {
            throw new PngjInputException("first idat chunk not found!");
        }
        this.iIdatCstream = new PngIDatChunkInputStream(this.is, idatLen, this.offset);
        this.idatIstream = new InflaterInputStream(this.iIdatCstream);
    }

    private boolean addChunkToList(PngChunk chunk, List list, boolean includedata) {
        boolean overflow = false;
        if (chunk.id.equals("pHYs")) {
            ByteArrayInputStream b = chunk.getAsByteStream();
            int resx = PngHelper.readInt4(b);
            int resy = PngHelper.readInt4(b);
            int mode = PngHelper.readByte(b);
            if (mode == 1 & resx == resy) {
                this.dpi = (double)resx * 2.54 / 100.0;
            }
        }
        if (includedata && this.bytesChunksLoaded + chunk.len > 64000) {
            overflow = true;
            includedata = false;
        }
        if (includedata) {
            this.bytesChunksLoaded += chunk.len;
            if (chunk.data == null || chunk.len != chunk.data.length) {
                throw new PngjException("error en longitud de chunk a almacenar");
            }
        } else {
            chunk.data = null;
        }
        list.add(chunk);
        return overflow;
    }

    private int readFirstChunks() {
        int clen = 0;
        boolean found = false;
        while (!found) {
            clen = PngHelper.readInt4(this.is);
            this.offset += 4;
            byte[] chunkid = new byte[4];
            if (clen < 0) break;
            PngHelper.readBytes(this.is, chunkid, 0, 4);
            this.offset += 4;
            if (Arrays.equals(chunkid, PngHelper.IDAT)) {
                found = true;
                break;
            }
            if (Arrays.equals(chunkid, PngHelper.IEND)) break;
            PngChunk chunk = new PngChunk(clen, chunkid, this.crcengine);
            chunk.readChunk(this.is);
            this.offset += chunk.len + 4;
            this.addChunkToList(chunk, this.chunks1, true);
        }
        return found ? clen : -1;
    }

    private void readLastChunks() {
        if (!this.iIdatCstream.isEnded()) {
            this.iIdatCstream.forceChunkEnd();
        }
        int clen = this.iIdatCstream.getLenLastChunk();
        byte[] chunkid = this.iIdatCstream.getIdLastChunk();
        boolean endfound = false;
        boolean first = true;
        while (!endfound) {
            if (!first) {
                clen = PngHelper.readInt4(this.is);
                this.offset += 4;
                if (clen < 0) {
                    throw new PngjInputException("bad len " + clen);
                }
                chunkid = new byte[4];
                PngHelper.readBytes(this.is, chunkid, 0, 4);
                this.offset += 4;
            }
            first = false;
            if (Arrays.equals(chunkid, PngHelper.IDAT)) {
                throw new PngjInputException("extra IDA CHUNKS ??");
            }
            if (Arrays.equals(chunkid, PngHelper.IEND)) {
                endfound = true;
            }
            PngChunk chunk = new PngChunk(clen, chunkid, this.crcengine);
            chunk.readChunk(this.is);
            this.offset += chunk.len + 4;
            this.addChunkToList(chunk, this.chunks2, true);
        }
        if (!endfound) {
            throw new PngjInputException("end chunk not found");
        }
        PngHelper.logdebug("end chunk found ok offset=" + this.offset);
    }

    public ImageLine readRow(int nrow) {
        this.readRow(this.imgLine.scanline, nrow);
        this.imgLine.incRown();
        return this.imgLine;
    }

    public int[] readRow(int[] buffer, int nrow) {
        if (nrow < 0 || nrow >= this.imgInfo.rows) {
            throw new PngjInputException("invalid line");
        }
        if (nrow != this.rowNum + 1) {
            throw new PngjInputException("invalid line (expected: " + (this.rowNum + 1));
        }
        ++this.rowNum;
        if (buffer == null) {
            buffer = new int[this.valsPerRow];
        }
        int[] tmp = this.rowb;
        this.rowb = this.rowbprev;
        this.rowbprev = tmp;
        PngHelper.readBytes(this.idatIstream, this.rowbfilter, 0, this.bytesPerRow + 1);
        this.rowb[0] = this.rowbfilter[0];
        this.unfilterRow();
        this.convertRowFromBytes(buffer);
        return buffer;
    }

    private void convertRowFromBytes(int[] buffer) {
        if (this.imgInfo.bitDepth == 8) {
            int i = 0;
            int j = 1;
            while (i < this.valsPerRow) {
                buffer[i] = this.rowb[j++];
                ++i;
            }
        } else {
            int i = 0;
            int j = 1;
            while (i < this.valsPerRow) {
                buffer[i] = (this.rowb[j++] << 8) + this.rowb[j++];
                ++i;
            }
        }
    }

    private void unfilterRow() {
        byte filterType = this.rowbfilter[0];
        switch (filterType) {
            case 0: {
                this.unfilterRowNone();
                break;
            }
            case 1: {
                this.unfilterRowSub();
                break;
            }
            case 2: {
                this.unfilterRowUp();
                break;
            }
            case 3: {
                this.unfilterRowAverage();
                break;
            }
            case 4: {
                this.unfilterRowPaeth();
                break;
            }
            default: {
                throw new PngjInputException("Filter type " + filterType + " not implemented");
            }
        }
    }

    private void unfilterRowNone() {
        int i = 1;
        while (i <= this.bytesPerRow) {
            this.rowb[i] = this.rowbfilter[i] & 0xFF;
            ++i;
        }
    }

    private void unfilterRowSub() {
        int i = 1;
        while (i <= this.imgInfo.bytesPixel) {
            this.rowb[i] = this.rowbfilter[i] & 0xFF;
            ++i;
        }
        int j = 1;
        i = this.imgInfo.bytesPixel + 1;
        while (i <= this.bytesPerRow) {
            this.rowb[i] = (this.rowbfilter[i] & 0xFF) + this.rowb[j] & 0xFF;
            ++i;
            ++j;
        }
    }

    private void unfilterRowUp() {
        int i = 1;
        while (i <= this.bytesPerRow) {
            this.rowb[i] = (this.rowbfilter[i] & 0xFF) + this.rowbprev[i] & 0xFF;
            ++i;
        }
    }

    private void unfilterRowAverage() {
        int j = 1 - this.imgInfo.bytesPixel;
        int i = 1;
        while (i <= this.bytesPerRow) {
            int x = j > 0 ? this.rowb[j] : 0;
            this.rowb[i] = (this.rowbfilter[i] & 0xFF) + (x + this.rowbprev[i]) / 2 & 0xFF;
            ++i;
            ++j;
        }
    }

    private void unfilterRowPaeth() {
        int j = 1 - this.imgInfo.bytesPixel;
        int i = 1;
        while (i <= this.bytesPerRow) {
            int x = j > 0 ? this.rowb[j] : 0;
            int y = j > 0 ? this.rowbprev[j] : 0;
            this.rowb[i] = (this.rowbfilter[i] & 0xFF) + PngHelper.filterPaethPredictor(x, this.rowbprev[i], y) & 0xFF;
            ++i;
            ++j;
        }
    }

    public void end() {
        this.offset = (int)this.iIdatCstream.getOffset();
        try {
            this.idatIstream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.readLastChunks();
        try {
            this.is.close();
        }
        catch (IOException e) {
            throw new PngjInputException("error closing input stream!", e);
        }
    }

    public List getChunks1() {
        return this.chunks1;
    }

    public List getChunks2() {
        return this.chunks2;
    }

    public double getDpi() {
        return this.dpi;
    }

    public double getDpcm() {
        return this.dpi / 2.54;
    }

    public void showChunks() {
        PngChunk chunk;
        int size = this.chunks1.size();
        int i = 0;
        while (i < size) {
            chunk = (PngChunk)this.chunks1.get(i);
            System.out.println(chunk);
            ++i;
        }
        System.out.println("-----------------");
        size = this.chunks1.size();
        i = 0;
        while (i < size) {
            chunk = (PngChunk)this.chunks2.get(i);
            System.out.println(chunk);
            ++i;
        }
    }

    public String toString() {
        return "filename=" + this.filename + " " + this.imgInfo.toString();
    }

    public static void showLineInfo(ImageLine line) {
        System.out.println(line);
        System.out.println(line.computeStats());
        System.out.println(line.infoFirstLastPixels());
    }

    public static void main(String[] args) {
        Locale.setDefault(Locale.US);
        PngReader png = new PngReader(args[0]);
        System.out.println(png);
        int each = png.imgInfo.rows / 7;
        int i = 0;
        while (i < png.imgInfo.rows) {
            png.readRow(i);
            if (i % each == 0 || i == png.imgInfo.rows - 1) {
                PngReader.showLineInfo(png.imgLine);
            }
            ++i;
        }
        png.end();
        png.showChunks();
    }
}

