/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.pngj;

import dev6.thirdParty.pngj.PngHelper;
import dev6.thirdParty.pngj.PngjBadCrcException;
import dev6.thirdParty.pngj.PngjInputException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.CRC32;

public class PngIDatChunkInputStream
extends InputStream {
    private final InputStream inputStream;
    private final CRC32 crcEngine;
    private int lenLastChunk;
    private byte[] idLastChunk = new byte[4];
    private int toReadThisChunk = 0;
    private boolean ended = false;
    private long offset;

    public PngIDatChunkInputStream(InputStream iStream, int lenFirstChunk, int offset) {
        this.offset = offset;
        this.inputStream = iStream;
        this.crcEngine = new CRC32();
        this.lenLastChunk = lenFirstChunk;
        this.toReadThisChunk = lenFirstChunk;
        System.arraycopy(PngHelper.IDAT, 0, this.idLastChunk, 0, 4);
        this.crcEngine.update(this.idLastChunk, 0, 4);
        PngHelper.logdebug("Init: len=" + this.lenLastChunk);
        if (lenFirstChunk == 0) {
            this.endChunkGoForNext();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    private void endChunkGoForNext() {
        do {
            int crccalc;
            int crc;
            if ((crc = PngHelper.readInt4(this.inputStream)) != (crccalc = (int)this.crcEngine.getValue())) {
                throw new PngjBadCrcException("error reading idat; offset: " + this.offset);
            }
            this.crcEngine.reset();
            this.lenLastChunk = PngHelper.readInt4(this.inputStream);
            if (this.lenLastChunk < 0) {
                throw new PngjInputException("invalid len for chunk: " + this.lenLastChunk);
            }
            this.toReadThisChunk = this.lenLastChunk;
            PngHelper.readBytes(this.inputStream, this.idLastChunk, 0, 4);
            this.offset += 12L;
            boolean bl = this.ended = !Arrays.equals(this.idLastChunk, PngHelper.IDAT);
            if (this.ended) continue;
            this.crcEngine.update(this.idLastChunk, 0, 4);
        } while (this.lenLastChunk == 0 && !this.ended);
    }

    public void forceChunkEnd() {
        if (!this.ended) {
            byte[] dummy = new byte[this.toReadThisChunk];
            PngHelper.readBytes(this.inputStream, dummy, 0, this.toReadThisChunk);
            this.crcEngine.update(dummy, 0, this.toReadThisChunk);
            this.endChunkGoForNext();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.toReadThisChunk == 0) {
            throw new RuntimeException("this should not happen");
        }
        int n = this.inputStream.read(b, off, len >= this.toReadThisChunk ? this.toReadThisChunk : len);
        if (n > 0) {
            this.crcEngine.update(b, off, n);
            this.offset += (long)n;
            this.toReadThisChunk -= n;
        }
        if (this.toReadThisChunk == 0) {
            this.endChunkGoForNext();
        }
        return n;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException {
        PngHelper.logdebug("read() No deberia entrara aca");
        byte[] b1 = new byte[1];
        int r = this.read(b1, 0, 1);
        return r < 0 ? -1 : b1[0];
    }

    public int getLenLastChunk() {
        return this.lenLastChunk;
    }

    public byte[] getIdLastChunk() {
        return this.idLastChunk;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean isEnded() {
        return this.ended;
    }
}

