/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.pngj;

import dev6.thirdParty.pngj.PngjBadCrcException;
import dev6.thirdParty.pngj.PngjInputException;
import dev6.thirdParty.pngj.PngjOutputException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class PngHelper {
    public static final byte[] pngIdBytes = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    public static final String IHDR_TEXT = "IHDR";
    public static final String IDAT_TEXT = "IDAT";
    public static final String IEND_TEXT = "IEND";
    public static final String ITEXT_TEXT = "tEXt";
    public static final String IPHYS_TEXT = "pHYs";
    public static final byte[] IHDR = "IHDR".getBytes();
    public static final byte[] IDAT = "IDAT".getBytes();
    public static final byte[] IEND = "IEND".getBytes();
    public static final byte[] ITEXT = "tEXt".getBytes();
    public static final byte[] IPHYS = "pHYs".getBytes();
    public static final boolean DEBUG = false;

    public static int readInt4(InputStream is) {
        int b4;
        int b3;
        int b2;
        int b1;
        block3: {
            try {
                b1 = is.read();
                b2 = is.read();
                b3 = is.read();
                b4 = is.read();
                if (b1 != -1 && b2 != -1 && b3 != -1 && b4 != -1) break block3;
                return -1;
            }
            catch (IOException e) {
                throw new PngjInputException("error reading readInt4", e);
            }
        }
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    public static void writeInt4(OutputStream os, int n) {
        byte[] temp = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        PngHelper.writeBytes(os, temp);
    }

    public static void readBytes(InputStream is, byte[] b, int offset, int len) {
        if (len == 0) {
            return;
        }
        try {
            int read = 0;
            while (read < len) {
                int n = is.read(b, offset + read, len - read);
                if (n < 1) {
                    throw new RuntimeException("error leyendo " + n + " !=" + len);
                }
                read += n;
            }
        }
        catch (IOException e) {
            throw new PngjInputException("error reading", e);
        }
    }

    public static void writeBytes(OutputStream os, byte[] b) {
        try {
            os.write(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeBytes(OutputStream os, byte[] b, int offset, int n) {
        try {
            os.write(b, offset, n);
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    public static int readByte(InputStream is) {
        try {
            return is.read();
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    public static void writeByte(OutputStream os, byte b) {
        try {
            os.write(b);
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    public static void writeChunk(OutputStream os, byte[] buf, int offset, int n, byte[] chunkid, CRC32 crc) {
        if (chunkid.length != 4) {
            throw new PngjOutputException("bad chunkid [" + new String(chunkid) + "]");
        }
        int chunkLength = n;
        crc.reset();
        PngHelper.writeInt4(os, chunkLength);
        PngHelper.writeBytes(os, chunkid);
        PngHelper.writeBytes(os, buf, 0, n);
        crc.update(chunkid, 0, chunkid.length);
        crc.update(buf, 0, n);
        PngHelper.writeInt4(os, (int)crc.getValue());
    }

    public static void readChunk(InputStream is, byte[] buff, int offset, int len, byte[] chunkid, CRC32 crc) {
        crc.reset();
        crc.update(chunkid, 0, chunkid.length);
        PngHelper.readBytes(is, buff, offset, len);
        crc.update(buff, offset, len);
        int crcval = (int)crc.getValue();
        int crcori = PngHelper.readInt4(is);
        if (crcori != crcval) {
            throw new PngjBadCrcException("crc no coincide " + new String(chunkid) + " calc=" + crcval + " read=" + crcori);
        }
    }

    public static int filterPaethPredictor(int a, int b, int c) {
        int p = a + b - c;
        int pa = Math.abs(p - a);
        int pb = Math.abs(p - b);
        int pc = Math.abs(p - c);
        if (pa <= pb && pa <= pc) {
            return a;
        }
        if (pb <= pc) {
            return b;
        }
        return c;
    }

    public static void logdebug(String msg) {
    }
}

