/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.pngj;

import dev6.thirdParty.pngj.ImageInfo;
import dev6.thirdParty.pngj.PngWriter;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import jv.loader.PsImageCoderIf;
import jv.object.PsDebug;

public class PngEncoder
implements PsImageCoderIf {
    protected BufferedOutputStream m_outStream;
    protected Image m_image;
    private int m_compression = 6;

    public void encode() {
        int width = this.m_image.getWidth(null);
        int height = this.m_image.getHeight(null);
        int[] pixels = new int[width * height];
        boolean hasAlpha = false;
        int i = 0;
        while (i < pixels.length) {
            if ((pixels[i] & 0xFF000000) != 0) {
                hasAlpha = true;
                break;
            }
            ++i;
        }
        PixelGrabber grabber = new PixelGrabber(this.m_image, 0, 0, width, height, pixels, 0, width);
        try {
            if (!grabber.grabPixels()) {
                PsDebug.warning((String)("Grabber returned false: " + grabber.status()));
            }
        }
        catch (InterruptedException e) {
            PsDebug.warning((String)"Pixel grabber error.");
        }
        ImageInfo imageInfo = new ImageInfo(width, height, 8, hasAlpha);
        PngWriter pngWriter = new PngWriter(null, imageInfo);
        pngWriter.prepare(null, this.m_outStream);
        pngWriter.setOverrideFile(true);
        pngWriter.setCompLevel(this.m_compression);
        int channels = hasAlpha ? 4 : 3;
        int[] line = new int[width * channels];
        int row = 0;
        while (row < height) {
            int j = 0;
            int i2 = 0;
            while (i2 < width) {
                int pixel = pixels[i2 + row * width];
                if (channels == 4) {
                    line[j++] = pixel >> 24 & 0xFF;
                }
                line[j++] = pixel >> 16 & 0xFF;
                line[j++] = pixel >> 8 & 0xFF;
                line[j++] = pixel & 0xFF;
                ++i2;
            }
            pngWriter.writeRow(line, row);
            ++row;
        }
        pngWriter.end();
    }

    public void setImage(Image image) {
        this.m_image = image;
    }

    public void setOutputStream(OutputStream out) {
        this.m_outStream = new BufferedOutputStream(out);
    }

    public void setCompression(int compression) {
        if (compression < 0 || compression > 9) {
            return;
        }
        this.m_compression = compression;
    }
}

