/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.pngj;

import dev6.thirdParty.pngj.PngHelper;
import dev6.thirdParty.pngj.PngjException;
import dev6.thirdParty.pngj.PngjInputException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.CRC32;
import jv.number.PuString;

public class PngChunk {
    public final int len;
    public final String id;
    public final byte[] idbytes;
    public byte[] data = null;
    public Integer crcval = null;
    private final CRC32 crcengine;
    private String textKey;
    private String textVal;

    public PngChunk(int len, byte[] idbytes, CRC32 crcengine) {
        if (idbytes.length != 4) {
            throw new PngjException("bad chunk len");
        }
        this.idbytes = idbytes;
        this.id = new String(idbytes);
        this.len = len;
        this.crcengine = crcengine;
    }

    public static PngChunk createTextChunk(String key, String val, CRC32 crcengine) {
        if (val == null || key == null) {
            return null;
        }
        val = val.trim();
        key = key.trim();
        if (PuString.isEmpty((String)val) || PuString.isEmpty((String)key)) {
            return null;
        }
        try {
            byte[] b = (String.valueOf(key) + "\u0000" + val).getBytes("ISO-8859-1");
            PngChunk chunk = new PngChunk(b.length, PngHelper.ITEXT, crcengine);
            chunk.data = b;
            chunk.textKey = key;
            chunk.textVal = val;
            chunk.computeCrc();
            return chunk;
        }
        catch (UnsupportedEncodingException e) {
            throw new PngjInputException("bad textual data: Only latin1", e);
        }
    }

    public String getTextKeyword() {
        if (!this.id.equals("tEXt")) {
            return "";
        }
        if (this.textKey == null) {
            try {
                String[] k = new String(this.data, "ISO-8859-1").split("\u0000");
                this.textKey = k[0];
                this.textVal = k[1];
            }
            catch (UnsupportedEncodingException e) {
                throw new PngjException(e);
            }
        }
        return this.textKey;
    }

    public String getTextVal() {
        this.getTextKeyword();
        return this.textVal;
    }

    public void computeCrc() {
        this.crcengine.reset();
        this.crcengine.update(this.idbytes, 0, 4);
        this.crcengine.update(this.data, 0, this.len);
        this.crcval = (int)this.crcengine.getValue();
    }

    public boolean isCritical() {
        return (this.idbytes[0] & 0x20) == 0;
    }

    public boolean isPublic() {
        return (this.idbytes[1] & 0x20) == 0;
    }

    public boolean isSafeToCopy() {
        return (this.idbytes[3] & 0x20) != 0;
    }

    public void writeChunk(OutputStream os) {
        if (this.idbytes.length != 4) {
            throw new PngjException("bad chunkid [" + this.id + "]");
        }
        PngHelper.writeInt4(os, this.len);
        PngHelper.writeBytes(os, this.idbytes);
        PngHelper.writeBytes(os, this.data, 0, this.len);
        PngHelper.writeInt4(os, this.crcval);
    }

    public String toString() {
        return "chunkid=" + this.id + " len=" + this.len + " " + this.getTextKeyword();
    }

    public void readChunk(InputStream is) {
        if (this.data == null) {
            this.data = new byte[this.len];
        }
        PngHelper.readBytes(is, this.data, 0, this.len);
        int crcori = PngHelper.readInt4(is);
        this.computeCrc();
        if (crcori != this.crcval) {
            throw new RuntimeException("crc no coincide " + this.toString() + " calc=" + this.crcval + " read=" + crcori);
        }
    }

    public ByteArrayInputStream getAsByteStream() {
        return new ByteArrayInputStream(this.data);
    }
}

