/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.pngj;

import dev6.thirdParty.pngj.ImageInfo;
import dev6.thirdParty.pngj.PngjException;
import jv.number.PuString;

public class ImageLine {
    public final ImageInfo imgInfo;
    private final int len;
    protected final int channels;
    private final int bitDepth;
    public final int[] scanline;
    private int rown = -1;
    private static final double BIG_VALUE = 8.988465674311579E307;
    private static final double BIG_VALUE_NEG = -8.988465674311579E307;

    public ImageLine(ImageInfo imgInfo) {
        this.imgInfo = imgInfo;
        this.channels = imgInfo.channels;
        this.len = this.channels * imgInfo.cols;
        this.scanline = new int[this.len];
        this.bitDepth = imgInfo.bitDepth;
    }

    public String toString() {
        return "row=" + this.rown + " cols=" + this.imgInfo.cols + " bpc=" + this.imgInfo.bitDepth + " size=" + this.len;
    }

    public String infoFirstLastPixels() {
        return this.imgInfo.channels == 1 ? "first=(" + this.scanline[0] + ") last=(" + this.scanline[this.len - 1] + ")" : "first=(" + this.scanline[0] + " " + this.scanline[1] + " " + this.scanline[2] + ") last=(" + this.scanline[this.len - this.imgInfo.channels] + " " + this.scanline[this.len - this.imgInfo.channels + 1] + " " + this.scanline[this.len - this.imgInfo.channels + 2] + ")";
    }

    public ImageLineStats computeStats() {
        if (this.channels < 3) {
            throw new PngjException("ImageLineStats only works for RGB - RGBA");
        }
        ImageLineStats stat = new ImageLineStats();
        int ch = 0;
        int i = 0;
        while (i < this.imgInfo.cols) {
            double lum = 0.0;
            ch = this.channels - 1;
            while (ch >= 0) {
                double d;
                double x = this.int2double(this.scanline[i * this.channels]);
                if (ch < 3) {
                    lum += x;
                }
                int n = ch;
                stat.prom[n] = stat.prom[n] + x;
                if (x > stat.maxv[ch]) {
                    stat.maxv[ch] = x;
                }
                if (x < stat.minv[ch]) {
                    stat.minv[ch] = x;
                }
                if (i >= this.channels && (d = Math.abs(x - this.int2double(this.scanline[i - this.channels]))) > stat.maxdif[ch]) {
                    stat.maxdif[ch] = d;
                }
                --ch;
            }
            stat.promlum += lum;
            if (lum > stat.maxlum) {
                stat.maxlum = lum;
            }
            if (lum < stat.minlum) {
                stat.minlum = lum;
            }
            ++i;
        }
        ch = 0;
        while (ch < this.channels) {
            int n = ch++;
            stat.prom[n] = stat.prom[n] / (double)this.imgInfo.cols;
        }
        stat.promlum /= (double)this.imgInfo.cols * 3.0;
        stat.maxlum /= 3.0;
        stat.minlum /= 3.0;
        return stat;
    }

    public void setValD(int i, double d) {
        this.scanline[i] = this.double2int(d);
    }

    public double int2double(int p) {
        return this.bitDepth == 16 ? (double)p / 65535.0 : (double)p / 255.0;
    }

    public int double2int(double d) {
        d = d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
        return this.bitDepth == 16 ? (int)(d * 65535.0 + 0.5) : (int)(d * 255.0 + 0.5);
    }

    public int double2intClamped(double d) {
        d = d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
        return this.bitDepth == 16 ? (int)(d * 65535.0 + 0.5) : (int)(d * 255.0 + 0.5);
    }

    public int getRown() {
        return this.rown;
    }

    public void incRown() {
        ++this.rown;
    }

    public void setRown(int n) {
        this.rown = n;
    }

    public class ImageLineStats {
        public double[] prom = new double[]{0.0, 0.0, 0.0, 0.0};
        public double[] maxv = new double[]{-8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307};
        public double[] minv = new double[]{8.988465674311579E307, 8.988465674311579E307, 8.988465674311579E307, 8.988465674311579E307};
        public double promlum = 0.0;
        public double maxlum = -8.988465674311579E307;
        public double minlum = 8.988465674311579E307;
        public double[] maxdif = new double[]{-8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307, 8.988465674311579E307};

        public String toString() {
            return ImageLine.this.channels == 3 ? "prom=" + this.format(this.promlum) + " (" + this.format(this.prom[2]) + this.format(this.prom[0]) + " " + this.format(this.prom[1]) + ") " + "max=" + this.format(this.maxlum) + " (" + this.format(this.maxv[0]) + " " + this.format(this.maxv[1]) + " " + this.format(this.maxv[2]) + ") " + "min=" + this.format(this.minlum) + " (" + this.format(this.minv[0]) + " " + this.format(this.minv[1]) + " " + this.format(this.minv[2]) + ") " + "maxdif=(" + this.format(this.maxdif[0]) + " " + this.format(this.maxdif[1]) + " " + this.format(this.maxdif[2]) + ") " : "prom=" + this.format(this.promlum) + " (" + this.format(this.prom[0]) + " " + this.format(this.prom[1]) + " " + this.format(this.prom[2]) + " " + this.format(this.prom[3]) + ") max=" + this.format(this.maxlum) + " (" + this.format(this.maxv[0]) + " " + this.format(this.maxv[1]) + " " + this.format(this.maxv[2]) + " " + this.format(this.maxv[3]) + ") min=" + this.format(this.minlum) + " (" + this.format(this.minv[0]) + " " + this.format(this.minv[1]) + " " + this.format(this.minv[2]) + " " + this.format(this.minv[3]) + ")" + " maxdif=(" + this.format(this.maxdif[0]) + " " + this.format(this.maxdif[1]) + " " + this.format(this.maxdif[2]) + " " + this.format(this.maxdif[3]) + ")";
        }

        private String format(double d) {
            return PuString.toString((double)d, (int)1);
        }
    }
}

