/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.pngj;

import dev6.thirdParty.pngj.PngjException;

public class ImageInfo {
    public final int cols;
    public final int rows;
    public final int bitDepth;
    public final int channels;
    public final int bytesPixel;
    public final int samplesPerRow;
    public final boolean alpha;
    public final boolean greyscale;
    public final boolean indexed;
    private static final int MAX_COLS_ROWS_VAL = 100000;

    public ImageInfo(int cols, int rows, int bitdepth, boolean alpha) {
        this(cols, rows, bitdepth, alpha, false, false);
    }

    public ImageInfo(int cols, int rows, int bitdepth, boolean alpha, boolean grayscale, boolean palette) {
        this.cols = cols;
        this.rows = rows;
        this.alpha = alpha;
        this.indexed = palette;
        this.greyscale = grayscale;
        if (this.greyscale && palette) {
            throw new PngjException("palette and greyscale are exclusive");
        }
        this.channels = grayscale || palette ? (alpha ? 2 : 1) : (alpha ? 4 : 3);
        this.samplesPerRow = this.channels * this.cols;
        this.bitDepth = bitdepth;
        switch (this.bitDepth) {
            case 1: 
            case 2: 
            case 4: {
                if (this.indexed || this.greyscale) break;
                throw new PngjException("only indexed or grayscale can have bitdepth=" + this.bitDepth);
            }
            case 8: {
                break;
            }
            case 16: {
                if (!this.indexed) break;
                throw new PngjException("indexed can't have bitdepth=" + this.bitDepth);
            }
            default: {
                throw new PngjException("invalid bitdepth=" + this.bitDepth);
            }
        }
        if (this.bitDepth < 8) {
            throw new PngjException("sorry, unsupported (though valid) bitdepth=" + this.bitDepth);
        }
        this.bytesPixel = this.channels * this.bitDepth / 8;
        if (cols < 1 || cols > 100000) {
            throw new PngjException("cols=" + cols + " ???");
        }
        if (rows < 1 || rows > 100000) {
            throw new PngjException("rows=" + rows + " ???");
        }
    }

    public String toString() {
        return "cols=" + this.cols + " rows=" + this.rows + " bitspc=" + this.bitDepth + " channels=" + this.channels;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ImageInfo) {
            return this.toString().equals(((ImageInfo)obj).toString());
        }
        return super.equals(obj);
    }
}

