/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.csparsej;

import dev6.thirdParty.csparsej.Dcs;
import dev6.thirdParty.csparsej.Dcs_common;
import dev6.thirdParty.csparsej.Dcs_house;
import dev6.thirdParty.csparsej.Dcs_scatter;
import dev6.thirdParty.csparsej.Dcs_sqr;
import dev6.thirdParty.csparsej.Dcs_util;
import dev6.thirdParty.csparsej.Dcss;

public class Dcs_qr {
    public static Dcs_common.Dcsn cs_qr(Dcs A, Dcss S) {
        Dcs R;
        Dcs V;
        if (A == null || !A.hasCSCFormat() || S == null) {
            return null;
        }
        int n = A.n;
        int[] Ap = A.p;
        int[] Ai = A.ind;
        double[] Ax = A.values;
        int[] q = S.q;
        int[] parent = S.parent;
        int[] pinv = S.pinv;
        int m2 = S.m2;
        int vnz = S.lnz;
        int rnz = S.unz;
        int[] leftmost = S.leftmost;
        int[] w = new int[m2 + n];
        double[] x = new double[m2];
        Dcs_common.Dcsn N = new Dcs_common.Dcsn();
        int[] s = w;
        int s_offset = m2;
        int k = 0;
        while (k < m2) {
            x[k] = 0.0;
            ++k;
        }
        N.L = V = new Dcs(m2, n, vnz, true, false);
        N.U = R = new Dcs(m2, n, rnz, true, false);
        double[] Beta = new double[n];
        N.B = Beta;
        int[] Rp = R.p;
        int[] Ri = R.ind;
        double[] Rx = R.values;
        int[] Vp = V.p;
        int[] Vi = V.ind;
        double[] Vx = V.values;
        int i = 0;
        while (i < m2) {
            w[i] = -1;
            ++i;
        }
        rnz = 0;
        vnz = 0;
        k = 0;
        while (k < n) {
            int p1;
            Rp[k] = rnz;
            Vp[k] = p1 = vnz;
            w[k] = k;
            Vi[vnz++] = k;
            int top = n;
            int col = q != null ? q[k] : k;
            int p = Ap[col];
            while (p < Ap[col + 1]) {
                i = leftmost[Ai[p]];
                int len = 0;
                while (w[i] != k) {
                    s[s_offset + len++] = i;
                    w[i] = k;
                    i = parent[i];
                }
                while (len > 0) {
                    s[s_offset + --top] = s[s_offset + --len];
                }
                i = pinv[Ai[p]];
                x[i] = Ax[p];
                if (i > k && w[i] < k) {
                    Vi[vnz++] = i;
                    w[i] = k;
                }
                ++p;
            }
            p = top;
            while (p < n) {
                i = s[s_offset + p];
                Dcs_house.cs_happly(V, i, Beta[i], x);
                Ri[rnz] = i;
                Rx[rnz++] = x[i];
                x[i] = 0.0;
                if (parent[i] == k) {
                    vnz = Dcs_scatter.cs_scatter(V, i, 0.0, w, null, k, V, vnz);
                }
                ++p;
            }
            p = p1;
            while (p < vnz) {
                Vx[p] = x[Vi[p]];
                x[Vi[p]] = 0.0;
                ++p;
            }
            Ri[rnz] = k;
            double[] beta = new double[]{Beta[k]};
            Rx[rnz++] = Dcs_house.cs_house(Vx, p1, beta, vnz - p1);
            Beta[k] = beta[0];
            ++k;
        }
        Rp[n] = rnz;
        Vp[n] = vnz;
        return N;
    }

    public static boolean cs_qrsol(int order, Dcs A, double[] b) {
        boolean ok;
        Dcs AT = null;
        if (A == null || !A.hasCSCFormat() || b == null) {
            return false;
        }
        int m = A.m;
        int n = A.n;
        if (m >= n) {
            Dcss S = Dcs_sqr.cs_sqr(order, A, true);
            Dcs_common.Dcsn N = Dcs_qr.cs_qr(A, S);
            double[] x = new double[S != null ? S.m2 : 1];
            boolean bl = ok = S != null && N != null;
            if (ok) {
                Dcs_util.cs_ipvec(S.pinv, b, x, m);
                int k = 0;
                while (k < n) {
                    Dcs_house.cs_happly(N.L, k, N.B[k], x);
                    ++k;
                }
                Dcs.cs_usolve(N.U, x);
                Dcs_util.cs_ipvec(S.q, x, b, n);
            }
        } else {
            AT = Dcs.cs_transpose(A, true);
            Dcss S = Dcs_sqr.cs_sqr(order, AT, true);
            Dcs_common.Dcsn N = Dcs_qr.cs_qr(AT, S);
            double[] x = new double[S != null ? S.m2 : 1];
            boolean bl = ok = AT != null && S != null && N != null;
            if (ok) {
                Dcs_util.cs_pvec(S.q, b, x, m);
                Dcs_qr.cs_utsolve(N.U, x);
                int k = m - 1;
                while (k >= 0) {
                    Dcs_house.cs_happly(N.L, k, N.B[k], x);
                    --k;
                }
                Dcs_util.cs_pvec(S.pinv, x, b, n);
            }
        }
        return ok;
    }

    public static boolean cs_utsolve(Dcs U, double[] x) {
        if (U == null || !U.hasCSCFormat() || x == null) {
            return false;
        }
        int n = U.n;
        int[] Up = U.p;
        int[] Ui = U.ind;
        double[] Ux = U.values;
        int j = 0;
        while (j < n) {
            int p = Up[j];
            while (p < Up[j + 1] - 1) {
                int n2 = j;
                x[n2] = x[n2] - Ux[p] * x[Ui[p]];
                ++p;
            }
            int n3 = j;
            x[n3] = x[n3] / Ux[Up[j + 1] - 1];
            ++j;
        }
        return true;
    }
}

