/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.csparsej;

import dev6.thirdParty.csparsej.Dcs;
import dev6.thirdParty.csparsej.Dcs_chol;
import dev6.thirdParty.csparsej.Dcs_common;
import dev6.thirdParty.csparsej.Dcs_dfs;
import dev6.thirdParty.csparsej.Dcs_sqr;
import dev6.thirdParty.csparsej.Dcs_util;
import dev6.thirdParty.csparsej.Dcss;

public class Dcs_lu {
    public static Dcs_common.Dcsn cs_lu(Dcs A, Dcss S, double tol) {
        int p;
        int[] Li;
        Dcs U;
        Dcs L;
        if (A == null || !A.hasCSCFormat() || S == null) {
            return null;
        }
        int n = A.n;
        int[] q = S.q;
        int lnz = S.lnz;
        int unz = S.unz;
        double[] x = new double[n];
        int[] xi = new int[2 * n];
        Dcs_common.Dcsn N = new Dcs_common.Dcsn();
        N.L = L = new Dcs(n, n, lnz, true, false);
        N.U = U = new Dcs(n, n, unz, true, false);
        int[] pinv = new int[n];
        N.pinv = pinv;
        int[] Lp = L.p;
        int[] Up = U.p;
        int i = 0;
        while (i < n) {
            x[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < n) {
            pinv[i] = -1;
            ++i;
        }
        int k = 0;
        while (k <= n) {
            Lp[k] = 0;
            ++k;
        }
        unz = 0;
        lnz = 0;
        k = 0;
        while (k < n) {
            Lp[k] = lnz;
            Up[k] = unz;
            if (lnz + n > L.nzmax) {
                Dcs_util.cs_sprealloc(L, 2 * L.nzmax + n);
            }
            if (unz + n > U.nzmax) {
                Dcs_util.cs_sprealloc(U, 2 * U.nzmax + n);
            }
            Li = L.ind;
            double[] Lx = L.values;
            int[] Ui = U.ind;
            double[] Ux = U.values;
            int col = q != null ? q[k] : k;
            int top = Dcs_lu.cs_spsolve(L, A, col, xi, x, pinv, true);
            int ipiv = -1;
            double a = -1.0;
            p = top;
            while (p < n) {
                i = xi[p];
                if (pinv[i] < 0) {
                    double d;
                    double t = Math.abs(x[i]);
                    if (d > a) {
                        a = t;
                        ipiv = i;
                    }
                } else {
                    Ui[unz] = pinv[i];
                    Ux[unz++] = x[i];
                }
                ++p;
            }
            if (ipiv == -1 || a <= 0.0) {
                return null;
            }
            if (pinv[col] < 0 && Math.abs(x[col]) >= a * tol) {
                ipiv = col;
            }
            double pivot = x[ipiv];
            Ui[unz] = k;
            Ux[unz++] = pivot;
            pinv[ipiv] = k;
            Li[lnz] = ipiv;
            Lx[lnz++] = 1.0;
            p = top;
            while (p < n) {
                i = xi[p];
                if (pinv[i] < 0) {
                    Li[lnz] = i;
                    Lx[lnz++] = x[i] / pivot;
                }
                x[i] = 0.0;
                ++p;
            }
            ++k;
        }
        Lp[n] = lnz;
        Up[n] = unz;
        Li = L.ind;
        p = 0;
        while (p < lnz) {
            Li[p] = pinv[Li[p]];
            ++p;
        }
        Dcs_util.cs_sprealloc(L, 0);
        Dcs_util.cs_sprealloc(U, 0);
        return N;
    }

    public static boolean cs_lusol(int order, Dcs A, double[] b, double tol) {
        boolean ok;
        if (A == null || !A.hasCSCFormat() || b == null) {
            return false;
        }
        int n = A.n;
        Dcss S = Dcs_sqr.cs_sqr(order, A, false);
        Dcs_common.Dcsn N = Dcs_lu.cs_lu(A, S, tol);
        double[] x = new double[n];
        boolean bl = ok = S != null && N != null;
        if (ok) {
            Dcs_util.cs_ipvec(N.pinv, b, x, n);
            Dcs_chol.cs_lsolve(N.L, x);
            Dcs.cs_usolve(N.U, x);
            Dcs_util.cs_ipvec(S.q, x, b, n);
        }
        return ok;
    }

    private static int cs_reach(Dcs G, Dcs B, int k, int[] xi, int[] pinv) {
        if (G == null || !G.hasCSCFormat() || B == null || !B.hasCSCFormat() || xi == null) {
            return -1;
        }
        int n = G.n;
        int[] Bp = B.p;
        int[] Bi = B.ind;
        int[] Gp = G.p;
        int top = n;
        int p = Bp[k];
        while (p < Bp[k + 1]) {
            if (!Dcs_util.CS_MARKED(Gp, Bi[p])) {
                top = Dcs_dfs.cs_dfs(Bi[p], G, top, xi, 0, xi, n, pinv, 0);
            }
            ++p;
        }
        p = top;
        while (p < n) {
            Dcs_util.CS_MARK(Gp, xi[p]);
            ++p;
        }
        return top;
    }

    private static int cs_spsolve(Dcs G, Dcs B, int k, int[] xi, double[] x, int[] pinv, boolean lo) {
        int top;
        if (G == null || !G.hasCSCFormat() || B == null || !B.hasCSCFormat() || xi == null || x == null) {
            return -1;
        }
        int[] Gp = G.p;
        int[] Gi = G.ind;
        double[] Gx = G.values;
        int n = G.n;
        int[] Bp = B.p;
        int[] Bi = B.ind;
        double[] Bx = B.values;
        int p = top = Dcs_lu.cs_reach(G, B, k, xi, pinv);
        while (p < n) {
            x[xi[p]] = 0.0;
            ++p;
        }
        p = Bp[k];
        while (p < Bp[k + 1]) {
            x[Bi[p]] = Bx[p];
            ++p;
        }
        int px = top;
        while (px < n) {
            int J;
            int j = xi[px];
            int n2 = J = pinv != null ? pinv[j] : j;
            if (J >= 0) {
                int n3 = j;
                x[n3] = x[n3] / Gx[lo ? Gp[J] : Gp[J + 1] - 1];
                p = lo ? Gp[J] + 1 : Gp[J];
                int q = lo ? Gp[J + 1] : Gp[J + 1] - 1;
                while (p < q) {
                    int n4 = Gi[p];
                    x[n4] = x[n4] - Gx[p] * x[j];
                    ++p;
                }
            }
            ++px;
        }
        return top;
    }
}

