/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.csparsej;

import dev6.thirdParty.csparsej.Dcs;
import dev6.thirdParty.csparsej.Dcs_amd;
import dev6.thirdParty.csparsej.Dcs_common;
import dev6.thirdParty.csparsej.Dcs_counts;
import dev6.thirdParty.csparsej.Dcs_cumsum;
import dev6.thirdParty.csparsej.Dcs_ereach;
import dev6.thirdParty.csparsej.Dcs_etree;
import dev6.thirdParty.csparsej.Dcs_post;
import dev6.thirdParty.csparsej.Dcs_util;
import dev6.thirdParty.csparsej.Dcss;

public class Dcs_chol {
    public static Dcs_common.Dcsn cs_chol(Dcs A, Dcss S) {
        Dcs L;
        if (A == null || !A.hasCSCFormat() || S == null || S.cp == null || S.parent == null) {
            return null;
        }
        int n = A.n;
        Dcs_common.Dcsn N = new Dcs_common.Dcsn();
        int[] c = new int[2 * n];
        double[] x = new double[n];
        int[] cp = S.cp;
        int[] pinv = S.pinv;
        int[] parent = S.parent;
        Dcs C = pinv != null ? Dcs_chol.cs_symperm(A, pinv, true) : A;
        int[] s = c;
        int s_offset = n;
        int[] Cp = C.p;
        int[] Ci = C.ind;
        double[] Cx = C.values;
        N.L = L = new Dcs(n, n, cp[n], true, false);
        int[] Lp = L.p;
        int[] Li = L.ind;
        double[] Lx = L.values;
        int k = 0;
        while (k < n) {
            Lp[k] = c[k] = cp[k];
            ++k;
        }
        k = 0;
        while (k < n) {
            int top = Dcs_ereach.cs_ereach(C, k, parent, s, s_offset, c);
            x[k] = 0.0;
            int p = Cp[k];
            while (p < Cp[k + 1]) {
                if (Ci[p] <= k) {
                    x[Ci[p]] = Cx[p];
                }
                ++p;
            }
            double d = x[k];
            x[k] = 0.0;
            while (top < n) {
                int i = s[s_offset + top];
                double lki = x[i] / Lx[Lp[i]];
                x[i] = 0.0;
                p = Lp[i] + 1;
                while (p < c[i]) {
                    int n2 = Li[p];
                    x[n2] = x[n2] - Lx[p] * lki;
                    ++p;
                }
                d -= lki * lki;
                int n3 = i;
                int n4 = c[n3];
                c[n3] = n4 + 1;
                p = n4;
                Li[p] = k;
                Lx[p] = lki;
                ++top;
            }
            if (d <= 0.0) {
                return null;
            }
            int n5 = k;
            int n6 = c[n5];
            c[n5] = n6 + 1;
            p = n6;
            Li[p] = k++;
            Lx[p] = Math.sqrt(d);
        }
        Lp[n] = cp[n];
        return N;
    }

    public static boolean cs_cholsol(int order, Dcs A, double[] b) {
        if (A == null || !A.hasCSCFormat() || b == null) {
            return false;
        }
        int n = A.n;
        Dcss S = Dcs_chol.cs_schol(order, A);
        Dcs_common.Dcsn N = Dcs_chol.cs_chol(A, S);
        double[] x = new double[n];
        if (S == null || N == null) {
            return false;
        }
        Dcs_util.cs_ipvec(S.pinv, b, x, n);
        Dcs_chol.cs_lsolve(N.L, x);
        Dcs_chol.cs_ltsolve(N.L, x);
        Dcs_util.cs_pvec(S.pinv, x, b, n);
        return true;
    }

    public static boolean cs_lsolve(Dcs L, double[] x) {
        if (L == null || !L.hasCSCFormat() || x == null) {
            return false;
        }
        int n = L.n;
        int[] Lp = L.p;
        int[] Li = L.ind;
        double[] Lx = L.values;
        int j = 0;
        while (j < n) {
            int n2 = j;
            x[n2] = x[n2] / Lx[Lp[j]];
            int p = Lp[j] + 1;
            while (p < Lp[j + 1]) {
                int n3 = Li[p];
                x[n3] = x[n3] - Lx[p] * x[j];
                ++p;
            }
            ++j;
        }
        return true;
    }

    public static boolean cs_ltsolve(Dcs L, double[] x) {
        if (L == null || !L.hasCSCFormat() || x == null) {
            return false;
        }
        int n = L.n;
        int[] Lp = L.p;
        int[] Li = L.ind;
        double[] Lx = L.values;
        int j = n - 1;
        while (j >= 0) {
            int p = Lp[j] + 1;
            while (p < Lp[j + 1]) {
                int n2 = j;
                x[n2] = x[n2] - Lx[p] * x[Li[p]];
                ++p;
            }
            int n3 = j;
            x[n3] = x[n3] / Lx[Lp[j]];
            --j;
        }
        return true;
    }

    public static Dcs cs_symperm(Dcs A, int[] pinv, boolean values) {
        int i2;
        int i;
        int p;
        int j2;
        if (A == null || !A.hasCSCFormat()) {
            return null;
        }
        int n = A.n;
        int[] Ap = A.p;
        int[] Ai = A.ind;
        double[] Ax = A.values;
        Dcs C = new Dcs(n, n, Ap[n], values && Ax != null, false);
        int[] w = new int[n];
        int[] Cp = C.p;
        int[] Ci = C.ind;
        double[] Cx = C.values;
        int j = 0;
        while (j < n) {
            j2 = pinv != null ? pinv[j] : j;
            p = Ap[j];
            while (p < Ap[j + 1]) {
                i = Ai[p];
                if (i <= j) {
                    i2 = pinv != null ? pinv[i] : i;
                    int n2 = Math.max(i2, j2);
                    w[n2] = w[n2] + 1;
                }
                ++p;
            }
            ++j;
        }
        Dcs_cumsum.cs_cumsum(Cp, w, n);
        j = 0;
        while (j < n) {
            j2 = pinv != null ? pinv[j] : j;
            p = Ap[j];
            while (p < Ap[j + 1]) {
                i = Ai[p];
                if (i <= j) {
                    i2 = pinv != null ? pinv[i] : i;
                    int n3 = Math.max(i2, j2);
                    w[n3] = w[n3] + 1;
                    Ci[q] = Math.min(i2, j2);
                    if (Cx != null) {
                        Cx[q] = Ax[p];
                    }
                }
                ++p;
            }
            ++j;
        }
        return C;
    }

    public static Dcss cs_schol(int order, Dcs A) {
        if (A == null || !A.hasCSCFormat()) {
            return null;
        }
        int n = A.n;
        Dcss S = new Dcss();
        int[] P = Dcs_amd.cs_amd(order, A);
        S.pinv = Dcs_util.cs_pinv(P, n);
        if (order != 0 && S.pinv == null) {
            return null;
        }
        Dcs C = Dcs_chol.cs_symperm(A, S.pinv, false);
        S.parent = Dcs_etree.cs_etree(C, false);
        int[] post = Dcs_post.cs_post(S.parent, n);
        int[] c = Dcs_counts.cs_counts(C, S.parent, post, false);
        S.cp = new int[n + 1];
        S.unz = S.lnz = Dcs_cumsum.cs_cumsum(S.cp, c, n);
        return S.lnz >= 0 ? S : null;
    }

    public static boolean cs_updown(Dcs L, int sigma, Dcs C, int[] parent) {
        double beta = 1.0;
        double beta2 = 1.0;
        if (L == null || !L.hasCSCFormat() || C == null || !C.hasCSCFormat() || parent == null) {
            return false;
        }
        int[] Lp = L.p;
        int[] Li = L.ind;
        double[] Lx = L.values;
        int n = L.n;
        int[] Cp = C.p;
        int[] Ci = C.ind;
        double[] Cx = C.values;
        int p = Cp[0];
        if (p >= Cp[1]) {
            return true;
        }
        double[] w = new double[n];
        int f = Ci[p];
        while (p < Cp[1]) {
            f = Math.min(f, Ci[p]);
            ++p;
        }
        p = Cp[0];
        while (p < Cp[1]) {
            w[Ci[p]] = Cx[p];
            ++p;
        }
        int j = f;
        while (j != -1) {
            p = Lp[j];
            double alpha = w[j] / Lx[p];
            beta2 = beta * beta + (double)sigma * alpha * alpha;
            if (beta2 <= 0.0) break;
            beta2 = Math.sqrt(beta2);
            double delta = sigma > 0 ? beta / beta2 : beta2 / beta;
            double gamma = (double)sigma * alpha / (beta2 * beta);
            Lx[p] = delta * Lx[p] + (sigma > 0 ? gamma * w[j] : 0.0);
            beta = beta2;
            ++p;
            while (p < Lp[j + 1]) {
                double w2;
                double w1 = w[Li[p]];
                w[Li[p]] = w2 = w1 - alpha * Lx[p];
                Lx[p] = delta * Lx[p] + gamma * (sigma > 0 ? w1 : w2);
                ++p;
            }
            j = parent[j];
        }
        return beta2 > 0.0;
    }
}

