/*
 * Decompiled with CFR 0.152.
 */
package dev6.thirdParty.csparsej;

import dev6.thirdParty.csparsej.Dcs_cumsum;
import dev6.thirdParty.csparsej.Dcs_scatter;
import dev6.thirdParty.csparsej.Dcs_util;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnSparseMatrix;

public class Dcs {
    public int nzmax;
    public int m;
    public int n;
    public int[] p;
    public int[] ind;
    public double[] values;
    public int nz;

    public Dcs(PnSparseMatrix A) {
        this(A.getNumRows(), A.getNumCols(), A.getNumEntries().sum(), true, true);
        this.m = A.getNumRows();
        this.n = A.getNumCols();
        int row = 0;
        while (row < A.getNumRows()) {
            PiVector indices = A.getColIndices(row);
            PdVector vals = A.getEntries(row);
            int j = 0;
            while (j < A.getNumEntries(row)) {
                int col = indices.getEntry(j);
                double entry = vals.getEntry(j);
                this.addEntry(row, col, entry);
                ++j;
            }
            ++row;
        }
    }

    public boolean addEntry(int i, int j, double x) {
        if (!this.hasTripletFormat() || i < 0 || j < 0) {
            return false;
        }
        if (this.nz >= this.nzmax) {
            Dcs_util.cs_sprealloc(this, 2 * this.nzmax);
        }
        if (this.values != null) {
            this.values[this.nz] = x;
        }
        this.ind[this.nz] = i;
        this.p[this.nz++] = j;
        this.m = Math.max(this.m, i + 1);
        this.n = Math.max(this.n, j + 1);
        return true;
    }

    public PnSparseMatrix toPnSparseMatrix() {
        PnSparseMatrix mat = new PnSparseMatrix(this.m, this.n);
        if (this.hasCSCFormat()) {
            int j = 0;
            while (j < this.n) {
                int pj = this.p[j];
                while (pj < this.p[j + 1]) {
                    mat.addEntry(j, this.ind[pj], this.values != null ? this.values[pj] : 1.0);
                    ++pj;
                }
                ++j;
            }
        } else {
            int pj = 0;
            while (pj < this.nz) {
                mat.addEntry(this.ind[pj], this.p[pj], this.values != null ? this.values[pj] : 1.0);
                ++pj;
            }
            mat.validate();
        }
        return mat;
    }

    public Dcs(int m, int n, int nzmax, boolean values, boolean triplet) {
        this.m = m;
        this.n = n;
        this.nzmax = nzmax = Math.max(nzmax, 1);
        this.nz = triplet ? 0 : -1;
        this.p = triplet ? new int[nzmax] : new int[n + 1];
        this.ind = new int[nzmax];
        this.values = values ? new double[nzmax] : null;
    }

    public Dcs toCSC() {
        if (!this.hasTripletFormat()) {
            return this;
        }
        Dcs C = new Dcs(this.m, this.n, this.nz, this.values != null, false);
        int[] w = new int[this.n];
        int k = 0;
        while (k < this.nz) {
            int n = this.p[k];
            w[n] = w[n] + 1;
            ++k;
        }
        Dcs_cumsum.cs_cumsum(C.p, w, this.n);
        k = 0;
        while (k < this.nz) {
            int n = this.p[k];
            w[n] = w[n] + 1;
            C.ind[pp] = this.ind[k];
            if (this.values != null) {
                C.values[pp] = this.values[k];
            }
            ++k;
        }
        return C;
    }

    public boolean hasCSCFormat() {
        return this.nz == -1;
    }

    public boolean hasTripletFormat() {
        return this.nz >= 0;
    }

    public static double cs_norm(Dcs A) {
        return A.norm();
    }

    public double norm() {
        if (!this.hasCSCFormat() || this.values == null) {
            return -1.0;
        }
        double norm = 0.0;
        int j = 0;
        while (j < this.n) {
            double s = 0.0;
            int i = this.p[j];
            while (i < this.p[j + 1]) {
                s += Math.abs(this.values[i]);
                ++i;
            }
            norm = Math.max(norm, s);
            ++j;
        }
        return norm;
    }

    public String print(boolean brief) {
        StringBuffer str = new StringBuffer();
        if (this.nz < 0) {
            str.append(String.format("%d-by-%d, nzmax: %d nnz: %d, 1-norm: %g\n", this.m, this.n, this.nzmax, this.p[this.n], Dcs.cs_norm(this)));
            int j = 0;
            while (j < this.n) {
                System.out.print(String.format("    col %d : locations %d to %d\n", j, this.p[j], this.p[j + 1] - 1));
                int pj = this.p[j];
                while (pj < this.p[j + 1]) {
                    System.out.print(String.format("      %d : %g\n", this.ind[pj], this.values != null ? this.values[pj] : 1.0));
                    if (brief && pj > 20) {
                        str.append("  ...\n");
                        return str.toString();
                    }
                    ++pj;
                }
                ++j;
            }
        } else {
            str.append(String.format("triplet: %d-by-%d, nzmax: %d nnz: %d\n", this.m, this.n, this.nzmax, this.nz));
            int pj = 0;
            while (pj < this.nz) {
                str.append(String.format("    %d %d : %g\n", this.ind[pj], this.p[pj], this.values != null ? this.values[pj] : 1.0));
                if (brief && pj > 20) {
                    str.append("  ...\n");
                    return str.toString();
                }
                ++pj;
            }
        }
        return str.toString();
    }

    public static Dcs cs_permute(Dcs A, int[] pinv, int[] q, boolean values) {
        int nz = 0;
        if (A == null || !A.hasCSCFormat()) {
            return null;
        }
        int m = A.m;
        int n = A.n;
        int[] Ap = A.p;
        int[] Ai = A.ind;
        double[] Ax = A.values;
        Dcs C = new Dcs(m, n, Ap[n], values && Ax != null, false);
        int[] Cp = C.p;
        int[] Ci = C.ind;
        double[] Cx = C.values;
        int k = 0;
        while (k < n) {
            Cp[k] = nz;
            int j = q != null ? q[k] : k;
            int t = Ap[j];
            while (t < Ap[j + 1]) {
                if (Cx != null) {
                    Cx[nz] = Ax[t];
                }
                Ci[nz++] = pinv != null ? pinv[Ai[t]] : Ai[t];
                ++t;
            }
            ++k;
        }
        Cp[n] = nz;
        return C;
    }

    public static Dcs cs_transpose(Dcs A, boolean values) {
        if (A == null || !A.hasCSCFormat()) {
            return null;
        }
        int m = A.m;
        int n = A.n;
        int[] Ap = A.p;
        int[] Ai = A.ind;
        double[] Ax = A.values;
        Dcs C = new Dcs(n, m, Ap[n], values && Ax != null, false);
        int[] w = new int[m];
        int[] Cp = C.p;
        int[] Ci = C.ind;
        double[] Cx = C.values;
        int p = 0;
        while (p < Ap[n]) {
            int n2 = Ai[p];
            w[n2] = w[n2] + 1;
            ++p;
        }
        Dcs_cumsum.cs_cumsum(Cp, w, m);
        int j = 0;
        while (j < n) {
            p = Ap[j];
            while (p < Ap[j + 1]) {
                int n3 = Ai[p];
                w[n3] = w[n3] + 1;
                Ci[q] = j;
                if (Cx != null) {
                    Cx[q] = Ax[p];
                }
                ++p;
            }
            ++j;
        }
        return C;
    }

    public static Dcs cs_multiply(Dcs A, Dcs B) {
        int nz = 0;
        if (A == null || !A.hasCSCFormat() || B == null || !B.hasCSCFormat()) {
            return null;
        }
        if (A.n != B.m) {
            return null;
        }
        int m = A.m;
        int anz = A.p[A.n];
        int n = B.n;
        int[] Bp = B.p;
        int[] Bi = B.ind;
        double[] Bx = B.values;
        int bnz = Bp[n];
        int[] w = new int[m];
        boolean values = A.values != null && Bx != null;
        double[] x = values ? new double[m] : null;
        Dcs C = new Dcs(m, n, anz + bnz, values, false);
        int[] Cp = C.p;
        int j = 0;
        while (j < n) {
            if (nz + m > C.nzmax) {
                Dcs_util.cs_sprealloc(C, 2 * C.nzmax + m);
            }
            int[] Ci = C.ind;
            double[] Cx = C.values;
            Cp[j] = nz;
            int p = Bp[j];
            while (p < Bp[j + 1]) {
                nz = Dcs_scatter.cs_scatter(A, Bi[p], Bx != null ? Bx[p] : 1.0, w, x, j + 1, C, nz);
                ++p;
            }
            if (values) {
                p = Cp[j];
                while (p < nz) {
                    Cx[p] = x[Ci[p]];
                    ++p;
                }
            }
            ++j;
        }
        Cp[n] = nz;
        Dcs_util.cs_sprealloc(C, 0);
        return C;
    }

    public static Dcs cs_add(Dcs A, Dcs B, double alpha, double beta) {
        int nz = 0;
        if (A == null || !A.hasCSCFormat() || B == null || !B.hasCSCFormat()) {
            return null;
        }
        if (A.m != B.m || A.n != B.n) {
            return null;
        }
        int m = A.m;
        int anz = A.p[A.n];
        int n = B.n;
        int[] Bp = B.p;
        double[] Bx = B.values;
        int bnz = Bp[n];
        int[] w = new int[m];
        boolean values = A.values != null && Bx != null;
        double[] x = values ? new double[m] : null;
        Dcs C = new Dcs(m, n, anz + bnz, values, false);
        int[] Cp = C.p;
        int[] Ci = C.ind;
        double[] Cx = C.values;
        int j = 0;
        while (j < n) {
            Cp[j] = nz;
            nz = Dcs_scatter.cs_scatter(A, j, alpha, w, x, j + 1, C, nz);
            nz = Dcs_scatter.cs_scatter(B, j, beta, w, x, j + 1, C, nz);
            if (values) {
                int p = Cp[j];
                while (p < nz) {
                    Cx[p] = x[Ci[p]];
                    ++p;
                }
            }
            ++j;
        }
        Cp[n] = nz;
        Dcs_util.cs_sprealloc(C, 0);
        return C;
    }

    public static boolean cs_usolve(Dcs U, double[] x) {
        if (U == null || !U.hasCSCFormat() || x == null) {
            return false;
        }
        int n = U.n;
        int[] Up = U.p;
        int[] Ui = U.ind;
        double[] Ux = U.values;
        int j = n - 1;
        while (j >= 0) {
            int n2 = j;
            x[n2] = x[n2] / Ux[Up[j + 1] - 1];
            int p = Up[j];
            while (p < Up[j + 1] - 1) {
                int n3 = Ui[p];
                x[n3] = x[n3] - Ux[p] * x[j];
                ++p;
            }
            --j;
        }
        return true;
    }
}

